/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.inject.matcher;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.SuppressForbidden;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.matcher.AbstractMatcher;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.matcher.Matcher;

public class Matchers {
    private static final Matcher<Object> ANY = new Any();

    private Matchers() {
    }

    public static Matcher<Object> any() {
        return ANY;
    }

    public static <T> Matcher<T> not(Matcher<? super T> p) {
        return new Not<T>(p);
    }

    private static void checkForRuntimeRetention(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        if (retention == null || retention.value() != RetentionPolicy.RUNTIME) {
            throw new IllegalArgumentException("Annotation " + annotationType.getSimpleName() + " is missing RUNTIME retention");
        }
    }

    public static Matcher<AnnotatedElement> annotatedWith(Class<? extends Annotation> annotationType) {
        return new AnnotatedWithType(annotationType);
    }

    public static Matcher<AnnotatedElement> annotatedWith(Annotation annotation) {
        return new AnnotatedWith(annotation);
    }

    public static Matcher<Class> subclassesOf(Class<?> superclass) {
        return new SubclassesOf(superclass);
    }

    public static Matcher<Object> only(Object value) {
        return new Only(value);
    }

    public static Matcher<Object> identicalTo(Object value) {
        return new IdenticalTo(value);
    }

    public static Matcher<Class> inPackage(Package targetPackage) {
        return new InPackage(targetPackage);
    }

    public static Matcher<Class> inSubpackage(String targetPackageName) {
        return new InSubpackage(targetPackageName);
    }

    public static Matcher<Method> returns(Matcher<? super Class<?>> returnType) {
        return new Returns(returnType);
    }

    private static class Not<T>
    extends AbstractMatcher<T> {
        final Matcher<? super T> delegate;

        private Not(Matcher<? super T> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public boolean matches(T t) {
            return !this.delegate.matches(t);
        }

        public boolean equals(Object other) {
            return other instanceof Not && ((Not)other).delegate.equals(this.delegate);
        }

        public int hashCode() {
            return -this.delegate.hashCode();
        }

        public String toString() {
            return "not(" + String.valueOf(this.delegate) + ")";
        }
    }

    private static class AnnotatedWithType
    extends AbstractMatcher<AnnotatedElement> {
        private final Class<? extends Annotation> annotationType;

        AnnotatedWithType(Class<? extends Annotation> annotationType) {
            this.annotationType = Objects.requireNonNull(annotationType, "annotation type");
            Matchers.checkForRuntimeRetention(annotationType);
        }

        @Override
        public boolean matches(AnnotatedElement element) {
            return element.getAnnotation(this.annotationType) != null;
        }

        public boolean equals(Object other) {
            return other instanceof AnnotatedWithType && ((AnnotatedWithType)other).annotationType.equals(this.annotationType);
        }

        public int hashCode() {
            return 37 * this.annotationType.hashCode();
        }

        public String toString() {
            return "annotatedWith(" + this.annotationType.getSimpleName() + ".class)";
        }
    }

    private static class AnnotatedWith
    extends AbstractMatcher<AnnotatedElement> {
        private final Annotation annotation;

        AnnotatedWith(Annotation annotation) {
            this.annotation = Objects.requireNonNull(annotation, "annotation");
            Matchers.checkForRuntimeRetention(annotation.annotationType());
        }

        @Override
        public boolean matches(AnnotatedElement element) {
            Annotation fromElement = element.getAnnotation(this.annotation.annotationType());
            return fromElement != null && this.annotation.equals(fromElement);
        }

        public boolean equals(Object other) {
            return other instanceof AnnotatedWith && ((AnnotatedWith)other).annotation.equals(this.annotation);
        }

        public int hashCode() {
            return 37 * this.annotation.hashCode();
        }

        public String toString() {
            return "annotatedWith(" + String.valueOf(this.annotation) + ")";
        }
    }

    private static class SubclassesOf
    extends AbstractMatcher<Class> {
        private final Class<?> superclass;

        SubclassesOf(Class<?> superclass) {
            this.superclass = Objects.requireNonNull(superclass, "superclass");
        }

        @Override
        public boolean matches(Class subclass) {
            return this.superclass.isAssignableFrom(subclass);
        }

        public boolean equals(Object other) {
            return other instanceof SubclassesOf && ((SubclassesOf)other).superclass.equals(this.superclass);
        }

        public int hashCode() {
            return 37 * this.superclass.hashCode();
        }

        public String toString() {
            return "subclassesOf(" + this.superclass.getSimpleName() + ".class)";
        }
    }

    private static class Only
    extends AbstractMatcher<Object> {
        private final Object value;

        Only(Object value) {
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        public boolean matches(Object other) {
            return this.value.equals(other);
        }

        public boolean equals(Object other) {
            return other instanceof Only && ((Only)other).value.equals(this.value);
        }

        public int hashCode() {
            return 37 * this.value.hashCode();
        }

        public String toString() {
            return "only(" + String.valueOf(this.value) + ")";
        }
    }

    private static class IdenticalTo
    extends AbstractMatcher<Object> {
        private final Object value;

        IdenticalTo(Object value) {
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        public boolean matches(Object other) {
            return this.value == other;
        }

        public boolean equals(Object other) {
            return other instanceof IdenticalTo && ((IdenticalTo)other).value == this.value;
        }

        public int hashCode() {
            return 37 * System.identityHashCode(this.value);
        }

        public String toString() {
            return "identicalTo(" + String.valueOf(this.value) + ")";
        }
    }

    private static class InPackage
    extends AbstractMatcher<Class> {
        private final transient Package targetPackage;
        private final String packageName;

        InPackage(Package targetPackage) {
            this.targetPackage = Objects.requireNonNull(targetPackage, "package");
            this.packageName = targetPackage.getName();
        }

        @Override
        public boolean matches(Class c) {
            return c.getPackage().equals(this.targetPackage);
        }

        public boolean equals(Object other) {
            return other instanceof InPackage && ((InPackage)other).targetPackage.equals(this.targetPackage);
        }

        public int hashCode() {
            return 37 * this.targetPackage.hashCode();
        }

        public String toString() {
            return "inPackage(" + this.targetPackage.getName() + ")";
        }

        @SuppressForbidden(reason="ClassLoader.getDefinedPackage not available yet")
        public Object readResolve() {
            return Matchers.inPackage(Package.getPackage(this.packageName));
        }
    }

    private static class InSubpackage
    extends AbstractMatcher<Class> {
        private final String targetPackageName;

        InSubpackage(String targetPackageName) {
            this.targetPackageName = targetPackageName;
        }

        @Override
        public boolean matches(Class c) {
            String classPackageName = c.getPackage().getName();
            return classPackageName.equals(this.targetPackageName) || classPackageName.startsWith(this.targetPackageName + ".");
        }

        public boolean equals(Object other) {
            return other instanceof InSubpackage && ((InSubpackage)other).targetPackageName.equals(this.targetPackageName);
        }

        public int hashCode() {
            return 37 * this.targetPackageName.hashCode();
        }

        public String toString() {
            return "inSubpackage(" + this.targetPackageName + ")";
        }
    }

    private static class Returns
    extends AbstractMatcher<Method> {
        private final Matcher<? super Class<?>> returnType;

        Returns(Matcher<? super Class<?>> returnType) {
            this.returnType = Objects.requireNonNull(returnType, "return type matcher");
        }

        @Override
        public boolean matches(Method m) {
            return this.returnType.matches(m.getReturnType());
        }

        public boolean equals(Object other) {
            return other instanceof Returns && ((Returns)other).returnType.equals(this.returnType);
        }

        public int hashCode() {
            return 37 * this.returnType.hashCode();
        }

        public String toString() {
            return "returns(" + String.valueOf(this.returnType) + ")";
        }
    }

    private static class Any
    extends AbstractMatcher<Object> {
        private Any() {
        }

        @Override
        public boolean matches(Object o) {
            return true;
        }

        public String toString() {
            return "any()";
        }

        public Object readResolve() {
            return Matchers.any();
        }
    }
}

