/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.logging;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.MapBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.OpenSearchLogMessage;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;

public class DeprecatedMessage
extends OpenSearchLogMessage {
    public static final String X_OPAQUE_ID_FIELD_NAME = "x-opaque-id";
    private static final Set<String> keys = ConcurrentHashMap.newKeySet();
    private final String keyWithXOpaqueId;

    public DeprecatedMessage(String key, String xOpaqueId, String messagePattern, Object ... args) {
        super(DeprecatedMessage.fieldMap(key, xOpaqueId), messagePattern, args);
        this.keyWithXOpaqueId = key + xOpaqueId;
    }

    public static void resetDeprecatedMessageForTests() {
        keys.clear();
    }

    private static Map<String, Object> fieldMap(String key, String xOpaqueId) {
        MapBuilder<String, String> builder = MapBuilder.newMapBuilder();
        if (!Strings.isNullOrEmpty(key)) {
            builder.put("key", key);
        }
        if (!Strings.isNullOrEmpty(xOpaqueId)) {
            builder.put(X_OPAQUE_ID_FIELD_NAME, xOpaqueId);
        }
        return builder.immutableMap();
    }

    public boolean isAlreadyLogged() {
        return !keys.add(this.keyWithXOpaqueId);
    }
}

