/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.crypto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.CryptoMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.crypto.CryptoHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.crypto.MasterKeyProvider;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.crypto.CryptoRegistryException;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.CryptoKeyProviderPlugin;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.CryptoPlugin;

public class CryptoHandlerRegistry {
    private static final Logger logger = LogManager.getLogger(CryptoHandlerRegistry.class);
    SetOnce<Map<String, CryptoKeyProviderPlugin>> registry = new SetOnce();
    SetOnce<CryptoPlugin> cryptoHandlerPlugin = new SetOnce();
    private final Map<CryptoMetadata, CryptoHandler> registeredCryptoHandlers = new HashMap<CryptoMetadata, CryptoHandler>();
    private static volatile CryptoHandlerRegistry instance;
    private static final Object lock;

    protected CryptoHandlerRegistry(List<CryptoPlugin> cryptoPlugins, List<CryptoKeyProviderPlugin> cryptoKeyProviderPlugins, Settings settings) {
        if (cryptoPlugins == null || cryptoPlugins.size() == 0) {
            return;
        }
        if (cryptoPlugins.size() > 1) {
            throw new IllegalStateException("More than 1 implementation of crypto plugin found.");
        }
        this.cryptoHandlerPlugin.set(cryptoPlugins.get(0));
        this.registry.set(this.loadCryptoFactories(cryptoKeyProviderPlugins));
    }

    public static CryptoHandlerRegistry getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoHandlerRegistry initRegistry(List<CryptoPlugin> cryptoPlugins, List<CryptoKeyProviderPlugin> cryptoKeyProviderPlugins, Settings settings) {
        CryptoHandlerRegistry curInstance = instance;
        if (curInstance == null) {
            Object object = lock;
            synchronized (object) {
                curInstance = instance;
                if (curInstance == null) {
                    instance = curInstance = new CryptoHandlerRegistry(cryptoPlugins, cryptoKeyProviderPlugins, settings);
                }
            }
        }
        return curInstance;
    }

    protected Map<String, CryptoKeyProviderPlugin> loadCryptoFactories(List<CryptoKeyProviderPlugin> cryptoKPPlugins) {
        HashMap<String, CryptoKeyProviderPlugin> cryptoFactories = new HashMap<String, CryptoKeyProviderPlugin>();
        for (CryptoKeyProviderPlugin cryptoKPPlugin : cryptoKPPlugins) {
            if (cryptoFactories.containsKey(cryptoKPPlugin.type())) {
                throw new IllegalArgumentException("Crypto plugin key provider type [" + cryptoKPPlugin.type() + "] is already registered");
            }
            cryptoFactories.put(cryptoKPPlugin.type(), cryptoKPPlugin);
        }
        return Map.copyOf(cryptoFactories);
    }

    public CryptoKeyProviderPlugin getCryptoKeyProviderPlugin(String keyProviderType) {
        if (this.registry.get() == null) {
            throw new IllegalStateException("Crypto registry is not yet loaded");
        }
        return Objects.requireNonNull(this.registry.get()).get(keyProviderType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoHandler<?, ?> fetchCryptoHandler(CryptoMetadata cryptoMetadata) {
        CryptoHandler<?, ?> cryptoHandler = this.registeredCryptoHandlers.get(cryptoMetadata);
        if (cryptoHandler == null) {
            Map<CryptoMetadata, CryptoHandler> map = this.registeredCryptoHandlers;
            synchronized (map) {
                cryptoHandler = this.registeredCryptoHandlers.get(cryptoMetadata);
                if (cryptoHandler == null) {
                    Runnable onClose = () -> {
                        Map<CryptoMetadata, CryptoHandler> map = this.registeredCryptoHandlers;
                        synchronized (map) {
                            this.registeredCryptoHandlers.remove(cryptoMetadata);
                        }
                    };
                    cryptoHandler = this.createCryptoHandler(cryptoMetadata, onClose);
                    this.registeredCryptoHandlers.put(cryptoMetadata, cryptoHandler);
                }
            }
        }
        return cryptoHandler;
    }

    private CryptoHandler<?, ?> createCryptoHandler(CryptoMetadata cryptoMetadata, Runnable onClose) {
        logger.debug("creating crypto client [{}][{}]", (Object)cryptoMetadata.keyProviderType(), (Object)cryptoMetadata.keyProviderName());
        CryptoKeyProviderPlugin keyProviderPlugin = this.getCryptoKeyProviderPlugin(cryptoMetadata.keyProviderType());
        if (keyProviderPlugin == null) {
            throw new CryptoRegistryException(cryptoMetadata.keyProviderName(), cryptoMetadata.keyProviderType());
        }
        try {
            MasterKeyProvider masterKeyProvider = keyProviderPlugin.createKeyProvider(cryptoMetadata);
            return Objects.requireNonNull(this.cryptoHandlerPlugin.get()).getOrCreateCryptoHandler(masterKeyProvider, cryptoMetadata.keyProviderName(), cryptoMetadata.keyProviderType(), onClose);
        }
        catch (Exception e) {
            logger.warn((Message)new ParameterizedMessage("failed to create crypto manager of name [{}] and type [{}]", (Object)cryptoMetadata.keyProviderName(), (Object)cryptoMetadata.keyProviderType()), (Throwable)e);
            throw new CryptoRegistryException(cryptoMetadata.keyProviderName(), cryptoMetadata.keyProviderType(), e);
        }
    }

    static {
        lock = new Object();
    }
}

