/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionType;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.env.NodeEnvironment;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.AsyncShardFetch;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.TransportNodesGatewayStartedShardHelper;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.ShardAttributes;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportNodesListGatewayStartedShards
extends TransportNodesAction<Request, NodesGatewayStartedShards, NodeRequest, NodeGatewayStartedShards>
implements AsyncShardFetch.Lister<NodesGatewayStartedShards, NodeGatewayStartedShards> {
    public static final String ACTION_NAME = "internal:gateway/local/started_shards";
    public static final ActionType<NodesGatewayStartedShards> TYPE = new ActionType<NodesGatewayStartedShards>("internal:gateway/local/started_shards", NodesGatewayStartedShards::new);
    private final Settings settings;
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportNodesListGatewayStartedShards(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeEnvironment env, IndicesService indicesService, NamedXContentRegistry namedXContentRegistry) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "fetch_shard_started", NodeGatewayStartedShards.class);
        this.settings = settings;
        this.nodeEnv = env;
        this.indicesService = indicesService;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    public void list(Map<ShardId, ShardAttributes> shardAttributesMap, DiscoveryNode[] nodes, ActionListener<NodesGatewayStartedShards> listener) {
        assert (shardAttributesMap.size() == 1) : "only one shard should be specified";
        ShardId shardId = shardAttributesMap.keySet().iterator().next();
        String customDataPath = shardAttributesMap.get(shardId).getCustomDataPath();
        this.execute(new Request(shardId, customDataPath, nodes), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeGatewayStartedShards newNodeResponse(StreamInput in) throws IOException {
        return new NodeGatewayStartedShards(in);
    }

    @Override
    protected NodesGatewayStartedShards newResponse(Request request, List<NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
        return new NodesGatewayStartedShards(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayStartedShards nodeOperation(NodeRequest request) {
        try {
            TransportNodesGatewayStartedShardHelper.GatewayStartedShard shardInfo = TransportNodesGatewayStartedShardHelper.getShardInfoOnLocalNode(this.logger, request.getShardId(), this.namedXContentRegistry, this.nodeEnv, this.indicesService, request.getCustomDataPath(), this.settings, this.clusterService);
            return new NodeGatewayStartedShards(this.clusterService.localNode(), new TransportNodesGatewayStartedShardHelper.GatewayStartedShard(shardInfo.allocationId(), shardInfo.primary(), shardInfo.replicationCheckpoint(), shardInfo.storeException()));
        }
        catch (Exception e) {
            throw new OpenSearchException("failed to load started shards", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeGatewayStartedShards
    extends BaseNodeResponse {
        private final TransportNodesGatewayStartedShardHelper.GatewayStartedShard gatewayStartedShard;

        public NodeGatewayStartedShards(StreamInput in) throws IOException {
            super(in);
            String allocationId = in.readOptionalString();
            boolean primary = in.readBoolean();
            Exception storeException = in.readBoolean() ? (Exception)in.readException() : null;
            ReplicationCheckpoint replicationCheckpoint = in.getVersion().onOrAfter(Version.V_2_3_0) && in.readBoolean() ? new ReplicationCheckpoint(in) : null;
            this.gatewayStartedShard = new TransportNodesGatewayStartedShardHelper.GatewayStartedShard(allocationId, primary, replicationCheckpoint, storeException);
        }

        public TransportNodesGatewayStartedShardHelper.GatewayStartedShard getGatewayShardStarted() {
            return this.gatewayStartedShard;
        }

        public NodeGatewayStartedShards(DiscoveryNode node, TransportNodesGatewayStartedShardHelper.GatewayStartedShard gatewayStartedShard) {
            super(node);
            this.gatewayStartedShard = gatewayStartedShard;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.gatewayStartedShard.allocationId());
            out.writeBoolean(this.gatewayStartedShard.primary());
            if (this.gatewayStartedShard.storeException() != null) {
                out.writeBoolean(true);
                out.writeException(this.gatewayStartedShard.storeException());
            } else {
                out.writeBoolean(false);
            }
            if (out.getVersion().onOrAfter(Version.V_2_3_0)) {
                if (this.gatewayStartedShard.replicationCheckpoint() != null) {
                    out.writeBoolean(true);
                    this.gatewayStartedShard.replicationCheckpoint().writeTo(out);
                } else {
                    out.writeBoolean(false);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeGatewayStartedShards that = (NodeGatewayStartedShards)o;
            return this.gatewayStartedShard.equals(that.gatewayStartedShard);
        }

        public int hashCode() {
            return this.gatewayStartedShard.hashCode();
        }

        public String toString() {
            return this.gatewayStartedShard.toString();
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public Request(ShardId shardId, String customDataPath, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = Objects.requireNonNull(shardId);
            this.customDataPath = Objects.requireNonNull(customDataPath);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.customDataPath);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public NodeRequest(Request request) {
            this.shardId = Objects.requireNonNull(request.shardId());
            this.customDataPath = Objects.requireNonNull(request.getCustomDataPath());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            assert (this.customDataPath != null);
            out.writeString(this.customDataPath);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }
    }

    public static class NodesGatewayStartedShards
    extends BaseNodesResponse<NodeGatewayStartedShards> {
        public NodesGatewayStartedShards(StreamInput in) throws IOException {
            super(in);
        }

        public NodesGatewayStartedShards(ClusterName clusterName, List<NodeGatewayStartedShards> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeGatewayStartedShards> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeGatewayStartedShards::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeGatewayStartedShards> nodes) throws IOException {
            out.writeList(nodes);
        }
    }
}

