/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterStateDiffManifest;

public class ClusterMetadataManifest
implements Writeable,
ToXContentFragment {
    public static final int CODEC_V0 = 0;
    public static final int CODEC_V1 = 1;
    public static final int CODEC_V2 = 2;
    private static final ParseField CLUSTER_TERM_FIELD = new ParseField("cluster_term", new String[0]);
    private static final ParseField STATE_VERSION_FIELD = new ParseField("state_version", new String[0]);
    private static final ParseField CLUSTER_UUID_FIELD = new ParseField("cluster_uuid", new String[0]);
    private static final ParseField STATE_UUID_FIELD = new ParseField("state_uuid", new String[0]);
    private static final ParseField OPENSEARCH_VERSION_FIELD = new ParseField("opensearch_version", new String[0]);
    private static final ParseField NODE_ID_FIELD = new ParseField("node_id", new String[0]);
    private static final ParseField COMMITTED_FIELD = new ParseField("committed", new String[0]);
    private static final ParseField CODEC_VERSION_FIELD = new ParseField("codec_version", new String[0]);
    private static final ParseField GLOBAL_METADATA_FIELD = new ParseField("global_metadata", new String[0]);
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField PREVIOUS_CLUSTER_UUID = new ParseField("previous_cluster_uuid", new String[0]);
    private static final ParseField CLUSTER_UUID_COMMITTED = new ParseField("cluster_uuid_committed", new String[0]);
    private static final ParseField UPLOADED_COORDINATOR_METADATA = new ParseField("uploaded_coordinator_metadata", new String[0]);
    private static final ParseField UPLOADED_SETTINGS_METADATA = new ParseField("uploaded_settings_metadata", new String[0]);
    private static final ParseField UPLOADED_TEMPLATES_METADATA = new ParseField("uploaded_templates_metadata", new String[0]);
    private static final ParseField UPLOADED_CUSTOM_METADATA = new ParseField("uploaded_custom_metadata", new String[0]);
    private static final ParseField ROUTING_TABLE_VERSION_FIELD = new ParseField("routing_table_version", new String[0]);
    private static final ParseField INDICES_ROUTING_FIELD = new ParseField("indices_routing", new String[0]);
    private static final ParseField METADATA_VERSION = new ParseField("metadata_version", new String[0]);
    private static final ParseField UPLOADED_TRANSIENT_SETTINGS_METADATA = new ParseField("uploaded_transient_settings_metadata", new String[0]);
    private static final ParseField UPLOADED_DISCOVERY_NODES_METADATA = new ParseField("uploaded_discovery_nodes_metadata", new String[0]);
    private static final ParseField UPLOADED_CLUSTER_BLOCKS_METADATA = new ParseField("uploaded_cluster_blocks_metadata", new String[0]);
    private static final ParseField UPLOADED_HASHES_OF_CONSISTENT_SETTINGS_METADATA = new ParseField("uploaded_hashes_of_consistent_settings_metadata", new String[0]);
    private static final ParseField UPLOADED_CLUSTER_STATE_CUSTOM_METADATA = new ParseField("uploaded_cluster_state_custom_metadata", new String[0]);
    private static final ParseField DIFF_MANIFEST = new ParseField("diff_manifest", new String[0]);
    private static final ConstructingObjectParser<ClusterMetadataManifest, Void> PARSER_V0 = new ConstructingObjectParser("cluster_metadata_manifest", fields -> ClusterMetadataManifest.manifestV0Builder(fields).build());
    private static final ConstructingObjectParser<ClusterMetadataManifest, Void> PARSER_V1 = new ConstructingObjectParser("cluster_metadata_manifest", fields -> ClusterMetadataManifest.manifestV1Builder(fields).build());
    private static final ConstructingObjectParser<ClusterMetadataManifest, Void> PARSER_V2 = new ConstructingObjectParser("cluster_metadata_manifest", fields -> ClusterMetadataManifest.manifestV2Builder(fields).build());
    private static final ConstructingObjectParser<ClusterMetadataManifest, Void> CURRENT_PARSER = PARSER_V2;
    private final int codecVersion;
    private final String globalMetadataFileName;
    private final UploadedMetadataAttribute uploadedCoordinationMetadata;
    private final UploadedMetadataAttribute uploadedSettingsMetadata;
    private final UploadedMetadataAttribute uploadedTemplatesMetadata;
    private final Map<String, UploadedMetadataAttribute> uploadedCustomMetadataMap;
    private final List<UploadedIndexMetadata> indices;
    private final long clusterTerm;
    private final long stateVersion;
    private final String clusterUUID;
    private final String stateUUID;
    private final Version opensearchVersion;
    private final String nodeId;
    private final boolean committed;
    private final String previousClusterUUID;
    private final boolean clusterUUIDCommitted;
    private final long routingTableVersion;
    private final List<UploadedIndexMetadata> indicesRouting;
    private final long metadataVersion;
    private final UploadedMetadataAttribute uploadedTransientSettingsMetadata;
    private final UploadedMetadataAttribute uploadedDiscoveryNodesMetadata;
    private final UploadedMetadataAttribute uploadedClusterBlocksMetadata;
    private final UploadedMetadataAttribute uploadedHashesOfConsistentSettings;
    private final Map<String, UploadedMetadataAttribute> uploadedClusterStateCustomMap;
    private final ClusterStateDiffManifest diffManifest;

    private static Builder manifestV0Builder(Object[] fields) {
        return ClusterMetadataManifest.builder().clusterTerm(ClusterMetadataManifest.term(fields)).stateVersion(ClusterMetadataManifest.version(fields)).clusterUUID(ClusterMetadataManifest.clusterUUID(fields)).stateUUID(ClusterMetadataManifest.stateUUID(fields)).opensearchVersion(ClusterMetadataManifest.opensearchVersion(fields)).nodeId(ClusterMetadataManifest.nodeId(fields)).committed(ClusterMetadataManifest.committed(fields)).codecVersion(0).indices(ClusterMetadataManifest.indices(fields)).previousClusterUUID(ClusterMetadataManifest.previousClusterUUID(fields)).clusterUUIDCommitted(ClusterMetadataManifest.clusterUUIDCommitted(fields));
    }

    private static Builder manifestV1Builder(Object[] fields) {
        return ClusterMetadataManifest.manifestV0Builder(fields).codecVersion(ClusterMetadataManifest.codecVersion(fields)).globalMetadataFileName(ClusterMetadataManifest.globalMetadataFileName(fields));
    }

    private static Builder manifestV2Builder(Object[] fields) {
        return ClusterMetadataManifest.manifestV0Builder(fields).codecVersion(ClusterMetadataManifest.codecVersion(fields)).coordinationMetadata(ClusterMetadataManifest.coordinationMetadata(fields)).settingMetadata(ClusterMetadataManifest.settingsMetadata(fields)).templatesMetadata(ClusterMetadataManifest.templatesMetadata(fields)).customMetadataMap(ClusterMetadataManifest.customMetadata(fields)).routingTableVersion(ClusterMetadataManifest.routingTableVersion(fields)).indicesRouting(ClusterMetadataManifest.indicesRouting(fields)).discoveryNodesMetadata(ClusterMetadataManifest.discoveryNodesMetadata(fields)).clusterBlocksMetadata(ClusterMetadataManifest.clusterBlocksMetadata(fields)).diffManifest(ClusterMetadataManifest.diffManifest(fields)).metadataVersion(ClusterMetadataManifest.metadataVersion(fields)).transientSettingsMetadata(ClusterMetadataManifest.transientSettingsMetadata(fields)).hashesOfConsistentSettings(ClusterMetadataManifest.hashesOfConsistentSettings(fields)).clusterStateCustomMetadataMap(ClusterMetadataManifest.clusterStateCustomMetadata(fields));
    }

    private static long term(Object[] fields) {
        return (Long)fields[0];
    }

    private static long version(Object[] fields) {
        return (Long)fields[1];
    }

    private static String clusterUUID(Object[] fields) {
        return (String)fields[2];
    }

    private static String stateUUID(Object[] fields) {
        return (String)fields[3];
    }

    private static Version opensearchVersion(Object[] fields) {
        return Version.fromId((Integer)fields[4]);
    }

    private static String nodeId(Object[] fields) {
        return (String)fields[5];
    }

    private static boolean committed(Object[] fields) {
        return (Boolean)fields[6];
    }

    private static List<UploadedIndexMetadata> indices(Object[] fields) {
        return (List)fields[7];
    }

    private static String previousClusterUUID(Object[] fields) {
        return (String)fields[8];
    }

    private static boolean clusterUUIDCommitted(Object[] fields) {
        return (Boolean)fields[9];
    }

    private static int codecVersion(Object[] fields) {
        return (Integer)fields[10];
    }

    private static String globalMetadataFileName(Object[] fields) {
        return (String)fields[11];
    }

    private static UploadedMetadataAttribute coordinationMetadata(Object[] fields) {
        return (UploadedMetadataAttribute)fields[11];
    }

    private static UploadedMetadataAttribute settingsMetadata(Object[] fields) {
        return (UploadedMetadataAttribute)fields[12];
    }

    private static UploadedMetadataAttribute templatesMetadata(Object[] fields) {
        return (UploadedMetadataAttribute)fields[13];
    }

    private static Map<String, UploadedMetadataAttribute> customMetadata(Object[] fields) {
        List customs = (List)fields[14];
        return customs.stream().collect(Collectors.toMap(UploadedMetadataAttribute::getAttributeName, Function.identity()));
    }

    private static long routingTableVersion(Object[] fields) {
        return (Long)fields[15];
    }

    private static List<UploadedIndexMetadata> indicesRouting(Object[] fields) {
        return (List)fields[16];
    }

    private static UploadedMetadataAttribute discoveryNodesMetadata(Object[] fields) {
        return (UploadedMetadataAttribute)fields[17];
    }

    private static UploadedMetadataAttribute clusterBlocksMetadata(Object[] fields) {
        return (UploadedMetadataAttribute)fields[18];
    }

    private static long metadataVersion(Object[] fields) {
        return (Long)fields[19];
    }

    private static UploadedMetadataAttribute transientSettingsMetadata(Object[] fields) {
        return (UploadedMetadataAttribute)fields[20];
    }

    private static UploadedMetadataAttribute hashesOfConsistentSettings(Object[] fields) {
        return (UploadedMetadataAttribute)fields[21];
    }

    private static Map<String, UploadedMetadataAttribute> clusterStateCustomMetadata(Object[] fields) {
        List customs = (List)fields[22];
        return customs.stream().collect(Collectors.toMap(UploadedMetadataAttribute::getAttributeName, Function.identity()));
    }

    private static ClusterStateDiffManifest diffManifest(Object[] fields) {
        return (ClusterStateDiffManifest)fields[23];
    }

    private static void declareParser(ConstructingObjectParser<ClusterMetadataManifest, Void> parser, long codec_version) {
        parser.declareLong(ConstructingObjectParser.constructorArg(), CLUSTER_TERM_FIELD);
        parser.declareLong(ConstructingObjectParser.constructorArg(), STATE_VERSION_FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), CLUSTER_UUID_FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), STATE_UUID_FIELD);
        parser.declareInt(ConstructingObjectParser.constructorArg(), OPENSEARCH_VERSION_FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), NODE_ID_FIELD);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), COMMITTED_FIELD);
        parser.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> UploadedIndexMetadata.fromXContent(p), INDICES_FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), PREVIOUS_CLUSTER_UUID);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), CLUSTER_UUID_COMMITTED);
        if (codec_version == 1L) {
            parser.declareInt(ConstructingObjectParser.constructorArg(), CODEC_VERSION_FIELD);
            parser.declareString(ConstructingObjectParser.constructorArg(), GLOBAL_METADATA_FIELD);
        } else if (codec_version >= 2L) {
            parser.declareInt(ConstructingObjectParser.constructorArg(), CODEC_VERSION_FIELD);
            parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_COORDINATOR_METADATA);
            parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_SETTINGS_METADATA);
            parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_TEMPLATES_METADATA);
            parser.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_CUSTOM_METADATA);
            parser.declareLong(ConstructingObjectParser.constructorArg(), ROUTING_TABLE_VERSION_FIELD);
            parser.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> UploadedIndexMetadata.fromXContent(p), INDICES_ROUTING_FIELD);
            parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_DISCOVERY_NODES_METADATA);
            parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_CLUSTER_BLOCKS_METADATA);
            parser.declareLong(ConstructingObjectParser.constructorArg(), METADATA_VERSION);
            parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_TRANSIENT_SETTINGS_METADATA);
            parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_HASHES_OF_CONSISTENT_SETTINGS_METADATA);
            parser.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), UploadedMetadataAttribute.PARSER, UPLOADED_CLUSTER_STATE_CUSTOM_METADATA);
            parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ClusterStateDiffManifest.fromXContent(p), DIFF_MANIFEST);
        }
    }

    public List<UploadedIndexMetadata> getIndices() {
        return this.indices;
    }

    public long getClusterTerm() {
        return this.clusterTerm;
    }

    public long getStateVersion() {
        return this.stateVersion;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public String getStateUUID() {
        return this.stateUUID;
    }

    public Version getOpensearchVersion() {
        return this.opensearchVersion;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public String getPreviousClusterUUID() {
        return this.previousClusterUUID;
    }

    public boolean isClusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public int getCodecVersion() {
        return this.codecVersion;
    }

    public String getGlobalMetadataFileName() {
        return this.globalMetadataFileName;
    }

    public UploadedMetadataAttribute getCoordinationMetadata() {
        return this.uploadedCoordinationMetadata;
    }

    public UploadedMetadataAttribute getSettingsMetadata() {
        return this.uploadedSettingsMetadata;
    }

    public UploadedMetadataAttribute getTemplatesMetadata() {
        return this.uploadedTemplatesMetadata;
    }

    public Map<String, UploadedMetadataAttribute> getCustomMetadataMap() {
        return this.uploadedCustomMetadataMap;
    }

    public long getMetadataVersion() {
        return this.metadataVersion;
    }

    public UploadedMetadataAttribute getTransientSettingsMetadata() {
        return this.uploadedTransientSettingsMetadata;
    }

    public UploadedMetadataAttribute getDiscoveryNodesMetadata() {
        return this.uploadedDiscoveryNodesMetadata;
    }

    public UploadedMetadataAttribute getClusterBlocksMetadata() {
        return this.uploadedClusterBlocksMetadata;
    }

    public ClusterStateDiffManifest getDiffManifest() {
        return this.diffManifest;
    }

    public Map<String, UploadedMetadataAttribute> getClusterStateCustomMap() {
        return this.uploadedClusterStateCustomMap;
    }

    public UploadedMetadataAttribute getHashesOfConsistentSettings() {
        return this.uploadedHashesOfConsistentSettings;
    }

    public boolean hasMetadataAttributesFiles() {
        return this.uploadedCoordinationMetadata != null || this.uploadedSettingsMetadata != null || this.uploadedTemplatesMetadata != null || !this.uploadedCustomMetadataMap.isEmpty();
    }

    public long getRoutingTableVersion() {
        return this.routingTableVersion;
    }

    public List<UploadedIndexMetadata> getIndicesRouting() {
        return this.indicesRouting;
    }

    public ClusterMetadataManifest(long clusterTerm, long version, String clusterUUID, String stateUUID, Version opensearchVersion, String nodeId, boolean committed, int codecVersion, String globalMetadataFileName, List<UploadedIndexMetadata> indices, String previousClusterUUID, boolean clusterUUIDCommitted, UploadedMetadataAttribute uploadedCoordinationMetadata, UploadedMetadataAttribute uploadedSettingsMetadata, UploadedMetadataAttribute uploadedTemplatesMetadata, Map<String, UploadedMetadataAttribute> uploadedCustomMetadataMap, long routingTableVersion, List<UploadedIndexMetadata> indicesRouting, long metadataVersion, UploadedMetadataAttribute discoveryNodesMetadata, UploadedMetadataAttribute clusterBlocksMetadata, UploadedMetadataAttribute uploadedTransientSettingsMetadata, UploadedMetadataAttribute uploadedHashesOfConsistentSettings, Map<String, UploadedMetadataAttribute> uploadedClusterStateCustomMap, ClusterStateDiffManifest diffManifest) {
        this.clusterTerm = clusterTerm;
        this.stateVersion = version;
        this.clusterUUID = clusterUUID;
        this.stateUUID = stateUUID;
        this.opensearchVersion = opensearchVersion;
        this.nodeId = nodeId;
        this.committed = committed;
        this.codecVersion = codecVersion;
        this.globalMetadataFileName = globalMetadataFileName;
        this.indices = Collections.unmodifiableList(indices);
        this.previousClusterUUID = previousClusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
        this.routingTableVersion = routingTableVersion;
        this.indicesRouting = Collections.unmodifiableList(indicesRouting);
        this.uploadedCoordinationMetadata = uploadedCoordinationMetadata;
        this.uploadedSettingsMetadata = uploadedSettingsMetadata;
        this.uploadedTemplatesMetadata = uploadedTemplatesMetadata;
        this.uploadedCustomMetadataMap = Collections.unmodifiableMap(uploadedCustomMetadataMap != null ? uploadedCustomMetadataMap : new HashMap());
        this.uploadedDiscoveryNodesMetadata = discoveryNodesMetadata;
        this.uploadedClusterBlocksMetadata = clusterBlocksMetadata;
        this.diffManifest = diffManifest;
        this.metadataVersion = metadataVersion;
        this.uploadedTransientSettingsMetadata = uploadedTransientSettingsMetadata;
        this.uploadedHashesOfConsistentSettings = uploadedHashesOfConsistentSettings;
        this.uploadedClusterStateCustomMap = Collections.unmodifiableMap(uploadedClusterStateCustomMap != null ? uploadedClusterStateCustomMap : new HashMap());
    }

    public ClusterMetadataManifest(StreamInput in) throws IOException {
        this.clusterTerm = in.readVLong();
        this.stateVersion = in.readVLong();
        this.clusterUUID = in.readString();
        this.stateUUID = in.readString();
        this.opensearchVersion = Version.fromId(in.readInt());
        this.nodeId = in.readString();
        this.committed = in.readBoolean();
        this.indices = Collections.unmodifiableList(in.readList(UploadedIndexMetadata::new));
        this.previousClusterUUID = in.readString();
        this.clusterUUIDCommitted = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_2_15_0)) {
            this.codecVersion = in.readInt();
            this.uploadedCoordinationMetadata = new UploadedMetadataAttribute(in);
            this.uploadedSettingsMetadata = new UploadedMetadataAttribute(in);
            this.uploadedTemplatesMetadata = new UploadedMetadataAttribute(in);
            this.uploadedCustomMetadataMap = Collections.unmodifiableMap(in.readMap(StreamInput::readString, UploadedMetadataAttribute::new));
            this.globalMetadataFileName = null;
            this.routingTableVersion = in.readLong();
            this.indicesRouting = Collections.unmodifiableList(in.readList(UploadedIndexMetadata::new));
            this.metadataVersion = in.readLong();
            this.uploadedDiscoveryNodesMetadata = in.readBoolean() ? new UploadedMetadataAttribute(in) : null;
            this.uploadedClusterBlocksMetadata = in.readBoolean() ? new UploadedMetadataAttribute(in) : null;
            this.uploadedTransientSettingsMetadata = in.readBoolean() ? new UploadedMetadataAttribute(in) : null;
            this.uploadedHashesOfConsistentSettings = in.readBoolean() ? new UploadedMetadataAttribute(in) : null;
            this.uploadedClusterStateCustomMap = Collections.unmodifiableMap(in.readMap(StreamInput::readString, UploadedMetadataAttribute::new));
            this.diffManifest = in.readBoolean() ? new ClusterStateDiffManifest(in) : null;
        } else {
            if (in.getVersion().onOrAfter(Version.V_2_12_0)) {
                this.codecVersion = in.readInt();
                this.globalMetadataFileName = in.readString();
            } else {
                this.codecVersion = 0;
                this.globalMetadataFileName = null;
            }
            this.uploadedCoordinationMetadata = null;
            this.uploadedSettingsMetadata = null;
            this.uploadedTemplatesMetadata = null;
            this.uploadedCustomMetadataMap = null;
            this.routingTableVersion = -1L;
            this.indicesRouting = null;
            this.uploadedDiscoveryNodesMetadata = null;
            this.uploadedClusterBlocksMetadata = null;
            this.diffManifest = null;
            this.metadataVersion = -1L;
            this.uploadedTransientSettingsMetadata = null;
            this.uploadedHashesOfConsistentSettings = null;
            this.uploadedClusterStateCustomMap = null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterMetadataManifest manifest) {
        return new Builder(manifest);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(CLUSTER_TERM_FIELD.getPreferredName(), this.getClusterTerm()).field(STATE_VERSION_FIELD.getPreferredName(), this.getStateVersion()).field(CLUSTER_UUID_FIELD.getPreferredName(), this.getClusterUUID()).field(STATE_UUID_FIELD.getPreferredName(), this.getStateUUID()).field(OPENSEARCH_VERSION_FIELD.getPreferredName(), this.getOpensearchVersion().id).field(NODE_ID_FIELD.getPreferredName(), this.getNodeId()).field(COMMITTED_FIELD.getPreferredName(), this.isCommitted());
        builder.startArray(INDICES_FIELD.getPreferredName());
        for (UploadedIndexMetadata uploadedIndexMetadata : this.indices) {
            builder.startObject();
            uploadedIndexMetadata.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.field(PREVIOUS_CLUSTER_UUID.getPreferredName(), this.getPreviousClusterUUID());
        builder.field(CLUSTER_UUID_COMMITTED.getPreferredName(), this.isClusterUUIDCommitted());
        if (this.onOrAfterCodecVersion(2)) {
            builder.field(CODEC_VERSION_FIELD.getPreferredName(), this.getCodecVersion());
            if (this.getCoordinationMetadata() != null) {
                builder.startObject(UPLOADED_COORDINATOR_METADATA.getPreferredName());
                this.getCoordinationMetadata().toXContent(builder, params);
                builder.endObject();
            }
            if (this.getSettingsMetadata() != null) {
                builder.startObject(UPLOADED_SETTINGS_METADATA.getPreferredName());
                this.getSettingsMetadata().toXContent(builder, params);
                builder.endObject();
            }
            if (this.getTemplatesMetadata() != null) {
                builder.startObject(UPLOADED_TEMPLATES_METADATA.getPreferredName());
                this.getTemplatesMetadata().toXContent(builder, params);
                builder.endObject();
            }
            builder.startObject(UPLOADED_CUSTOM_METADATA.getPreferredName());
            for (UploadedMetadataAttribute attribute : this.getCustomMetadataMap().values()) {
                attribute.toXContent(builder, params);
            }
            builder.endObject();
            builder.field(ROUTING_TABLE_VERSION_FIELD.getPreferredName(), this.getRoutingTableVersion());
            builder.startArray(INDICES_ROUTING_FIELD.getPreferredName());
            for (UploadedIndexMetadata uploadedIndexMetadata : this.indicesRouting) {
                builder.startObject();
                uploadedIndexMetadata.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.getDiscoveryNodesMetadata() != null) {
                builder.startObject(UPLOADED_DISCOVERY_NODES_METADATA.getPreferredName());
                this.getDiscoveryNodesMetadata().toXContent(builder, params);
                builder.endObject();
            }
            if (this.getClusterBlocksMetadata() != null) {
                builder.startObject(UPLOADED_CLUSTER_BLOCKS_METADATA.getPreferredName());
                this.getClusterBlocksMetadata().toXContent(builder, params);
                builder.endObject();
            }
            if (this.getTransientSettingsMetadata() != null) {
                builder.startObject(UPLOADED_TRANSIENT_SETTINGS_METADATA.getPreferredName());
                this.getTransientSettingsMetadata().toXContent(builder, params);
                builder.endObject();
            }
            if (this.getDiffManifest() != null) {
                builder.startObject(DIFF_MANIFEST.getPreferredName());
                this.getDiffManifest().toXContent(builder, params);
                builder.endObject();
            }
            builder.field(METADATA_VERSION.getPreferredName(), this.getMetadataVersion());
            if (this.getHashesOfConsistentSettings() != null) {
                builder.startObject(UPLOADED_HASHES_OF_CONSISTENT_SETTINGS_METADATA.getPreferredName());
                this.getHashesOfConsistentSettings().toXContent(builder, params);
                builder.endObject();
            }
            builder.startObject(UPLOADED_CLUSTER_STATE_CUSTOM_METADATA.getPreferredName());
            for (UploadedMetadataAttribute attribute : this.getClusterStateCustomMap().values()) {
                attribute.toXContent(builder, params);
            }
            builder.endObject();
        } else if (this.onOrAfterCodecVersion(1)) {
            builder.field(CODEC_VERSION_FIELD.getPreferredName(), this.getCodecVersion());
            builder.field(GLOBAL_METADATA_FIELD.getPreferredName(), this.getGlobalMetadataFileName());
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.clusterTerm);
        out.writeVLong(this.stateVersion);
        out.writeString(this.clusterUUID);
        out.writeString(this.stateUUID);
        out.writeInt(this.opensearchVersion.id);
        out.writeString(this.nodeId);
        out.writeBoolean(this.committed);
        out.writeCollection(this.indices);
        out.writeString(this.previousClusterUUID);
        out.writeBoolean(this.clusterUUIDCommitted);
        if (out.getVersion().onOrAfter(Version.V_2_15_0)) {
            out.writeInt(this.codecVersion);
            this.uploadedCoordinationMetadata.writeTo(out);
            this.uploadedSettingsMetadata.writeTo(out);
            this.uploadedTemplatesMetadata.writeTo(out);
            out.writeMap(this.uploadedCustomMetadataMap, StreamOutput::writeString, (o, v) -> v.writeTo(o));
            out.writeLong(this.routingTableVersion);
            out.writeCollection(this.indicesRouting);
            out.writeLong(this.metadataVersion);
            if (this.uploadedDiscoveryNodesMetadata != null) {
                out.writeBoolean(true);
                this.uploadedDiscoveryNodesMetadata.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.uploadedClusterBlocksMetadata != null) {
                out.writeBoolean(true);
                this.uploadedClusterBlocksMetadata.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.uploadedTransientSettingsMetadata != null) {
                out.writeBoolean(true);
                this.uploadedTransientSettingsMetadata.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.uploadedHashesOfConsistentSettings != null) {
                out.writeBoolean(true);
                this.uploadedHashesOfConsistentSettings.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeMap(this.uploadedClusterStateCustomMap, StreamOutput::writeString, (o, v) -> v.writeTo(o));
            if (this.diffManifest != null) {
                out.writeBoolean(true);
                this.diffManifest.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        } else if (out.getVersion().onOrAfter(Version.V_2_12_0)) {
            out.writeInt(this.codecVersion);
            out.writeString(this.globalMetadataFileName);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMetadataManifest that = (ClusterMetadataManifest)o;
        return Objects.equals(this.indices, that.indices) && this.clusterTerm == that.clusterTerm && this.stateVersion == that.stateVersion && Objects.equals(this.clusterUUID, that.clusterUUID) && Objects.equals(this.stateUUID, that.stateUUID) && Objects.equals(this.opensearchVersion, that.opensearchVersion) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.committed, that.committed) && Objects.equals(this.previousClusterUUID, that.previousClusterUUID) && Objects.equals(this.clusterUUIDCommitted, that.clusterUUIDCommitted) && Objects.equals(this.globalMetadataFileName, that.globalMetadataFileName) && Objects.equals(this.codecVersion, that.codecVersion) && Objects.equals(this.routingTableVersion, that.routingTableVersion) && Objects.equals(this.indicesRouting, that.indicesRouting) && Objects.equals(this.uploadedCoordinationMetadata, that.uploadedCoordinationMetadata) && Objects.equals(this.uploadedSettingsMetadata, that.uploadedSettingsMetadata) && Objects.equals(this.uploadedTemplatesMetadata, that.uploadedTemplatesMetadata) && Objects.equals(this.uploadedCustomMetadataMap, that.uploadedCustomMetadataMap) && Objects.equals(this.metadataVersion, that.metadataVersion) && Objects.equals(this.uploadedDiscoveryNodesMetadata, that.uploadedDiscoveryNodesMetadata) && Objects.equals(this.uploadedClusterBlocksMetadata, that.uploadedClusterBlocksMetadata) && Objects.equals(this.uploadedTransientSettingsMetadata, that.uploadedTransientSettingsMetadata) && Objects.equals(this.uploadedHashesOfConsistentSettings, that.uploadedHashesOfConsistentSettings) && Objects.equals(this.uploadedClusterStateCustomMap, that.uploadedClusterStateCustomMap) && Objects.equals(this.diffManifest, that.diffManifest);
    }

    public int hashCode() {
        return Objects.hash(this.codecVersion, this.globalMetadataFileName, this.indices, this.clusterTerm, this.stateVersion, this.clusterUUID, this.stateUUID, this.opensearchVersion, this.nodeId, this.committed, this.previousClusterUUID, this.clusterUUIDCommitted, this.routingTableVersion, this.indicesRouting, this.uploadedCoordinationMetadata, this.uploadedSettingsMetadata, this.uploadedTemplatesMetadata, this.uploadedCustomMetadataMap, this.metadataVersion, this.uploadedDiscoveryNodesMetadata, this.uploadedClusterBlocksMetadata, this.uploadedTransientSettingsMetadata, this.uploadedHashesOfConsistentSettings, this.uploadedClusterStateCustomMap, this.diffManifest);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public boolean onOrAfterCodecVersion(int codecVersion) {
        return this.codecVersion >= codecVersion;
    }

    public static ClusterMetadataManifest fromXContentV0(XContentParser parser) throws IOException {
        return PARSER_V0.parse(parser, null);
    }

    public static ClusterMetadataManifest fromXContentV1(XContentParser parser) throws IOException {
        return PARSER_V1.parse(parser, null);
    }

    public static ClusterMetadataManifest fromXContentV2(XContentParser parser) throws IOException {
        return PARSER_V2.parse(parser, null);
    }

    public static ClusterMetadataManifest fromXContent(XContentParser parser) throws IOException {
        return CURRENT_PARSER.parse(parser, null);
    }

    static {
        ClusterMetadataManifest.declareParser(PARSER_V0, 0L);
        ClusterMetadataManifest.declareParser(PARSER_V1, 1L);
        ClusterMetadataManifest.declareParser(PARSER_V2, 2L);
    }

    public static class Builder {
        private String globalMetadataFileName;
        private UploadedMetadataAttribute coordinationMetadata;
        private UploadedMetadataAttribute settingsMetadata;
        private UploadedMetadataAttribute templatesMetadata;
        private Map<String, UploadedMetadataAttribute> customMetadataMap;
        private int codecVersion;
        private List<UploadedIndexMetadata> indices;
        private long clusterTerm;
        private long stateVersion;
        private String clusterUUID;
        private String stateUUID;
        private Version opensearchVersion;
        private String nodeId;
        private String previousClusterUUID;
        private boolean committed;
        private boolean clusterUUIDCommitted;
        private long routingTableVersion;
        private List<UploadedIndexMetadata> indicesRouting;
        private long metadataVersion;
        private UploadedMetadataAttribute discoveryNodesMetadata;
        private UploadedMetadataAttribute clusterBlocksMetadata;
        private UploadedMetadataAttribute transientSettingsMetadata;
        private UploadedMetadataAttribute hashesOfConsistentSettings;
        private Map<String, UploadedMetadataAttribute> clusterStateCustomMetadataMap;
        private ClusterStateDiffManifest diffManifest;

        public Builder indices(List<UploadedIndexMetadata> indices) {
            this.indices = indices;
            return this;
        }

        public Builder routingTableVersion(long routingTableVersion) {
            this.routingTableVersion = routingTableVersion;
            return this;
        }

        public Builder indicesRouting(List<UploadedIndexMetadata> indicesRouting) {
            this.indicesRouting = indicesRouting;
            return this;
        }

        public Builder codecVersion(int codecVersion) {
            this.codecVersion = codecVersion;
            return this;
        }

        public Builder globalMetadataFileName(String globalMetadataFileName) {
            this.globalMetadataFileName = globalMetadataFileName;
            return this;
        }

        public Builder coordinationMetadata(UploadedMetadataAttribute coordinationMetadata) {
            this.coordinationMetadata = coordinationMetadata;
            return this;
        }

        public Builder settingMetadata(UploadedMetadataAttribute settingsMetadata) {
            this.settingsMetadata = settingsMetadata;
            return this;
        }

        public Builder templatesMetadata(UploadedMetadataAttribute templatesMetadata) {
            this.templatesMetadata = templatesMetadata;
            return this;
        }

        public Builder customMetadataMap(Map<String, UploadedMetadataAttribute> customMetadataMap) {
            this.customMetadataMap = customMetadataMap;
            return this;
        }

        public Builder put(String custom, UploadedMetadataAttribute customMetadata) {
            this.customMetadataMap.put(custom, customMetadata);
            return this;
        }

        public Builder clusterTerm(long clusterTerm) {
            this.clusterTerm = clusterTerm;
            return this;
        }

        public Builder stateVersion(long stateVersion) {
            this.stateVersion = stateVersion;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder stateUUID(String stateUUID) {
            this.stateUUID = stateUUID;
            return this;
        }

        public Builder opensearchVersion(Version opensearchVersion) {
            this.opensearchVersion = opensearchVersion;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder committed(boolean committed) {
            this.committed = committed;
            return this;
        }

        public List<UploadedIndexMetadata> getIndices() {
            return this.indices;
        }

        public List<UploadedIndexMetadata> getIndicesRouting() {
            return this.indicesRouting;
        }

        public Builder previousClusterUUID(String previousClusterUUID) {
            this.previousClusterUUID = previousClusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder metadataVersion(long metadataVersion) {
            this.metadataVersion = metadataVersion;
            return this;
        }

        public Builder discoveryNodesMetadata(UploadedMetadataAttribute discoveryNodesMetadata) {
            this.discoveryNodesMetadata = discoveryNodesMetadata;
            return this;
        }

        public Builder clusterBlocksMetadata(UploadedMetadataAttribute clusterBlocksMetadata) {
            this.clusterBlocksMetadata = clusterBlocksMetadata;
            return this;
        }

        public Builder transientSettingsMetadata(UploadedMetadataAttribute settingsMetadata) {
            this.transientSettingsMetadata = settingsMetadata;
            return this;
        }

        public Builder hashesOfConsistentSettings(UploadedMetadataAttribute hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = hashesOfConsistentSettings;
            return this;
        }

        public Builder clusterStateCustomMetadataMap(Map<String, UploadedMetadataAttribute> clusterStateCustomMetadataMap) {
            this.clusterStateCustomMetadataMap = clusterStateCustomMetadataMap;
            return this;
        }

        public Builder diffManifest(ClusterStateDiffManifest diffManifest) {
            this.diffManifest = diffManifest;
            return this;
        }

        public Builder() {
            this.indices = new ArrayList<UploadedIndexMetadata>();
            this.customMetadataMap = new HashMap<String, UploadedMetadataAttribute>();
            this.indicesRouting = new ArrayList<UploadedIndexMetadata>();
            this.clusterStateCustomMetadataMap = new HashMap<String, UploadedMetadataAttribute>();
        }

        public Builder(ClusterMetadataManifest manifest) {
            this.clusterTerm = manifest.clusterTerm;
            this.stateVersion = manifest.stateVersion;
            this.clusterUUID = manifest.clusterUUID;
            this.stateUUID = manifest.stateUUID;
            this.opensearchVersion = manifest.opensearchVersion;
            this.nodeId = manifest.nodeId;
            this.committed = manifest.committed;
            this.globalMetadataFileName = manifest.globalMetadataFileName;
            this.coordinationMetadata = manifest.uploadedCoordinationMetadata;
            this.settingsMetadata = manifest.uploadedSettingsMetadata;
            this.templatesMetadata = manifest.uploadedTemplatesMetadata;
            this.customMetadataMap = manifest.uploadedCustomMetadataMap;
            this.codecVersion = manifest.codecVersion;
            this.indices = new ArrayList<UploadedIndexMetadata>(manifest.indices);
            this.previousClusterUUID = manifest.previousClusterUUID;
            this.clusterUUIDCommitted = manifest.clusterUUIDCommitted;
            this.routingTableVersion = manifest.routingTableVersion;
            this.indicesRouting = new ArrayList<UploadedIndexMetadata>(manifest.indicesRouting);
            this.discoveryNodesMetadata = manifest.uploadedDiscoveryNodesMetadata;
            this.clusterBlocksMetadata = manifest.uploadedClusterBlocksMetadata;
            this.transientSettingsMetadata = manifest.uploadedTransientSettingsMetadata;
            this.diffManifest = manifest.diffManifest;
            this.hashesOfConsistentSettings = manifest.uploadedHashesOfConsistentSettings;
            this.clusterStateCustomMetadataMap = manifest.uploadedClusterStateCustomMap;
        }

        public ClusterMetadataManifest build() {
            return new ClusterMetadataManifest(this.clusterTerm, this.stateVersion, this.clusterUUID, this.stateUUID, this.opensearchVersion, this.nodeId, this.committed, this.codecVersion, this.globalMetadataFileName, this.indices, this.previousClusterUUID, this.clusterUUIDCommitted, this.coordinationMetadata, this.settingsMetadata, this.templatesMetadata, this.customMetadataMap, this.routingTableVersion, this.indicesRouting, this.metadataVersion, this.discoveryNodesMetadata, this.clusterBlocksMetadata, this.transientSettingsMetadata, this.hashesOfConsistentSettings, this.clusterStateCustomMetadataMap, this.diffManifest);
        }
    }

    public static class UploadedMetadataAttribute
    implements UploadedMetadata,
    Writeable,
    ToXContentFragment {
        private static final ParseField UPLOADED_FILENAME_FIELD = new ParseField("uploaded_filename", new String[0]);
        private static final ObjectParser.NamedObjectParser<UploadedMetadataAttribute, Void> PARSER;
        private final String attributeName;
        private final String uploadedFilename;

        public UploadedMetadataAttribute(String attributeName, String uploadedFilename) {
            this.attributeName = attributeName;
            this.uploadedFilename = uploadedFilename;
        }

        public UploadedMetadataAttribute(StreamInput in) throws IOException {
            this.attributeName = in.readString();
            this.uploadedFilename = in.readString();
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public String getComponent() {
            return this.getAttributeName();
        }

        @Override
        public String getUploadedFilename() {
            return this.uploadedFilename;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.attributeName);
            out.writeString(this.uploadedFilename);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject(this.getAttributeName()).field(UPLOADED_FILENAME_FIELD.getPreferredName(), this.getUploadedFilename()).endObject();
        }

        public static UploadedMetadataAttribute fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null, parser.currentName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UploadedMetadataAttribute that = (UploadedMetadataAttribute)o;
            return Objects.equals(this.attributeName, that.attributeName) && Objects.equals(this.uploadedFilename, that.uploadedFilename);
        }

        public int hashCode() {
            return Objects.hash(this.attributeName, this.uploadedFilename);
        }

        public String toString() {
            return "UploadedMetadataAttribute{attributeName='" + this.attributeName + "', uploadedFilename='" + this.uploadedFilename + "'}";
        }

        static {
            ConstructingObjectParser<UploadedMetadataAttribute, String> innerParser = new ConstructingObjectParser<UploadedMetadataAttribute, String>("uploaded_metadata_attribute", true, (parsedObject, name) -> {
                String uploadedFilename = (String)parsedObject[0];
                return new UploadedMetadataAttribute((String)name, uploadedFilename);
            });
            innerParser.declareString(ConstructingObjectParser.constructorArg(), UPLOADED_FILENAME_FIELD);
            PARSER = (p, c, name) -> (UploadedMetadataAttribute)innerParser.parse(p, name);
        }
    }

    public static class UploadedIndexMetadata
    implements UploadedMetadata,
    Writeable,
    ToXContentFragment {
        private static final ParseField INDEX_NAME_FIELD = new ParseField("index_name", new String[0]);
        private static final ParseField INDEX_UUID_FIELD = new ParseField("index_uuid", new String[0]);
        private static final ParseField UPLOADED_FILENAME_FIELD = new ParseField("uploaded_filename", new String[0]);
        private static final ParseField COMPONENT_PREFIX_FIELD = new ParseField("component_prefix", new String[0]);
        private static final ConstructingObjectParser<UploadedIndexMetadata, Void> PARSER = new ConstructingObjectParser("uploaded_index_metadata", fields -> new UploadedIndexMetadata(UploadedIndexMetadata.indexName(fields), UploadedIndexMetadata.indexUUID(fields), UploadedIndexMetadata.uploadedFilename(fields), UploadedIndexMetadata.componentPrefix(fields)));
        static final String COMPONENT_PREFIX = "index--";
        private final String componentPrefix;
        private final String indexName;
        private final String indexUUID;
        private final String uploadedFilename;

        private static String indexName(Object[] fields) {
            return (String)fields[0];
        }

        private static String indexUUID(Object[] fields) {
            return (String)fields[1];
        }

        private static String uploadedFilename(Object[] fields) {
            return (String)fields[2];
        }

        private static String componentPrefix(Object[] fields) {
            return (String)fields[3];
        }

        public UploadedIndexMetadata(String indexName, String indexUUID, String uploadedFileName) {
            this(indexName, indexUUID, uploadedFileName, COMPONENT_PREFIX);
        }

        public UploadedIndexMetadata(String indexName, String indexUUID, String uploadedFileName, String componentPrefix) {
            this.componentPrefix = componentPrefix;
            this.indexName = indexName;
            this.indexUUID = indexUUID;
            this.uploadedFilename = uploadedFileName;
        }

        public UploadedIndexMetadata(StreamInput in) throws IOException {
            this.indexName = in.readString();
            this.indexUUID = in.readString();
            this.uploadedFilename = in.readString();
            this.componentPrefix = in.readString();
        }

        public String getUploadedFilePath() {
            return this.uploadedFilename;
        }

        @Override
        public String getComponent() {
            return this.componentPrefix + this.getIndexName();
        }

        @Override
        public String getUploadedFilename() {
            return this.uploadedFilename;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getIndexUUID() {
            return this.indexUUID;
        }

        public String getComponentPrefix() {
            return this.componentPrefix;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(INDEX_NAME_FIELD.getPreferredName(), this.getIndexName()).field(INDEX_UUID_FIELD.getPreferredName(), this.getIndexUUID()).field(UPLOADED_FILENAME_FIELD.getPreferredName(), this.getUploadedFilePath()).field(COMPONENT_PREFIX_FIELD.getPreferredName(), this.getComponentPrefix());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.indexName);
            out.writeString(this.indexUUID);
            out.writeString(this.uploadedFilename);
            out.writeString(this.componentPrefix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UploadedIndexMetadata that = (UploadedIndexMetadata)o;
            return Objects.equals(this.indexName, that.indexName) && Objects.equals(this.indexUUID, that.indexUUID) && Objects.equals(this.uploadedFilename, that.uploadedFilename) && Objects.equals(this.componentPrefix, that.componentPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.indexName, this.indexUUID, this.uploadedFilename, this.componentPrefix);
        }

        public String toString() {
            return Strings.toString(MediaTypeRegistry.JSON, this);
        }

        public static UploadedIndexMetadata fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_NAME_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_UUID_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), UPLOADED_FILENAME_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), COMPONENT_PREFIX_FIELD);
        }
    }

    public static interface UploadedMetadata {
        public String getComponent();

        public String getUploadedFilename();
    }
}

