/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.DiffableUtils;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.IndexRoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.remote.RemoteRoutingTableService;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParseException;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParserUtils;

public class ClusterStateDiffManifest
implements ToXContentFragment,
Writeable {
    private static final String FROM_STATE_UUID_FIELD = "from_state_uuid";
    private static final String TO_STATE_UUID_FIELD = "to_state_uuid";
    private static final String METADATA_DIFF_FIELD = "metadata_diff";
    private static final String COORDINATION_METADATA_UPDATED_FIELD = "coordination_metadata_diff";
    private static final String SETTINGS_METADATA_UPDATED_FIELD = "settings_metadata_diff";
    private static final String TRANSIENT_SETTINGS_METADATA_UPDATED_FIELD = "transient_settings_metadata_diff";
    private static final String TEMPLATES_METADATA_UPDATED_FIELD = "templates_metadata_diff";
    private static final String HASHES_OF_CONSISTENT_SETTINGS_UPDATED_FIELD = "hashes_of_consistent_settings_diff";
    private static final String INDICES_DIFF_FIELD = "indices_diff";
    private static final String METADATA_CUSTOM_DIFF_FIELD = "metadata_custom_diff";
    private static final String UPSERTS_FIELD = "upserts";
    private static final String DELETES_FIELD = "deletes";
    private static final String CLUSTER_BLOCKS_UPDATED_FIELD = "cluster_blocks_diff";
    private static final String DISCOVERY_NODES_UPDATED_FIELD = "discovery_nodes_diff";
    private static final String ROUTING_TABLE_DIFF = "routing_table_diff";
    private static final String CLUSTER_STATE_CUSTOM_DIFF_FIELD = "cluster_state_custom_diff";
    private final String fromStateUUID;
    private final String toStateUUID;
    private final boolean coordinationMetadataUpdated;
    private final boolean settingsMetadataUpdated;
    private final boolean transientSettingsMetadataUpdated;
    private final boolean templatesMetadataUpdated;
    private final List<String> indicesUpdated;
    private final List<String> indicesDeleted;
    private final List<String> customMetadataUpdated;
    private final List<String> customMetadataDeleted;
    private final boolean clusterBlocksUpdated;
    private final boolean discoveryNodesUpdated;
    private final List<String> indicesRoutingUpdated;
    private final List<String> indicesRoutingDeleted;
    private final boolean hashesOfConsistentSettingsUpdated;
    private final List<String> clusterStateCustomUpdated;
    private final List<String> clusterStateCustomDeleted;

    public ClusterStateDiffManifest(ClusterState state, ClusterState previousState) {
        this.fromStateUUID = previousState.stateUUID();
        this.toStateUUID = state.stateUUID();
        this.coordinationMetadataUpdated = !Metadata.isCoordinationMetadataEqual(state.metadata(), previousState.metadata());
        this.settingsMetadataUpdated = !Metadata.isSettingsMetadataEqual(state.metadata(), previousState.metadata());
        this.transientSettingsMetadataUpdated = !Metadata.isTransientSettingsMetadataEqual(state.metadata(), previousState.metadata());
        this.templatesMetadataUpdated = !Metadata.isTemplatesMetadataEqual(state.metadata(), previousState.metadata());
        DiffableUtils.MapDiff<String, IndexMetadata, Map<String, IndexMetadata>> indicesDiff = DiffableUtils.diff(previousState.metadata().indices(), state.metadata().indices(), DiffableUtils.getStringKeySerializer());
        this.indicesDeleted = indicesDiff.getDeletes();
        this.indicesUpdated = new ArrayList<String>(indicesDiff.getDiffs().keySet());
        this.indicesUpdated.addAll(indicesDiff.getUpserts().keySet());
        this.clusterBlocksUpdated = !state.blocks().equals(previousState.blocks());
        this.discoveryNodesUpdated = state.nodes().delta(previousState.nodes()).hasChanges();
        DiffableUtils.MapDiff<String, Metadata.Custom, Map<String, Metadata.Custom>> customDiff = DiffableUtils.diff(previousState.metadata().customs(), state.metadata().customs(), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
        this.customMetadataUpdated = new ArrayList<String>(customDiff.getDiffs().keySet());
        this.customMetadataUpdated.addAll(customDiff.getUpserts().keySet());
        this.customMetadataDeleted = customDiff.getDeletes();
        DiffableUtils.MapDiff<String, IndexRoutingTable, Map<String, IndexRoutingTable>> routingTableDiff = DiffableUtils.diff(previousState.getRoutingTable().getIndicesRouting(), state.getRoutingTable().getIndicesRouting(), DiffableUtils.getStringKeySerializer(), RemoteRoutingTableService.CUSTOM_ROUTING_TABLE_VALUE_SERIALIZER);
        this.indicesRoutingUpdated = new ArrayList<String>();
        routingTableDiff.getUpserts().forEach((k, v) -> this.indicesRoutingUpdated.add((String)k));
        this.indicesRoutingDeleted = routingTableDiff.getDeletes();
        this.hashesOfConsistentSettingsUpdated = !state.metadata().hashesOfConsistentSettings().equals(previousState.metadata().hashesOfConsistentSettings());
        DiffableUtils.MapDiff<String, ClusterState.Custom, Map<String, ClusterState.Custom>> clusterStateCustomDiff = DiffableUtils.diff(previousState.customs(), state.customs(), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
        this.clusterStateCustomUpdated = new ArrayList<String>(clusterStateCustomDiff.getDiffs().keySet());
        this.clusterStateCustomUpdated.addAll(clusterStateCustomDiff.getUpserts().keySet());
        this.clusterStateCustomDeleted = clusterStateCustomDiff.getDeletes();
    }

    public ClusterStateDiffManifest(String fromStateUUID, String toStateUUID, boolean coordinationMetadataUpdated, boolean settingsMetadataUpdated, boolean transientSettingsMetadataUpdate, boolean templatesMetadataUpdated, List<String> customMetadataUpdated, List<String> customMetadataDeleted, List<String> indicesUpdated, List<String> indicesDeleted, boolean clusterBlocksUpdated, boolean discoveryNodesUpdated, List<String> indicesRoutingUpdated, List<String> indicesRoutingDeleted, boolean hashesOfConsistentSettingsUpdated, List<String> clusterStateCustomUpdated, List<String> clusterStateCustomDeleted) {
        this.fromStateUUID = fromStateUUID;
        this.toStateUUID = toStateUUID;
        this.coordinationMetadataUpdated = coordinationMetadataUpdated;
        this.settingsMetadataUpdated = settingsMetadataUpdated;
        this.transientSettingsMetadataUpdated = transientSettingsMetadataUpdate;
        this.templatesMetadataUpdated = templatesMetadataUpdated;
        this.customMetadataUpdated = customMetadataUpdated;
        this.customMetadataDeleted = customMetadataDeleted;
        this.indicesUpdated = indicesUpdated;
        this.indicesDeleted = indicesDeleted;
        this.clusterBlocksUpdated = clusterBlocksUpdated;
        this.discoveryNodesUpdated = discoveryNodesUpdated;
        this.indicesRoutingUpdated = indicesRoutingUpdated;
        this.indicesRoutingDeleted = indicesRoutingDeleted;
        this.hashesOfConsistentSettingsUpdated = hashesOfConsistentSettingsUpdated;
        this.clusterStateCustomUpdated = clusterStateCustomUpdated;
        this.clusterStateCustomDeleted = clusterStateCustomDeleted;
    }

    public ClusterStateDiffManifest(StreamInput in) throws IOException {
        this.fromStateUUID = in.readString();
        this.toStateUUID = in.readString();
        this.coordinationMetadataUpdated = in.readBoolean();
        this.settingsMetadataUpdated = in.readBoolean();
        this.transientSettingsMetadataUpdated = in.readBoolean();
        this.templatesMetadataUpdated = in.readBoolean();
        this.indicesUpdated = in.readStringList();
        this.indicesDeleted = in.readStringList();
        this.customMetadataUpdated = in.readStringList();
        this.customMetadataDeleted = in.readStringList();
        this.clusterBlocksUpdated = in.readBoolean();
        this.discoveryNodesUpdated = in.readBoolean();
        this.indicesRoutingUpdated = in.readStringList();
        this.indicesRoutingDeleted = in.readStringList();
        this.hashesOfConsistentSettingsUpdated = in.readBoolean();
        this.clusterStateCustomUpdated = in.readStringList();
        this.clusterStateCustomDeleted = in.readStringList();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FROM_STATE_UUID_FIELD, this.fromStateUUID);
        builder.field(TO_STATE_UUID_FIELD, this.toStateUUID);
        builder.startObject(METADATA_DIFF_FIELD);
        builder.field(COORDINATION_METADATA_UPDATED_FIELD, this.coordinationMetadataUpdated);
        builder.field(SETTINGS_METADATA_UPDATED_FIELD, this.settingsMetadataUpdated);
        builder.field(TRANSIENT_SETTINGS_METADATA_UPDATED_FIELD, this.transientSettingsMetadataUpdated);
        builder.field(TEMPLATES_METADATA_UPDATED_FIELD, this.templatesMetadataUpdated);
        builder.startObject(INDICES_DIFF_FIELD);
        builder.startArray(UPSERTS_FIELD);
        for (String index : this.indicesUpdated) {
            builder.value(index);
        }
        builder.endArray();
        builder.startArray(DELETES_FIELD);
        for (String index : this.indicesDeleted) {
            builder.value(index);
        }
        builder.endArray();
        builder.endObject();
        builder.startObject(METADATA_CUSTOM_DIFF_FIELD);
        builder.startArray(UPSERTS_FIELD);
        for (String custom : this.customMetadataUpdated) {
            builder.value(custom);
        }
        builder.endArray();
        builder.startArray(DELETES_FIELD);
        for (String custom : this.customMetadataDeleted) {
            builder.value(custom);
        }
        builder.endArray();
        builder.endObject();
        builder.field(HASHES_OF_CONSISTENT_SETTINGS_UPDATED_FIELD, this.hashesOfConsistentSettingsUpdated);
        builder.endObject();
        builder.field(CLUSTER_BLOCKS_UPDATED_FIELD, this.clusterBlocksUpdated);
        builder.field(DISCOVERY_NODES_UPDATED_FIELD, this.discoveryNodesUpdated);
        builder.startObject(ROUTING_TABLE_DIFF);
        builder.startArray(UPSERTS_FIELD);
        for (String index : this.indicesRoutingUpdated) {
            builder.value(index);
        }
        builder.endArray();
        builder.startArray(DELETES_FIELD);
        for (String index : this.indicesRoutingDeleted) {
            builder.value(index);
        }
        builder.endArray();
        builder.endObject();
        builder.startObject(CLUSTER_STATE_CUSTOM_DIFF_FIELD);
        builder.startArray(UPSERTS_FIELD);
        for (String custom : this.clusterStateCustomUpdated) {
            builder.value(custom);
        }
        builder.endArray();
        builder.startArray(DELETES_FIELD);
        for (String custom : this.clusterStateCustomDeleted) {
            builder.value(custom);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static ClusterStateDiffManifest fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Builder builder = new Builder();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String currentFieldName = parser.currentName();
        block58: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (currentFieldName.equals(METADATA_DIFF_FIELD)) {
                    block59: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (token.isValue()) {
                            switch (currentFieldName) {
                                case "coordination_metadata_diff": {
                                    builder.coordinationMetadataUpdated(parser.booleanValue());
                                    continue block59;
                                }
                                case "settings_metadata_diff": {
                                    builder.settingsMetadataUpdated(parser.booleanValue());
                                    continue block59;
                                }
                                case "transient_settings_metadata_diff": {
                                    builder.transientSettingsMetadataUpdate(parser.booleanValue());
                                    continue block59;
                                }
                                case "templates_metadata_diff": {
                                    builder.templatesMetadataUpdated(parser.booleanValue());
                                    continue block59;
                                }
                                case "hashes_of_consistent_settings_diff": {
                                    builder.hashesOfConsistentSettingsUpdated(parser.booleanValue());
                                    continue block59;
                                }
                            }
                            throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
                        }
                        if (token == XContentParser.Token.START_OBJECT) {
                            if (currentFieldName.equals(INDICES_DIFF_FIELD)) {
                                block60: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                    currentFieldName = parser.currentName();
                                    token = parser.nextToken();
                                    switch (currentFieldName) {
                                        case "upserts": {
                                            builder.indicesUpdated(ClusterStateDiffManifest.convertListToString(parser.listOrderedMap()));
                                            continue block60;
                                        }
                                        case "deletes": {
                                            builder.indicesDeleted(ClusterStateDiffManifest.convertListToString(parser.listOrderedMap()));
                                            continue block60;
                                        }
                                    }
                                    throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
                                }
                                continue;
                            }
                            if (currentFieldName.equals(METADATA_CUSTOM_DIFF_FIELD)) {
                                block61: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                    currentFieldName = parser.currentName();
                                    token = parser.nextToken();
                                    switch (currentFieldName) {
                                        case "upserts": {
                                            builder.customMetadataUpdated(ClusterStateDiffManifest.convertListToString(parser.listOrderedMap()));
                                            continue block61;
                                        }
                                        case "deletes": {
                                            builder.customMetadataDeleted(ClusterStateDiffManifest.convertListToString(parser.listOrderedMap()));
                                            continue block61;
                                        }
                                    }
                                    throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
                                }
                                continue;
                            }
                            throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
                        }
                        throw new XContentParseException("Unexpected token [" + String.valueOf((Object)token) + "]");
                    }
                    continue;
                }
                if (currentFieldName.equals(ROUTING_TABLE_DIFF)) {
                    block62: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        currentFieldName = parser.currentName();
                        parser.nextToken();
                        switch (currentFieldName) {
                            case "upserts": {
                                builder.indicesRoutingUpdated(ClusterStateDiffManifest.convertListToString(parser.listOrderedMap()));
                                continue block62;
                            }
                            case "deletes": {
                                builder.indicesRoutingDeleted(ClusterStateDiffManifest.convertListToString(parser.listOrderedMap()));
                                continue block62;
                            }
                        }
                        throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
                    }
                    continue;
                }
                if (currentFieldName.equals(CLUSTER_STATE_CUSTOM_DIFF_FIELD)) {
                    block63: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        currentFieldName = parser.currentName();
                        parser.nextToken();
                        switch (currentFieldName) {
                            case "upserts": {
                                builder.clusterStateCustomUpdated(ClusterStateDiffManifest.convertListToString(parser.listOrderedMap()));
                                continue block63;
                            }
                            case "deletes": {
                                builder.clusterStateCustomDeleted(ClusterStateDiffManifest.convertListToString(parser.listOrderedMap()));
                                continue block63;
                            }
                        }
                        throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
                    }
                    continue;
                }
                throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
            }
            if (token.isValue()) {
                switch (currentFieldName) {
                    case "from_state_uuid": {
                        builder.fromStateUUID(parser.text());
                        continue block58;
                    }
                    case "to_state_uuid": {
                        builder.toStateUUID(parser.text());
                        continue block58;
                    }
                    case "cluster_blocks_diff": {
                        builder.clusterBlocksUpdated(parser.booleanValue());
                        continue block58;
                    }
                    case "discovery_nodes_diff": {
                        builder.discoveryNodesUpdated(parser.booleanValue());
                        continue block58;
                    }
                }
                throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
            }
            throw new XContentParseException("Unexpected token [" + String.valueOf((Object)token) + "]");
        }
        return builder.build();
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    private static List<String> convertListToString(List<Object> list) {
        ArrayList<String> convertedList = new ArrayList<String>();
        for (Object o : list) {
            convertedList.add(o.toString());
        }
        return convertedList;
    }

    public String getFromStateUUID() {
        return this.fromStateUUID;
    }

    public String getToStateUUID() {
        return this.toStateUUID;
    }

    public boolean isCoordinationMetadataUpdated() {
        return this.coordinationMetadataUpdated;
    }

    public boolean isSettingsMetadataUpdated() {
        return this.settingsMetadataUpdated;
    }

    public boolean isTransientSettingsMetadataUpdated() {
        return this.transientSettingsMetadataUpdated;
    }

    public boolean isTemplatesMetadataUpdated() {
        return this.templatesMetadataUpdated;
    }

    public List<String> getCustomMetadataUpdated() {
        return this.customMetadataUpdated;
    }

    public List<String> getCustomMetadataDeleted() {
        return this.customMetadataDeleted;
    }

    public List<String> getIndicesUpdated() {
        return this.indicesUpdated;
    }

    public List<String> getIndicesDeleted() {
        return this.indicesDeleted;
    }

    public boolean isClusterBlocksUpdated() {
        return this.clusterBlocksUpdated;
    }

    public boolean isDiscoveryNodesUpdated() {
        return this.discoveryNodesUpdated;
    }

    public boolean isHashesOfConsistentSettingsUpdated() {
        return this.hashesOfConsistentSettingsUpdated;
    }

    public List<String> getIndicesRoutingUpdated() {
        return this.indicesRoutingUpdated;
    }

    public List<String> getIndicesRoutingDeleted() {
        return this.indicesRoutingDeleted;
    }

    public List<String> getClusterStateCustomUpdated() {
        return this.clusterStateCustomUpdated;
    }

    public List<String> getClusterStateCustomDeleted() {
        return this.clusterStateCustomDeleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateDiffManifest that = (ClusterStateDiffManifest)o;
        return this.coordinationMetadataUpdated == that.coordinationMetadataUpdated && this.settingsMetadataUpdated == that.settingsMetadataUpdated && this.transientSettingsMetadataUpdated == that.transientSettingsMetadataUpdated && this.templatesMetadataUpdated == that.templatesMetadataUpdated && this.clusterBlocksUpdated == that.clusterBlocksUpdated && this.discoveryNodesUpdated == that.discoveryNodesUpdated && this.hashesOfConsistentSettingsUpdated == that.hashesOfConsistentSettingsUpdated && Objects.equals(this.fromStateUUID, that.fromStateUUID) && Objects.equals(this.toStateUUID, that.toStateUUID) && Objects.equals(this.customMetadataUpdated, that.customMetadataUpdated) && Objects.equals(this.customMetadataDeleted, that.customMetadataDeleted) && Objects.equals(this.indicesUpdated, that.indicesUpdated) && Objects.equals(this.indicesDeleted, that.indicesDeleted) && Objects.equals(this.indicesRoutingUpdated, that.indicesRoutingUpdated) && Objects.equals(this.indicesRoutingDeleted, that.indicesRoutingDeleted) && Objects.equals(this.clusterStateCustomUpdated, that.clusterStateCustomUpdated) && Objects.equals(this.clusterStateCustomDeleted, that.clusterStateCustomDeleted);
    }

    public int hashCode() {
        return Objects.hash(this.fromStateUUID, this.toStateUUID, this.coordinationMetadataUpdated, this.settingsMetadataUpdated, this.transientSettingsMetadataUpdated, this.templatesMetadataUpdated, this.customMetadataUpdated, this.customMetadataDeleted, this.indicesUpdated, this.indicesDeleted, this.clusterBlocksUpdated, this.discoveryNodesUpdated, this.indicesRoutingUpdated, this.indicesRoutingDeleted, this.hashesOfConsistentSettingsUpdated, this.clusterStateCustomUpdated, this.clusterStateCustomDeleted);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fromStateUUID);
        out.writeString(this.toStateUUID);
        out.writeBoolean(this.coordinationMetadataUpdated);
        out.writeBoolean(this.settingsMetadataUpdated);
        out.writeBoolean(this.transientSettingsMetadataUpdated);
        out.writeBoolean(this.templatesMetadataUpdated);
        out.writeStringCollection(this.indicesUpdated);
        out.writeStringCollection(this.indicesDeleted);
        out.writeStringCollection(this.customMetadataUpdated);
        out.writeStringCollection(this.customMetadataDeleted);
        out.writeBoolean(this.clusterBlocksUpdated);
        out.writeBoolean(this.discoveryNodesUpdated);
        out.writeStringCollection(this.indicesRoutingUpdated);
        out.writeStringCollection(this.indicesRoutingDeleted);
        out.writeBoolean(this.hashesOfConsistentSettingsUpdated);
        out.writeStringCollection(this.clusterStateCustomUpdated);
        out.writeStringCollection(this.clusterStateCustomDeleted);
    }

    public static class Builder {
        private String fromStateUUID;
        private String toStateUUID;
        private boolean coordinationMetadataUpdated;
        private boolean settingsMetadataUpdated;
        private boolean transientSettingsMetadataUpdated;
        private boolean templatesMetadataUpdated;
        private List<String> customMetadataUpdated;
        private List<String> customMetadataDeleted;
        private List<String> indicesUpdated;
        private List<String> indicesDeleted;
        private boolean clusterBlocksUpdated;
        private boolean discoveryNodesUpdated;
        private List<String> indicesRoutingUpdated;
        private List<String> indicesRoutingDeleted;
        private boolean hashesOfConsistentSettingsUpdated;
        private List<String> clusterStateCustomUpdated;
        private List<String> clusterStateCustomDeleted;

        public Builder fromStateUUID(String fromStateUUID) {
            this.fromStateUUID = fromStateUUID;
            return this;
        }

        public Builder toStateUUID(String toStateUUID) {
            this.toStateUUID = toStateUUID;
            return this;
        }

        public Builder coordinationMetadataUpdated(boolean coordinationMetadataUpdated) {
            this.coordinationMetadataUpdated = coordinationMetadataUpdated;
            return this;
        }

        public Builder settingsMetadataUpdated(boolean settingsMetadataUpdated) {
            this.settingsMetadataUpdated = settingsMetadataUpdated;
            return this;
        }

        public Builder transientSettingsMetadataUpdate(boolean settingsMetadataUpdated) {
            this.transientSettingsMetadataUpdated = settingsMetadataUpdated;
            return this;
        }

        public Builder templatesMetadataUpdated(boolean templatesMetadataUpdated) {
            this.templatesMetadataUpdated = templatesMetadataUpdated;
            return this;
        }

        public Builder hashesOfConsistentSettingsUpdated(boolean hashesOfConsistentSettingsUpdated) {
            this.hashesOfConsistentSettingsUpdated = hashesOfConsistentSettingsUpdated;
            return this;
        }

        public Builder customMetadataUpdated(List<String> customMetadataUpdated) {
            this.customMetadataUpdated = customMetadataUpdated;
            return this;
        }

        public Builder customMetadataDeleted(List<String> customMetadataDeleted) {
            this.customMetadataDeleted = customMetadataDeleted;
            return this;
        }

        public Builder indicesUpdated(List<String> indicesUpdated) {
            this.indicesUpdated = indicesUpdated;
            return this;
        }

        public Builder indicesDeleted(List<String> indicesDeleted) {
            this.indicesDeleted = indicesDeleted;
            return this;
        }

        public Builder clusterBlocksUpdated(boolean clusterBlocksUpdated) {
            this.clusterBlocksUpdated = clusterBlocksUpdated;
            return this;
        }

        public Builder discoveryNodesUpdated(boolean discoveryNodesUpdated) {
            this.discoveryNodesUpdated = discoveryNodesUpdated;
            return this;
        }

        public Builder indicesRoutingUpdated(List<String> indicesRoutingUpdated) {
            this.indicesRoutingUpdated = indicesRoutingUpdated;
            return this;
        }

        public Builder indicesRoutingDeleted(List<String> indicesRoutingDeleted) {
            this.indicesRoutingDeleted = indicesRoutingDeleted;
            return this;
        }

        public Builder clusterStateCustomUpdated(List<String> clusterStateCustomUpdated) {
            this.clusterStateCustomUpdated = clusterStateCustomUpdated;
            return this;
        }

        public Builder clusterStateCustomDeleted(List<String> clusterStateCustomDeleted) {
            this.clusterStateCustomDeleted = clusterStateCustomDeleted;
            return this;
        }

        public ClusterStateDiffManifest build() {
            return new ClusterStateDiffManifest(this.fromStateUUID, this.toStateUUID, this.coordinationMetadataUpdated, this.settingsMetadataUpdated, this.transientSettingsMetadataUpdated, this.templatesMetadataUpdated, this.customMetadataUpdated, this.customMetadataDeleted, this.indicesUpdated, this.indicesDeleted, this.clusterBlocksUpdated, this.discoveryNodesUpdated, this.indicesRoutingUpdated, this.indicesRoutingDeleted, this.hashesOfConsistentSettingsUpdated, this.clusterStateCustomUpdated, this.clusterStateCustomDeleted);
        }
    }
}

