/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.LatchedActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.RemoteWritableEntityStore;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.compress.Compressor;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteStateTransferException;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteClusterStateBlobStore;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteIndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model.RemoteReadResult;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteIndexMetadataManager {
    public static final TimeValue INDEX_METADATA_UPLOAD_TIMEOUT_DEFAULT = TimeValue.timeValueMillis(20000L);
    public static final Setting<TimeValue> INDEX_METADATA_UPLOAD_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.state.index_metadata.upload_timeout", INDEX_METADATA_UPLOAD_TIMEOUT_DEFAULT, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    private final RemoteWritableEntityStore<IndexMetadata, RemoteIndexMetadata> indexMetadataBlobStore;
    private final Compressor compressor;
    private final NamedXContentRegistry namedXContentRegistry;
    private volatile TimeValue indexMetadataUploadTimeout;

    public RemoteIndexMetadataManager(ClusterSettings clusterSettings, String clusterName, BlobStoreRepository blobStoreRepository, BlobStoreTransferService blobStoreTransferService, ThreadPool threadpool) {
        this.indexMetadataBlobStore = new RemoteClusterStateBlobStore<IndexMetadata, RemoteIndexMetadata>(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read");
        this.namedXContentRegistry = blobStoreRepository.getNamedXContentRegistry();
        this.compressor = blobStoreRepository.getCompressor();
        this.indexMetadataUploadTimeout = clusterSettings.get(INDEX_METADATA_UPLOAD_TIMEOUT_SETTING);
        clusterSettings.addSettingsUpdateConsumer(INDEX_METADATA_UPLOAD_TIMEOUT_SETTING, this::setIndexMetadataUploadTimeout);
    }

    CheckedRunnable<IOException> getAsyncIndexMetadataWriteAction(IndexMetadata indexMetadata, String clusterUUID, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> latchedActionListener) {
        RemoteIndexMetadata remoteIndexMetadata = new RemoteIndexMetadata(indexMetadata, clusterUUID, this.compressor, this.namedXContentRegistry);
        ActionListener<Void> completionListener = ActionListener.wrap(resp -> latchedActionListener.onResponse(remoteIndexMetadata.getUploadedMetadata()), ex -> latchedActionListener.onFailure(new RemoteStateTransferException(indexMetadata.getIndex().getName(), (Throwable)ex)));
        return () -> this.indexMetadataBlobStore.writeAsync(remoteIndexMetadata, completionListener);
    }

    CheckedRunnable<IOException> getAsyncIndexMetadataReadAction(String clusterUUID, String uploadedFilename, LatchedActionListener<RemoteReadResult> latchedActionListener) {
        RemoteIndexMetadata remoteIndexMetadata = new RemoteIndexMetadata(RemoteClusterStateUtils.getFormattedIndexFileName(uploadedFilename), clusterUUID, this.compressor, this.namedXContentRegistry);
        ActionListener<IndexMetadata> actionListener = ActionListener.wrap(response -> latchedActionListener.onResponse(new RemoteReadResult(response, "index", response.getIndex().getName())), latchedActionListener::onFailure);
        return () -> this.indexMetadataBlobStore.readAsync(remoteIndexMetadata, actionListener);
    }

    IndexMetadata getIndexMetadata(ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata, String clusterUUID) {
        RemoteIndexMetadata remoteIndexMetadata = new RemoteIndexMetadata(RemoteClusterStateUtils.getFormattedIndexFileName(uploadedIndexMetadata.getUploadedFilename()), clusterUUID, this.compressor, this.namedXContentRegistry);
        try {
            return this.indexMetadataBlobStore.read(remoteIndexMetadata);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading IndexMetadata - %s", uploadedIndexMetadata.getUploadedFilename()), e);
        }
    }

    Map<String, IndexMetadata> getIndexMetadataMap(String clusterUUID, ClusterMetadataManifest clusterMetadataManifest) {
        assert (Objects.equals(clusterUUID, clusterMetadataManifest.getClusterUUID())) : "Corrupt ClusterMetadataManifest found. Cluster UUID mismatch.";
        HashMap<String, IndexMetadata> remoteIndexMetadata = new HashMap<String, IndexMetadata>();
        for (ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata : clusterMetadataManifest.getIndices()) {
            IndexMetadata indexMetadata = this.getIndexMetadata(uploadedIndexMetadata, clusterUUID);
            remoteIndexMetadata.put(uploadedIndexMetadata.getIndexUUID(), indexMetadata);
        }
        return remoteIndexMetadata;
    }

    public TimeValue getIndexMetadataUploadTimeout() {
        return this.indexMetadataUploadTimeout;
    }

    private void setIndexMetadataUploadTimeout(TimeValue newIndexMetadataUploadTimeout) {
        this.indexMetadataUploadTimeout = newIndexMetadataUploadTimeout;
    }
}

