/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.Streams;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.AbstractRemoteWritableBlobEntity;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.BlobPathParameters;
import org.graylog.shaded.opensearch2.org.opensearch.core.compress.Compressor;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreUtils;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.ChecksumBlobStoreFormat;

public class RemoteClusterMetadataManifest
extends AbstractRemoteWritableBlobEntity<ClusterMetadataManifest> {
    public static final String MANIFEST = "manifest";
    public static final int SPLITTED_MANIFEST_FILE_LENGTH = 6;
    public static final String METADATA_MANIFEST_NAME_FORMAT = "%s";
    public static final int MANIFEST_CURRENT_CODEC_VERSION = 2;
    public static final String COMMITTED = "C";
    public static final String PUBLISHED = "P";
    public static final ChecksumBlobStoreFormat<ClusterMetadataManifest> CLUSTER_METADATA_MANIFEST_FORMAT_V0 = new ChecksumBlobStoreFormat<ClusterMetadataManifest>("cluster-metadata-manifest", "%s", ClusterMetadataManifest::fromXContentV0);
    public static final ChecksumBlobStoreFormat<ClusterMetadataManifest> CLUSTER_METADATA_MANIFEST_FORMAT_V1 = new ChecksumBlobStoreFormat<ClusterMetadataManifest>("cluster-metadata-manifest", "%s", ClusterMetadataManifest::fromXContentV1);
    public static final ChecksumBlobStoreFormat<ClusterMetadataManifest> CLUSTER_METADATA_MANIFEST_FORMAT = new ChecksumBlobStoreFormat<ClusterMetadataManifest>("cluster-metadata-manifest", "%s", ClusterMetadataManifest::fromXContent);
    private ClusterMetadataManifest clusterMetadataManifest;

    public RemoteClusterMetadataManifest(ClusterMetadataManifest clusterMetadataManifest, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.clusterMetadataManifest = clusterMetadataManifest;
    }

    public RemoteClusterMetadataManifest(String blobName, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.blobName = blobName;
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of(MANIFEST), MANIFEST);
    }

    @Override
    public String getType() {
        return MANIFEST;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", MANIFEST, RemoteStoreUtils.invertLong(this.clusterMetadataManifest.getClusterTerm()), RemoteStoreUtils.invertLong(this.clusterMetadataManifest.getStateVersion()), this.clusterMetadataManifest.isCommitted() ? COMMITTED : PUBLISHED, RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(this.clusterMetadataManifest.getCodecVersion()));
        return blobFileName;
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(MANIFEST, this.blobName);
    }

    @Override
    public InputStream serialize() throws IOException {
        return CLUSTER_METADATA_MANIFEST_FORMAT.serialize(this.clusterMetadataManifest, this.generateBlobFileName(), this.getCompressor(), RemoteClusterStateUtils.FORMAT_PARAMS).streamInput();
    }

    @Override
    public ClusterMetadataManifest deserialize(InputStream inputStream) throws IOException {
        ChecksumBlobStoreFormat<ClusterMetadataManifest> blobStoreFormat = this.getClusterMetadataManifestBlobStoreFormat();
        return blobStoreFormat.deserialize(this.blobName, this.getNamedXContentRegistry(), Streams.readFully(inputStream));
    }

    int getManifestCodecVersion() {
        assert (this.blobName != null);
        String[] splitName = this.getBlobFileName().split("__");
        if (splitName.length == 6) {
            return Integer.parseInt(splitName[splitName.length - 1]);
        }
        if (splitName.length < 6) {
            return 0;
        }
        throw new IllegalArgumentException("Manifest file name is corrupted : " + this.blobName);
    }

    private ChecksumBlobStoreFormat<ClusterMetadataManifest> getClusterMetadataManifestBlobStoreFormat() {
        long codecVersion = this.getManifestCodecVersion();
        if (codecVersion == 2L) {
            return CLUSTER_METADATA_MANIFEST_FORMAT;
        }
        if (codecVersion == 1L) {
            return CLUSTER_METADATA_MANIFEST_FORMAT_V1;
        }
        if (codecVersion == 0L) {
            return CLUSTER_METADATA_MANIFEST_FORMAT_V0;
        }
        throw new IllegalArgumentException("Cluster metadata manifest file is corrupted, don't have valid codec version");
    }
}

