/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.Streams;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.AbstractRemoteWritableBlobEntity;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.BlobPathParameters;
import org.graylog.shaded.opensearch2.org.opensearch.core.compress.Compressor;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreUtils;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.ChecksumWritableBlobStoreFormat;

public class RemoteDiscoveryNodes
extends AbstractRemoteWritableBlobEntity<DiscoveryNodes> {
    public static final String DISCOVERY_NODES = "nodes";
    public static final ChecksumWritableBlobStoreFormat<DiscoveryNodes> DISCOVERY_NODES_FORMAT = new ChecksumWritableBlobStoreFormat<DiscoveryNodes>("nodes", is -> DiscoveryNodes.readFrom(is, null));
    private DiscoveryNodes discoveryNodes;
    private long stateVersion;

    public RemoteDiscoveryNodes(DiscoveryNodes discoveryNodes, long stateVersion, String clusterUUID, Compressor compressor) {
        super(clusterUUID, compressor, null);
        this.discoveryNodes = discoveryNodes;
        this.stateVersion = stateVersion;
    }

    public RemoteDiscoveryNodes(String blobName, String clusterUUID, Compressor compressor) {
        super(clusterUUID, compressor, null);
        this.blobName = blobName;
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of("ephemeral"), DISCOVERY_NODES);
    }

    @Override
    public String getType() {
        return DISCOVERY_NODES;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.stateVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(DISCOVERY_NODES, this.blobName);
    }

    @Override
    public InputStream serialize() throws IOException {
        return DISCOVERY_NODES_FORMAT.serialize(this.discoveryNodes, this.generateBlobFileName(), this.getCompressor()).streamInput();
    }

    @Override
    public DiscoveryNodes deserialize(InputStream inputStream) throws IOException {
        return DISCOVERY_NODES_FORMAT.deserialize(this.blobName, Streams.readFully(inputStream));
    }
}

