/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.Streams;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.AbstractRemoteWritableBlobEntity;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.BlobPathParameters;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.compress.Compressor;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreUtils;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.ChecksumBlobStoreFormat;

public class RemotePersistentSettingsMetadata
extends AbstractRemoteWritableBlobEntity<Settings> {
    public static final String SETTING_METADATA = "settings";
    public static final ChecksumBlobStoreFormat<Settings> SETTINGS_METADATA_FORMAT = new ChecksumBlobStoreFormat<Settings>("settings", "%s", Settings::fromXContent);
    private Settings persistentSettings;
    private long metadataVersion;

    public RemotePersistentSettingsMetadata(Settings settings, long metadataVersion, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.persistentSettings = settings;
        this.metadataVersion = metadataVersion;
    }

    public RemotePersistentSettingsMetadata(String blobName, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.blobName = blobName;
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of("global-metadata"), SETTING_METADATA);
    }

    @Override
    public String getType() {
        return SETTING_METADATA;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.metadataVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public InputStream serialize() throws IOException {
        return SETTINGS_METADATA_FORMAT.serialize(this.persistentSettings, this.generateBlobFileName(), this.getCompressor(), RemoteClusterStateUtils.FORMAT_PARAMS).streamInput();
    }

    @Override
    public Settings deserialize(InputStream inputStream) throws IOException {
        return SETTINGS_METADATA_FORMAT.deserialize(this.blobName, this.getNamedXContentRegistry(), Streams.readFully(inputStream));
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(SETTING_METADATA, this.blobName);
    }
}

