/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.http;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.http.HttpChannel;
import org.graylog.shaded.opensearch2.org.opensearch.http.HttpChunk;
import org.graylog.shaded.opensearch2.org.opensearch.http.HttpTransportSettings;
import org.graylog.shaded.opensearch2.org.opensearch.http.StreamingHttpChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

class HttpTracer {
    private final Logger logger = LogManager.getLogger(HttpTracer.class);
    private volatile String[] tracerLogInclude;
    private volatile String[] tracerLogExclude;

    HttpTracer(Settings settings, ClusterSettings clusterSettings) {
        this.setTracerLogInclude(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_INCLUDE.get(settings));
        this.setTracerLogExclude(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_EXCLUDE.get(settings));
        clusterSettings.addSettingsUpdateConsumer(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_INCLUDE, this::setTracerLogInclude);
        clusterSettings.addSettingsUpdateConsumer(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_EXCLUDE, this::setTracerLogExclude);
    }

    @Nullable
    HttpTracer maybeTraceRequest(RestRequest restRequest, @Nullable Exception e) {
        if (this.logger.isTraceEnabled() && TransportService.shouldTraceAction(restRequest.uri(), this.tracerLogInclude, this.tracerLogExclude)) {
            this.logger.trace((Message)new ParameterizedMessage("[{}][{}][{}][{}] received request from [{}]", new Object[]{restRequest.getRequestId(), restRequest.header("X-Opaque-Id"), restRequest.method(), restRequest.uri(), restRequest.getHttpChannel()}), (Throwable)e);
            return this;
        }
        return null;
    }

    void traceResponse(RestResponse restResponse, HttpChannel httpChannel, String contentLength, String opaqueHeader, long requestId, boolean success) {
        this.logger.trace((Message)new ParameterizedMessage("[{}][{}][{}][{}][{}] sent response to [{}] success [{}]", new Object[]{requestId, opaqueHeader, restResponse.status(), restResponse.contentType(), contentLength, httpChannel, success}));
    }

    void traceChunk(HttpChunk chunk, StreamingHttpChannel httpChannel, String contentLength, String opaqueHeader, long requestId, boolean success) {
        this.logger.trace((Message)new ParameterizedMessage("[{}][{}][{}] sent next chunk to [{}] success [{}]", new Object[]{requestId, opaqueHeader, contentLength, httpChannel, success}));
    }

    private void setTracerLogInclude(List<String> tracerLogInclude) {
        this.tracerLogInclude = tracerLogInclude.toArray(Strings.EMPTY_ARRAY);
    }

    private void setTracerLogExclude(List<String> tracerLogExclude) {
        this.tracerLogExclude = tracerLogExclude.toArray(Strings.EMPTY_ARRAY);
    }
}

