/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.LongPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.NumericDocValuesField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexCommit;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriterConfig;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LiveIndexWriterConfig;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ShuffleForcedMergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SoftDeletesRetentionMergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.StandardDirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.StoredFields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ReferenceManager;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.LockObtainFailedException;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.InfoStream;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.Booleans;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.SuppressForbidden;
import org.graylog.shaded.opensearch2.org.opensearch.common.concurrent.GatedCloseable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.LoggerInfoStream;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.Queries;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.CounterMetric;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.KeyedLock;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ReleasableLock;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.Assertions;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.VersionType;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.CombinedDeletionPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.CombinedDocValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.CompletionStatsCache;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.DeleteVersionValue;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Engine;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.EngineConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.EngineCreationFailureException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.EngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.FlushFailedEngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.IndexVersionValue;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.LiveVersionMap;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.LuceneChangesSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.OpenSearchConcurrentMergeScheduler;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.OpenSearchReaderManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.PrunePostingsMergePolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.RecoverySourcePruneMergePolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.RefreshFailedEngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.SafeCommitInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Segment;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.SegmentsStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.SoftDeletesPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.TranslogLeafReader;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.VersionConflictEngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.VersionValue;
import org.graylog.shaded.opensearch2.org.opensearch.index.fieldvisitor.IdOnlyFieldVisitor;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParsedDocument;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Uid;
import org.graylog.shaded.opensearch2.org.opensearch.index.merge.MergeStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.merge.OnGoingMerge;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.LocalCheckpointTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.SeqNoStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.SequenceNumbers;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.OpenSearchMergePolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.InternalTranslogManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogCorruptedException;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogDeletionPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogException;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.listener.CompositeTranslogEventListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.listener.TranslogEventListener;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.completion.CompletionStats;

public class InternalEngine
extends Engine {
    private volatile long lastDeleteVersionPruneTimeMSec;
    private final InternalTranslogManager translogManager;
    private final OpenSearchConcurrentMergeScheduler mergeScheduler;
    private final IndexWriter indexWriter;
    private final ExternalReaderManager externalReaderManager;
    private final OpenSearchReaderManager internalReaderManager;
    private final Lock flushLock;
    private final ReentrantLock optimizeLock;
    private final LiveVersionMap versionMap;
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final Engine.IndexThrottle throttle;
    private final LocalCheckpointTracker localCheckpointTracker;
    private final CombinedDeletionPolicy combinedDeletionPolicy;
    private final AtomicInteger throttleRequestCount;
    private final AtomicLong maxUnsafeAutoIdTimestamp;
    private final AtomicLong maxSeenAutoIdTimestamp;
    private final AtomicLong maxSeqNoOfUpdatesOrDeletes;
    private final CounterMetric numVersionLookups;
    private final CounterMetric numIndexVersionsLookups;
    private final CounterMetric numDocDeletes;
    private final CounterMetric numDocAppends;
    private final CounterMetric numDocUpdates;
    private final NumericDocValuesField softDeletesField;
    private final SoftDeletesPolicy softDeletesPolicy;
    private final LastRefreshedCheckpointListener lastRefreshedCheckpointListener;
    private final CompletionStatsCache completionStatsCache;
    private final AtomicBoolean trackTranslogLocation;
    private final KeyedLock<Long> noOpKeyedLock;
    private final AtomicBoolean shouldPeriodicallyFlushAfterBigMerge;
    private final AtomicLong inFlightDocCount;
    private final int maxDocs;
    @Nullable
    private final String historyUUID;
    @Nullable
    private volatile String forceMergeUUID;
    private final Object refreshIfNeededMutex;

    public InternalEngine(EngineConfig engineConfig) {
        this(engineConfig, 0x7FFFFF7F, LocalCheckpointTracker::new, TranslogEventListener.NOOP_TRANSLOG_EVENT_LISTENER);
    }

    public InternalEngine(EngineConfig engineConfig, TranslogEventListener translogEventListener) {
        this(engineConfig, 0x7FFFFF7F, LocalCheckpointTracker::new, translogEventListener);
    }

    public InternalTranslogManager translogManager() {
        return this.translogManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InternalEngine(EngineConfig engineConfig, int maxDocs, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, TranslogEventListener translogEventListener) {
        block22: {
            super(engineConfig);
            this.flushLock = new ReentrantLock();
            this.optimizeLock = new ReentrantLock();
            this.versionMap = new LiveVersionMap();
            this.throttleRequestCount = new AtomicInteger();
            this.maxUnsafeAutoIdTimestamp = new AtomicLong(-1L);
            this.maxSeenAutoIdTimestamp = new AtomicLong(-1L);
            this.numVersionLookups = new CounterMetric();
            this.numIndexVersionsLookups = new CounterMetric();
            this.numDocDeletes = new CounterMetric();
            this.numDocAppends = new CounterMetric();
            this.numDocUpdates = new CounterMetric();
            this.softDeletesField = Lucene.newSoftDeletesField();
            this.trackTranslogLocation = new AtomicBoolean(false);
            this.noOpKeyedLock = new KeyedLock();
            this.shouldPeriodicallyFlushAfterBigMerge = new AtomicBoolean(false);
            this.inFlightDocCount = new AtomicLong();
            this.refreshIfNeededMutex = new Object();
            this.maxDocs = maxDocs;
            if (!engineConfig.isAutoGeneratedIDsOptimizationEnabled()) {
                this.updateAutoIdTimestamp(Long.MAX_VALUE, true);
            }
            TranslogDeletionPolicy translogDeletionPolicy = this.getTranslogDeletionPolicy(engineConfig);
            this.store.incRef();
            IndexWriter writer = null;
            ExternalReaderManager externalReaderManager = null;
            OpenSearchReaderManager internalReaderManager = null;
            EngineMergeScheduler scheduler = null;
            InternalTranslogManager translogManagerRef = null;
            boolean success = false;
            try {
                this.lastDeleteVersionPruneTimeMSec = engineConfig.getThreadPool().relativeTimeInMillis();
                scheduler = new EngineMergeScheduler(engineConfig.getShardId(), engineConfig.getIndexSettings());
                this.mergeScheduler = scheduler;
                this.throttle = new Engine.IndexThrottle();
                try {
                    this.store.trimUnsafeCommits(engineConfig.getTranslogConfig().getTranslogPath());
                    Map<String, String> userData = this.store.readLastCommittedSegmentsInfo().getUserData();
                    String translogUUID = Objects.requireNonNull(userData.get("translog_uuid"));
                    TranslogEventListener internalTranslogEventListener = new TranslogEventListener(){

                        @Override
                        public void onAfterTranslogSync() {
                            InternalEngine.this.revisitIndexDeletionPolicyOnTranslogSynced();
                        }

                        @Override
                        public void onAfterTranslogRecovery() {
                            InternalEngine.this.flush(false, true);
                            InternalEngine.this.translogManager.trimUnreferencedTranslogFiles();
                        }

                        @Override
                        public void onFailure(String reason, Exception ex) {
                            if (ex instanceof AlreadyClosedException) {
                                InternalEngine.this.failOnTragicEvent((AlreadyClosedException)ex);
                            } else {
                                InternalEngine.this.failEngine(reason, ex);
                            }
                        }
                    };
                    this.translogManager = translogManagerRef = new InternalTranslogManager(engineConfig.getTranslogConfig(), engineConfig.getPrimaryTermSupplier(), engineConfig.getGlobalCheckpointSupplier(), translogDeletionPolicy, this.shardId, this.readLock, this::getLocalCheckpointTracker, translogUUID, new CompositeTranslogEventListener(Arrays.asList(internalTranslogEventListener, translogEventListener), this.shardId), this::ensureOpen, engineConfig.getTranslogFactory(), engineConfig.getStartedPrimarySupplier());
                    this.softDeletesPolicy = this.newSoftDeletesPolicy();
                    this.combinedDeletionPolicy = new CombinedDeletionPolicy(this.logger, translogDeletionPolicy, this.softDeletesPolicy, this.translogManager::getLastSyncedGlobalCheckpoint);
                    this.localCheckpointTracker = this.createLocalCheckpointTracker(localCheckpointTrackerSupplier);
                    writer = this.createWriter();
                    this.bootstrapAppendOnlyInfoFromWriter(writer);
                    Map<String, String> commitData = InternalEngine.commitDataAsMap(writer);
                    this.historyUUID = this.loadHistoryUUID(commitData);
                    this.forceMergeUUID = commitData.get("force_merge_uuid");
                    this.indexWriter = writer;
                }
                catch (IOException | TranslogCorruptedException e) {
                    throw new EngineCreationFailureException(this.shardId, "failed to create engine", e);
                }
                catch (AssertionError e) {
                    if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriter.filesExist")) {
                        throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)((Object)e));
                    }
                    throw e;
                }
                externalReaderManager = this.createReaderManager(new RefreshWarmerListener(this.logger, this.isClosed, engineConfig));
                this.internalReaderManager = internalReaderManager = externalReaderManager.internalReaderManager;
                this.externalReaderManager = externalReaderManager;
                internalReaderManager.addListener(this.versionMap);
                for (ReferenceManager.RefreshListener listener : engineConfig.getExternalRefreshListener()) {
                    this.externalReaderManager.addListener(listener);
                }
                for (ReferenceManager.RefreshListener listener : engineConfig.getInternalRefreshListener()) {
                    this.internalReaderManager.addListener(listener);
                }
                this.lastRefreshedCheckpointListener = new LastRefreshedCheckpointListener(this.localCheckpointTracker.getProcessedCheckpoint());
                this.internalReaderManager.addListener(this.lastRefreshedCheckpointListener);
                this.maxSeqNoOfUpdatesOrDeletes = new AtomicLong(SequenceNumbers.max(this.localCheckpointTracker.getMaxSeqNo(), this.translogManager.getMaxSeqNo()));
                if (this.localCheckpointTracker.getPersistedCheckpoint() < this.localCheckpointTracker.getMaxSeqNo()) {
                    try (Engine.Searcher searcher = this.acquireSearcher("restore_version_map_and_checkpoint_tracker", Engine.SearcherScope.INTERNAL);){
                        this.restoreVersionMapAndCheckpointTracker(Lucene.wrapAllDocsLive(searcher.getDirectoryReader()));
                    }
                    catch (IOException e) {
                        throw new EngineCreationFailureException(this.config().getShardId(), "failed to restore version map and local checkpoint tracker", e);
                    }
                }
                this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
                this.externalReaderManager.addListener(this.completionStatsCache);
                success = true;
                if (success) break block22;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(writer, translogManagerRef, internalReaderManager, externalReaderManager, scheduler);
                    if (!this.isClosed.get()) {
                        this.store.decRef();
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(writer, translogManagerRef, internalReaderManager, externalReaderManager, scheduler);
            if (!this.isClosed.get()) {
                this.store.decRef();
            }
        }
        this.logger.trace("created new InternalEngine");
    }

    private LocalCheckpointTracker createLocalCheckpointTracker(BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) throws IOException {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.store.readLastCommittedSegmentsInfo().userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo;
        long localCheckpoint = seqNoStats.localCheckpoint;
        this.logger.trace("recovered maximum sequence number [{}] and local checkpoint [{}]", (Object)maxSeqNo, (Object)localCheckpoint);
        return localCheckpointTrackerSupplier.apply(maxSeqNo, localCheckpoint);
    }

    private SoftDeletesPolicy newSoftDeletesPolicy() throws IOException {
        Map<String, String> commitUserData = this.store.readLastCommittedSegmentsInfo().userData;
        long lastMinRetainedSeqNo = commitUserData.containsKey("min_retained_seq_no") ? Long.parseLong(commitUserData.get("min_retained_seq_no")) : Long.parseLong(commitUserData.get("max_seq_no")) + 1L;
        return new SoftDeletesPolicy(this.translogManager::getLastSyncedGlobalCheckpoint, lastMinRetainedSeqNo, this.engineConfig.getIndexSettings().getSoftDeleteRetentionOperations(), this.engineConfig.retentionLeasesSupplier());
    }

    @Override
    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }

    @Override
    final boolean assertSearcherIsWarmedUp(String source, Engine.SearcherScope scope) {
        if (scope == Engine.SearcherScope.EXTERNAL) {
            switch (source) {
                case "segments": 
                case "segments_stats": {
                    break;
                }
                default: {
                    assert (this.externalReaderManager.isWarmedUp) : "searcher was not warmed up yet for source[" + source + "]";
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public int restoreLocalHistoryFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner) throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            int n;
            block12: {
                this.ensureOpen();
                long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
                Translog.Snapshot snapshot = this.translogManager().getTranslog().newSnapshot(localCheckpoint + 1L, Long.MAX_VALUE);
                try {
                    n = translogRecoveryRunner.run(this, snapshot);
                    if (snapshot == null) break block12;
                }
                catch (Throwable throwable) {
                    if (snapshot != null) {
                        try {
                            snapshot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                snapshot.close();
            }
            return n;
        }
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            this.ensureOpen();
            long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
            long maxSeqNo = this.localCheckpointTracker.getMaxSeqNo();
            int numNoOpsAdded = 0;
            long seqNo = localCheckpoint + 1L;
            while (seqNo <= maxSeqNo) {
                this.innerNoOp(new Engine.NoOp(seqNo, primaryTerm, Engine.Operation.Origin.PRIMARY, System.nanoTime(), "filling gaps"));
                ++numNoOpsAdded;
                assert (seqNo <= this.localCheckpointTracker.getProcessedCheckpoint()) : "local checkpoint did not advance; was [" + seqNo + "], now [" + this.localCheckpointTracker.getProcessedCheckpoint() + "]";
                seqNo = this.localCheckpointTracker.getProcessedCheckpoint() + 1L;
            }
            this.translogManager.syncTranslog();
            assert (this.localCheckpointTracker.getPersistedCheckpoint() == maxSeqNo) : "persisted local checkpoint did not advance to max seq no; is [" + this.localCheckpointTracker.getPersistedCheckpoint() + "], max seq no [" + maxSeqNo + "]";
            int n = numNoOpsAdded;
            return n;
        }
    }

    private void bootstrapAppendOnlyInfoFromWriter(IndexWriter writer) {
        for (Map.Entry<String, String> entry : writer.getLiveCommitData()) {
            if (!"max_unsafe_auto_id_timestamp".equals(entry.getKey())) continue;
            assert (this.maxUnsafeAutoIdTimestamp.get() == -1L) : "max unsafe timestamp was assigned already [" + this.maxUnsafeAutoIdTimestamp.get() + "]";
            this.updateAutoIdTimestamp(Long.parseLong(entry.getValue()), true);
        }
    }

    @Override
    public InternalEngine recoverFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.translogManager.getPendingTranslogRecovery().get()) {
                throw new IllegalStateException("Engine has already been recovered");
            }
            try {
                this.recoverFromTranslogInternal(translogRecoveryRunner, recoverUpToSeqNo);
            }
            catch (Exception e) {
                try {
                    this.translogManager.getPendingTranslogRecovery().set(true);
                    this.failEngine("failed to recover from translog", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
        }
        return this;
    }

    @Override
    public void skipTranslogRecovery() {
        this.translogManager.skipTranslogRecovery();
    }

    private void recoverFromTranslogInternal(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) throws IOException {
        int opsRecovered;
        block10: {
            long localCheckpoint = this.getProcessedLocalCheckpoint();
            if (localCheckpoint < recoverUpToSeqNo) {
                try (Translog.Snapshot snapshot = this.translogManager.getTranslog().newSnapshot(localCheckpoint + 1L, recoverUpToSeqNo);){
                    opsRecovered = translogRecoveryRunner.run(this, snapshot);
                    break block10;
                }
                catch (Exception e) {
                    throw new EngineException(this.shardId, "failed to recover from translog", e, new Object[0]);
                }
            }
            opsRecovered = 0;
        }
        assert (this.translogManager.getPendingTranslogRecovery().get()) : "translogRecovery is not pending but should be";
        this.translogManager.getPendingTranslogRecovery().set(false);
        this.logger.trace(() -> new ParameterizedMessage("flushing post recovery from translog: ops recovered [{}], current translog generation [{}]", (Object)opsRecovered, (Object)this.translogManager.getTranslog().currentFileGeneration()));
        this.flush(false, true);
        this.translogManager.trimUnreferencedReaders();
    }

    boolean hasSnapshottedCommits() {
        return this.combinedDeletionPolicy.hasSnapshottedCommits();
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return this.translogManager.isTranslogSyncNeeded();
    }

    @Override
    public boolean ensureTranslogSynced(Stream<Translog.Location> locations) throws IOException {
        return this.translogManager.ensureTranslogSynced(locations);
    }

    @Override
    public void syncTranslog() throws IOException {
        this.translogManager.syncTranslog();
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.translogManager.getTranslogStats();
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return this.translogManager.getTranslogLastWriteLocation();
    }

    private void revisitIndexDeletionPolicyOnTranslogSynced() {
        try {
            if (this.combinedDeletionPolicy.hasUnreferencedCommits()) {
                this.indexWriter.deleteUnusedFiles();
            }
            this.translogManager.trimUnreferencedReaders();
        }
        catch (IOException ex) {
            throw new TranslogException(this.shardId, "Failed to execute index deletion policy on translog synced", ex);
        }
    }

    @Override
    public String getHistoryUUID() {
        return this.historyUUID;
    }

    @Nullable
    public String getForceMergeUUID() {
        return this.forceMergeUUID;
    }

    @Override
    public long getWritingBytes() {
        return this.indexWriter.getFlushingBytes() + this.versionMap.getRefreshingBytes();
    }

    private ExternalReaderManager createReaderManager(RefreshWarmerListener externalRefreshListener) throws EngineException {
        ExternalReaderManager externalReaderManager;
        block7: {
            boolean success = false;
            OpenSearchReaderManager internalReaderManager = null;
            try {
                OpenSearchDirectoryReader directoryReader = OpenSearchDirectoryReader.wrap(DirectoryReader.open(this.indexWriter), this.shardId);
                internalReaderManager = new OpenSearchReaderManager(directoryReader);
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                ExternalReaderManager externalReaderManager2 = new ExternalReaderManager(internalReaderManager, externalRefreshListener);
                success = true;
                externalReaderManager = externalReaderManager2;
                if (success) break block7;
            }
            catch (IOException e) {
                try {
                    this.maybeFailEngine("start", e);
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException inner) {
                        e.addSuppressed(inner);
                    }
                    throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", e);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(internalReaderManager, this.indexWriter);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(internalReaderManager, this.indexWriter);
        }
        return externalReaderManager;
    }

    @Override
    public Engine.GetResult get(Engine.Get get, BiFunction<String, Engine.SearcherScope, Engine.Searcher> searcherFactory) throws EngineException {
        assert (Objects.equals(get.uid().field(), "_id")) : get.uid().field();
        try (ReleasableLock ignored = this.readLock.acquire();){
            Engine.SearcherScope scope;
            this.ensureOpen();
            if (get.realtime()) {
                VersionValue versionValue = null;
                try (Releasable ignore = this.versionMap.acquireLock(get.uid().bytes());){
                    versionValue = this.getVersionFromMap(get.uid().bytes());
                }
                if (versionValue != null) {
                    block28: {
                        if (versionValue.isDelete()) {
                            ignore = Engine.GetResult.NOT_EXISTS;
                            return ignore;
                        }
                        if (get.versionType().isVersionConflictForReads(versionValue.version, get.version())) {
                            throw new VersionConflictEngineException(this.shardId, get.id(), get.versionType().explainConflictForReads(versionValue.version, get.version()));
                        }
                        if (get.getIfSeqNo() != -2L && (get.getIfSeqNo() != versionValue.seqNo || get.getIfPrimaryTerm() != versionValue.term)) {
                            throw new VersionConflictEngineException(this.shardId, get.id(), get.getIfSeqNo(), get.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
                        }
                        if (get.isReadFromTranslog()) {
                            if (versionValue.getLocation() != null) {
                                try {
                                    Translog.Operation operation = this.translogManager.readOperation(versionValue.getLocation());
                                    if (operation != null) {
                                        Translog.Index index = (Translog.Index)operation;
                                        TranslogLeafReader reader = new TranslogLeafReader(index);
                                        Engine.GetResult getResult = new Engine.GetResult(new Engine.Searcher("realtime_get", reader, IndexSearcher.getDefaultSimilarity(), null, IndexSearcher.getDefaultQueryCachingPolicy(), reader), new VersionsAndSeqNoResolver.DocIdAndVersion(0, index.version(), index.seqNo(), index.primaryTerm(), reader, 0), true);
                                        return getResult;
                                    }
                                    break block28;
                                }
                                catch (IOException e) {
                                    this.maybeFailEngine("realtime_get", e);
                                    throw new EngineException(this.shardId, "failed to read operation from translog", e, new Object[0]);
                                }
                            }
                            this.trackTranslogLocation.set(true);
                        }
                    }
                    assert (versionValue.seqNo >= 0L) : versionValue;
                    this.refreshIfNeeded("realtime_get", versionValue.seqNo);
                }
                scope = Engine.SearcherScope.INTERNAL;
            } else {
                scope = Engine.SearcherScope.EXTERNAL;
            }
            Engine.GetResult getResult = this.getFromSearcher(get, searcherFactory, scope);
            return getResult;
        }
    }

    private static OpVsLuceneDocStatus compareOpToVersionMapOnSeqNo(String id, long seqNo, long primaryTerm, VersionValue versionValue) {
        Objects.requireNonNull(versionValue);
        if (seqNo > versionValue.seqNo) {
            return OpVsLuceneDocStatus.OP_NEWER;
        }
        if (seqNo == versionValue.seqNo) {
            assert (versionValue.term == primaryTerm) : "primary term not matched; id=" + id + " seq_no=" + seqNo + " op_term=" + primaryTerm + " existing_term=" + versionValue.term;
            return OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
        }
        return OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
    }

    private OpVsLuceneDocStatus compareOpToLuceneDocBasedOnSeqNo(Engine.Operation op) throws IOException {
        OpVsLuceneDocStatus status;
        assert (op.seqNo() != -2L) : "resolving ops based on seq# but no seqNo is found";
        VersionValue versionValue = this.getVersionFromMap(op.uid().bytes());
        assert (this.incrementVersionLookup());
        boolean segRepEnabled = this.engineConfig.getIndexSettings().isSegRepEnabledOrRemoteNode();
        if (versionValue != null) {
            status = InternalEngine.compareOpToVersionMapOnSeqNo(op.id(), op.seqNo(), op.primaryTerm(), versionValue);
        } else {
            assert (this.incrementIndexVersionLookup());
            try (Engine.Searcher searcher = this.acquireSearcher("load_seq_no", Engine.SearcherScope.INTERNAL);){
                VersionsAndSeqNoResolver.DocIdAndSeqNo docAndSeqNo = VersionsAndSeqNoResolver.loadDocIdAndSeqNo(searcher.getIndexReader(), op.uid());
                if (docAndSeqNo == null) {
                    status = OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND;
                } else if (op.seqNo() > docAndSeqNo.seqNo) {
                    status = OpVsLuceneDocStatus.OP_NEWER;
                } else if (op.seqNo() == docAndSeqNo.seqNo) {
                    assert (this.localCheckpointTracker.hasProcessed(op.seqNo()) || segRepEnabled) : "local checkpoint tracker is not updated seq_no=" + op.seqNo() + " id=" + op.id();
                    status = OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
                } else {
                    status = OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
                }
            }
        }
        return status;
    }

    private VersionValue resolveDocVersion(Engine.Operation op, boolean loadSeqNo) throws IOException {
        assert (this.incrementVersionLookup());
        VersionValue versionValue = this.getVersionFromMap(op.uid().bytes());
        if (versionValue == null) {
            VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion;
            assert (this.incrementIndexVersionLookup());
            try (Engine.Searcher searcher = this.acquireSearcher("load_version", Engine.SearcherScope.INTERNAL);){
                docIdAndVersion = VersionsAndSeqNoResolver.loadDocIdAndVersion(searcher.getIndexReader(), op.uid(), loadSeqNo);
            }
            if (docIdAndVersion != null) {
                versionValue = new IndexVersionValue(null, docIdAndVersion.version, docIdAndVersion.seqNo, docIdAndVersion.primaryTerm);
            }
        } else if (this.engineConfig.isEnableGcDeletes() && versionValue.isDelete() && this.engineConfig.getThreadPool().relativeTimeInMillis() - ((DeleteVersionValue)versionValue).time > this.getGcDeletesInMillis()) {
            versionValue = null;
        }
        return versionValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionValue getVersionFromMap(BytesRef id) {
        if (this.versionMap.isUnsafe()) {
            LiveVersionMap liveVersionMap = this.versionMap;
            synchronized (liveVersionMap) {
                if (this.versionMap.isUnsafe()) {
                    this.refresh("unsafe_version_map", Engine.SearcherScope.INTERNAL, true);
                }
                this.versionMap.enforceSafeAccess();
            }
        }
        return this.versionMap.getUnderLock(id);
    }

    private boolean canOptimizeAddDocument(Engine.Index index) {
        if (index.getAutoGeneratedIdTimestamp() != -1L) {
            assert (index.getAutoGeneratedIdTimestamp() >= 0L) : "autoGeneratedIdTimestamp must be positive but was: " + index.getAutoGeneratedIdTimestamp();
            switch (index.origin()) {
                case PRIMARY: {
                    assert (this.assertPrimaryCanOptimizeAddDocument(index));
                    return true;
                }
                case PEER_RECOVERY: 
                case REPLICA: {
                    assert (index.version() == 1L && index.versionType() == null) : "version: " + index.version() + " type: " + String.valueOf(index.versionType());
                    return true;
                }
                case LOCAL_TRANSLOG_RECOVERY: 
                case LOCAL_RESET: {
                    assert (index.isRetry());
                    return true;
                }
            }
            throw new IllegalArgumentException("unknown origin " + String.valueOf((Object)index.origin()));
        }
        return false;
    }

    protected boolean assertPrimaryCanOptimizeAddDocument(Engine.Index index) {
        assert ((index.version() == -4L || index.version() == -3L) && index.versionType() == VersionType.INTERNAL) : "version: " + index.version() + " type: " + String.valueOf(index.versionType());
        return true;
    }

    private boolean assertIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        if (origin == Engine.Operation.Origin.PRIMARY) {
            assert (this.assertPrimaryIncomingSequenceNumber(origin, seqNo));
        } else assert (seqNo >= 0L) : "recovery or replica ops should have an assigned seq no.; origin: " + String.valueOf((Object)origin);
        return true;
    }

    protected boolean assertPrimaryIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        assert (seqNo == -2L) : "primary operations must never have an assigned sequence number but was [" + seqNo + "]";
        return true;
    }

    protected long generateSeqNoForOperationOnPrimary(Engine.Operation operation) {
        assert (operation.origin() == Engine.Operation.Origin.PRIMARY);
        assert (operation.seqNo() == -2L) : "ops should not have an assigned seq no. but was: " + operation.seqNo();
        return this.doGenerateSeqNoForOperation(operation);
    }

    protected void advanceMaxSeqNoOfUpdatesOrDeletesOnPrimary(long seqNo) {
        this.advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
    }

    long doGenerateSeqNoForOperation(Engine.Operation operation) {
        return this.localCheckpointTracker.generateSeqNo();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Engine.IndexResult index(Engine.Index index) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final IndexingStrategy planIndexingAsNonPrimary(Engine.Index index) throws IOException {
        IndexingStrategy plan;
        assert (this.assertNonPrimaryOrigin(index));
        if (this.canOptimizeAddDocument(index)) {
            this.mayHaveBeenIndexedBefore(index);
        }
        long maxSeqNoOfUpdatesOrDeletes = this.getMaxSeqNoOfUpdatesOrDeletes();
        if (this.hasBeenProcessedBefore(index)) {
            plan = IndexingStrategy.processButSkipLucene(false, index.version());
        } else if (maxSeqNoOfUpdatesOrDeletes <= this.localCheckpointTracker.getProcessedCheckpoint()) {
            assert (maxSeqNoOfUpdatesOrDeletes < index.seqNo()) : index.seqNo() + ">=" + maxSeqNoOfUpdatesOrDeletes;
            plan = IndexingStrategy.optimizedAppendOnly(index.version(), 0);
        } else {
            boolean segRepEnabled = this.engineConfig.getIndexSettings().isSegRepEnabledOrRemoteNode();
            this.versionMap.enforceSafeAccess();
            OpVsLuceneDocStatus opVsLucene = this.compareOpToLuceneDocBasedOnSeqNo(index);
            plan = opVsLucene == OpVsLuceneDocStatus.OP_STALE_OR_EQUAL ? (segRepEnabled ? IndexingStrategy.processButSkipLucene(false, index.version()) : IndexingStrategy.processAsStaleOp(index.version())) : IndexingStrategy.processNormally(opVsLucene == OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND, index.version(), 0);
        }
        return plan;
    }

    protected IndexingStrategy indexingStrategyForOperation(Engine.Index index) throws IOException {
        if (index.origin() == Engine.Operation.Origin.PRIMARY) {
            return this.planIndexingAsPrimary(index);
        }
        return this.planIndexingAsNonPrimary(index);
    }

    private IndexingStrategy planIndexingAsPrimary(Engine.Index index) throws IOException {
        IndexingStrategy plan;
        assert (index.origin() == Engine.Operation.Origin.PRIMARY) : "planing as primary but origin isn't. got " + String.valueOf((Object)index.origin());
        int reservingDocs = index.parsedDoc().docs().size();
        boolean canOptimizeAddDocument = this.canOptimizeAddDocument(index);
        if (canOptimizeAddDocument && !this.mayHaveBeenIndexedBefore(index)) {
            Exception reserveError = this.tryAcquireInFlightDocs(index, reservingDocs);
            plan = reserveError != null ? IndexingStrategy.failAsTooManyDocs(reserveError) : IndexingStrategy.optimizedAppendOnly(1L, reservingDocs);
        } else {
            boolean currentNotFoundOrDeleted;
            long currentVersion;
            this.versionMap.enforceSafeAccess();
            VersionValue versionValue = this.resolveDocVersion(index, index.getIfSeqNo() != -2L);
            if (versionValue == null) {
                currentVersion = -1L;
                currentNotFoundOrDeleted = true;
            } else {
                currentVersion = versionValue.version;
                currentNotFoundOrDeleted = versionValue.isDelete();
            }
            if (index.getIfSeqNo() != -2L && currentNotFoundOrDeleted) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm(), -2L, 0L);
                plan = IndexingStrategy.skipDueToVersionConflict(e, true, currentVersion);
            } else if (index.getIfSeqNo() != -2L && (versionValue.seqNo != index.getIfSeqNo() || versionValue.term != index.getIfPrimaryTerm())) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
                plan = IndexingStrategy.skipDueToVersionConflict(e, currentNotFoundOrDeleted, currentVersion);
            } else if (index.versionType().isVersionConflictForWrites(currentVersion, index.version(), currentNotFoundOrDeleted)) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index, currentVersion, currentNotFoundOrDeleted);
                plan = IndexingStrategy.skipDueToVersionConflict(e, currentNotFoundOrDeleted, currentVersion);
            } else {
                Exception reserveError = this.tryAcquireInFlightDocs(index, reservingDocs);
                plan = reserveError != null ? IndexingStrategy.failAsTooManyDocs(reserveError) : IndexingStrategy.processNormally(currentNotFoundOrDeleted, canOptimizeAddDocument ? 1L : index.versionType().updateVersion(currentVersion, index.version()), reservingDocs);
            }
        }
        return plan;
    }

    private Engine.IndexResult indexIntoLucene(Engine.Index index, IndexingStrategy plan) throws IOException {
        assert (index.seqNo() >= 0L) : "ops should have an assigned seq no.; origin: " + String.valueOf((Object)index.origin());
        assert (plan.versionForIndexing >= 0L) : "version must be set. got " + plan.versionForIndexing;
        assert (plan.indexIntoLucene || plan.addStaleOpToLucene);
        index.parsedDoc().updateSeqID(index.seqNo(), index.primaryTerm());
        index.parsedDoc().version().setLongValue(plan.versionForIndexing);
        try {
            if (plan.addStaleOpToLucene) {
                this.addStaleDocs(index.docs(), this.indexWriter);
            } else if (plan.useLuceneUpdateDocument) {
                assert (this.assertMaxSeqNoOfUpdatesIsAdvanced(index.uid(), index.seqNo(), true, true));
                this.updateDocs(index.uid(), index.docs(), this.indexWriter);
            } else {
                assert (this.assertDocDoesNotExist(index, !this.canOptimizeAddDocument(index)));
                this.addDocs(index.docs(), this.indexWriter);
            }
            return new Engine.IndexResult(plan.versionForIndexing, index.primaryTerm(), index.seqNo(), plan.currentNotFoundOrDeleted);
        }
        catch (Exception ex) {
            if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null && !this.treatDocumentFailureAsTragicError(index)) {
                return new Engine.IndexResult(ex, -3L, index.primaryTerm(), index.seqNo());
            }
            throw ex;
        }
    }

    private boolean treatDocumentFailureAsTragicError(Engine.Index index) {
        return index.origin() == Engine.Operation.Origin.REPLICA || index.origin() == Engine.Operation.Origin.PEER_RECOVERY || index.origin() == Engine.Operation.Origin.LOCAL_RESET;
    }

    private boolean mayHaveBeenIndexedBefore(Engine.Index index) {
        boolean mayHaveBeenIndexBefore;
        assert (this.canOptimizeAddDocument(index));
        if (index.isRetry()) {
            mayHaveBeenIndexBefore = true;
            this.updateAutoIdTimestamp(index.getAutoGeneratedIdTimestamp(), true);
            assert (this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp());
        } else {
            mayHaveBeenIndexBefore = this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp();
            this.updateAutoIdTimestamp(index.getAutoGeneratedIdTimestamp(), false);
        }
        return mayHaveBeenIndexBefore;
    }

    private void addDocs(List<ParseContext.Document> docs, IndexWriter indexWriter) throws IOException {
        if (docs.size() > 1) {
            indexWriter.addDocuments(docs);
        } else {
            indexWriter.addDocument(docs.get(0));
        }
        this.numDocAppends.inc(docs.size());
    }

    private void addStaleDocs(List<ParseContext.Document> docs, IndexWriter indexWriter) throws IOException {
        for (ParseContext.Document doc : docs) {
            doc.add(this.softDeletesField);
        }
        if (docs.size() > 1) {
            indexWriter.addDocuments(docs);
        } else {
            indexWriter.addDocument(docs.get(0));
        }
    }

    private boolean assertDocDoesNotExist(Engine.Index index, boolean allowDeleted) throws IOException {
        VersionValue versionValue = this.versionMap.getVersionForAssert(index.uid().bytes());
        if (versionValue != null) {
            if (!versionValue.isDelete() || !allowDeleted) {
                throw new AssertionError((Object)("doc [" + index.id() + "] exists in version map (version " + String.valueOf(versionValue) + ")"));
            }
        } else {
            try (Engine.Searcher searcher = this.acquireSearcher("assert doc doesn't exist", Engine.SearcherScope.INTERNAL);){
                searcher.setQueryCache(null);
                long docsWithId = searcher.count(new TermQuery(index.uid()));
                if (docsWithId > 0L) {
                    throw new AssertionError((Object)("doc [" + index.id() + "] exists [" + docsWithId + "] times in index"));
                }
            }
        }
        return true;
    }

    private void updateDocs(Term uid, List<ParseContext.Document> docs, IndexWriter indexWriter) throws IOException {
        if (docs.size() > 1) {
            indexWriter.softUpdateDocuments(uid, docs, this.softDeletesField);
        } else {
            indexWriter.softUpdateDocument(uid, docs.get(0), this.softDeletesField);
        }
        this.numDocUpdates.inc(docs.size());
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) throws IOException {
        Engine.DeleteResult deleteResult;
        this.versionMap.enforceSafeAccess();
        assert (Objects.equals(delete.uid().field(), "_id")) : delete.uid().field();
        assert (this.assertIncomingSequenceNumber(delete.origin(), delete.seqNo()));
        int reservedDocs = 0;
        try (ReleasableLock ignored = this.readLock.acquire();
             Releasable ignored2 = this.versionMap.acquireLock(delete.uid().bytes());){
            this.ensureOpen();
            this.lastWriteNanos = delete.startTime();
            DeletionStrategy plan = this.deletionStrategyForOperation(delete);
            reservedDocs = plan.reservedDocs;
            if (plan.earlyResultOnPreflightError.isPresent()) {
                assert (delete.origin() == Engine.Operation.Origin.PRIMARY) : delete.origin();
                deleteResult = plan.earlyResultOnPreflightError.get();
            } else {
                if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
                    delete = new Engine.Delete(delete.id(), delete.uid(), this.generateSeqNoForOperationOnPrimary(delete), delete.primaryTerm(), delete.version(), delete.versionType(), delete.origin(), delete.startTime(), delete.getIfSeqNo(), delete.getIfPrimaryTerm());
                    this.advanceMaxSeqNoOfUpdatesOrDeletesOnPrimary(delete.seqNo());
                } else {
                    this.markSeqNoAsSeen(delete.seqNo());
                }
                assert (delete.seqNo() >= 0L) : "ops should have an assigned seq no.; origin: " + String.valueOf((Object)delete.origin());
                if (plan.deleteFromLucene || plan.addStaleOpToLucene) {
                    deleteResult = this.deleteInLucene(delete, plan);
                    if (plan.deleteFromLucene) {
                        this.numDocDeletes.inc();
                        this.versionMap.putDeleteUnderLock(delete.uid().bytes(), new DeleteVersionValue(plan.versionOfDeletion, delete.seqNo(), delete.primaryTerm(), this.engineConfig.getThreadPool().relativeTimeInMillis()));
                    }
                } else {
                    deleteResult = new Engine.DeleteResult(plan.versionOfDeletion, delete.primaryTerm(), delete.seqNo(), !plan.currentlyDeleted);
                }
            }
            if (!delete.origin().isFromTranslog() && deleteResult.getResultType() == Engine.Result.Type.SUCCESS) {
                Translog.Location location = this.translogManager.add(new Translog.Delete(delete, deleteResult));
                deleteResult.setTranslogLocation(location);
            }
            this.localCheckpointTracker.markSeqNoAsProcessed(deleteResult.getSeqNo());
            if (deleteResult.getTranslogLocation() == null) {
                assert (delete.origin().isFromTranslog() || deleteResult.getSeqNo() == -2L);
                this.localCheckpointTracker.markSeqNoAsPersisted(deleteResult.getSeqNo());
            }
            deleteResult.setTook(System.nanoTime() - delete.startTime());
            deleteResult.freeze();
        }
        catch (IOException | RuntimeException e) {
            try {
                this.maybeFailEngine("delete", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            this.releaseInFlightDocs(reservedDocs);
        }
        this.maybePruneDeletes();
        return deleteResult;
    }

    private Exception tryAcquireInFlightDocs(Engine.Operation operation, int addingDocs) {
        assert (operation.origin() == Engine.Operation.Origin.PRIMARY) : operation;
        assert (operation.seqNo() == -2L) : operation;
        assert (addingDocs > 0) : addingDocs;
        long totalDocs = this.indexWriter.getPendingNumDocs() + this.inFlightDocCount.addAndGet(addingDocs);
        if (totalDocs > (long)this.maxDocs) {
            this.releaseInFlightDocs(addingDocs);
            return new IllegalArgumentException("Number of documents in shard " + String.valueOf(this.shardId) + " exceeds the limit of [" + this.maxDocs + "] documents per shard");
        }
        return null;
    }

    private void releaseInFlightDocs(int numDocs) {
        assert (numDocs >= 0) : numDocs;
        long newValue = this.inFlightDocCount.addAndGet(-numDocs);
        assert (newValue >= 0L) : "inFlightDocCount must not be negative [" + newValue + "]";
    }

    long getInFlightDocCount() {
        return this.inFlightDocCount.get();
    }

    protected DeletionStrategy deletionStrategyForOperation(Engine.Delete delete) throws IOException {
        if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
            return this.planDeletionAsPrimary(delete);
        }
        return this.planDeletionAsNonPrimary(delete);
    }

    protected final DeletionStrategy planDeletionAsNonPrimary(Engine.Delete delete) throws IOException {
        DeletionStrategy plan;
        assert (this.assertNonPrimaryOrigin(delete));
        if (this.hasBeenProcessedBefore(delete)) {
            plan = DeletionStrategy.processButSkipLucene(false, delete.version());
        } else {
            boolean segRepEnabled = this.engineConfig.getIndexSettings().isSegRepEnabledOrRemoteNode();
            OpVsLuceneDocStatus opVsLucene = this.compareOpToLuceneDocBasedOnSeqNo(delete);
            plan = opVsLucene == OpVsLuceneDocStatus.OP_STALE_OR_EQUAL ? (segRepEnabled ? DeletionStrategy.processButSkipLucene(false, delete.version()) : DeletionStrategy.processAsStaleOp(delete.version())) : DeletionStrategy.processNormally(opVsLucene == OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND, delete.version(), 0);
        }
        return plan;
    }

    protected boolean assertNonPrimaryOrigin(Engine.Operation operation) {
        assert (operation.origin() != Engine.Operation.Origin.PRIMARY) : "planing as primary but got " + String.valueOf((Object)operation.origin());
        return true;
    }

    private DeletionStrategy planDeletionAsPrimary(Engine.Delete delete) throws IOException {
        DeletionStrategy plan;
        boolean currentlyDeleted;
        long currentVersion;
        assert (delete.origin() == Engine.Operation.Origin.PRIMARY) : "planing as primary but got " + String.valueOf((Object)delete.origin());
        VersionValue versionValue = this.resolveDocVersion(delete, delete.getIfSeqNo() != -2L);
        assert (this.incrementVersionLookup());
        if (versionValue == null) {
            currentVersion = -1L;
            currentlyDeleted = true;
        } else {
            currentVersion = versionValue.version;
            currentlyDeleted = versionValue.isDelete();
        }
        if (delete.getIfSeqNo() != -2L && currentlyDeleted) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete.id(), delete.getIfSeqNo(), delete.getIfPrimaryTerm(), -2L, 0L);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, true);
        } else if (delete.getIfSeqNo() != -2L && (versionValue.seqNo != delete.getIfSeqNo() || versionValue.term != delete.getIfPrimaryTerm())) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete.id(), delete.getIfSeqNo(), delete.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, currentlyDeleted);
        } else if (delete.versionType().isVersionConflictForWrites(currentVersion, delete.version(), currentlyDeleted)) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete, currentVersion, currentlyDeleted);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, currentlyDeleted);
        } else {
            Exception reserveError = this.tryAcquireInFlightDocs(delete, 1);
            if (reserveError != null) {
                plan = DeletionStrategy.failAsTooManyDocs(reserveError);
            } else {
                long versionOfDeletion = delete.versionType().updateVersion(currentVersion, delete.version());
                plan = DeletionStrategy.processNormally(currentlyDeleted, versionOfDeletion, 1);
            }
        }
        return plan;
    }

    private Engine.DeleteResult deleteInLucene(Engine.Delete delete, DeletionStrategy plan) throws IOException {
        assert (this.assertMaxSeqNoOfUpdatesIsAdvanced(delete.uid(), delete.seqNo(), false, false));
        try {
            ParsedDocument tombstone = this.engineConfig.getTombstoneDocSupplier().newDeleteTombstoneDoc(delete.id());
            assert (tombstone.docs().size() == 1) : "Tombstone doc should have single doc [" + String.valueOf(tombstone) + "]";
            tombstone.updateSeqID(delete.seqNo(), delete.primaryTerm());
            tombstone.version().setLongValue(plan.versionOfDeletion);
            ParseContext.Document doc = tombstone.docs().get(0);
            assert (doc.getField("_tombstone") != null) : "Delete tombstone document but _tombstone field is not set [" + String.valueOf(doc) + " ]";
            doc.add(this.softDeletesField);
            if (plan.addStaleOpToLucene || plan.currentlyDeleted) {
                this.indexWriter.addDocument(doc);
            } else {
                this.indexWriter.softUpdateDocument(delete.uid(), doc, this.softDeletesField);
            }
            return new Engine.DeleteResult(plan.versionOfDeletion, delete.primaryTerm(), delete.seqNo(), !plan.currentlyDeleted);
        }
        catch (Exception ex) {
            if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null) {
                String reason = String.format(Locale.ROOT, "delete id[%s] origin [%s] seq#[%d] failed at the document level", new Object[]{delete.id(), delete.origin(), delete.seqNo()});
                this.failEngine(reason, ex);
            }
            throw ex;
        }
    }

    @Override
    public void maybePruneDeletes() {
        if (this.engineConfig.isEnableGcDeletes() && (double)(this.engineConfig.getThreadPool().relativeTimeInMillis() - this.lastDeleteVersionPruneTimeMSec) > (double)this.getGcDeletesInMillis() * 0.25) {
            this.pruneDeletedTombstones();
        }
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) throws IOException {
        Engine.NoOpResult noOpResult;
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            noOpResult = this.innerNoOp(noOp);
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("noop", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        return noOpResult;
    }

    private Engine.NoOpResult innerNoOp(Engine.NoOp noOp) throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        assert (noOp.seqNo() > -1L);
        long seqNo = noOp.seqNo();
        try (Releasable ignored = this.noOpKeyedLock.acquire(seqNo);){
            Engine.NoOpResult noOpResult;
            Optional<Exception> preFlightError = this.preFlightCheckForNoOp(noOp);
            if (preFlightError.isPresent()) {
                noOpResult = new Engine.NoOpResult(0L, -2L, preFlightError.get());
            } else {
                this.markSeqNoAsSeen(noOp.seqNo());
                if (!this.hasBeenProcessedBefore(noOp)) {
                    try {
                        ParsedDocument tombstone = this.engineConfig.getTombstoneDocSupplier().newNoopTombstoneDoc(noOp.reason());
                        tombstone.updateSeqID(noOp.seqNo(), noOp.primaryTerm());
                        tombstone.version().setLongValue(1L);
                        assert (tombstone.docs().size() == 1) : "Tombstone should have a single doc [" + String.valueOf(tombstone) + "]";
                        ParseContext.Document doc = tombstone.docs().get(0);
                        assert (doc.getField("_tombstone") != null) : "Noop tombstone document but _tombstone field is not set [" + String.valueOf(doc) + " ]";
                        doc.add(this.softDeletesField);
                        this.indexWriter.addDocument(doc);
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null) {
                            this.failEngine("no-op origin[" + String.valueOf((Object)noOp.origin()) + "] seq#[" + noOp.seqNo() + "] failed at document level", ex);
                        }
                        throw ex;
                    }
                }
                noOpResult = new Engine.NoOpResult(noOp.primaryTerm(), noOp.seqNo());
                if (!noOp.origin().isFromTranslog() && noOpResult.getResultType() == Engine.Result.Type.SUCCESS) {
                    Translog.Location location = this.translogManager.add(new Translog.NoOp(noOp.seqNo(), noOp.primaryTerm(), noOp.reason()));
                    noOpResult.setTranslogLocation(location);
                }
            }
            this.localCheckpointTracker.markSeqNoAsProcessed(noOpResult.getSeqNo());
            if (noOpResult.getTranslogLocation() == null) {
                assert (noOp.origin().isFromTranslog() || noOpResult.getSeqNo() == -2L);
                this.localCheckpointTracker.markSeqNoAsPersisted(noOpResult.getSeqNo());
            }
            noOpResult.setTook(System.nanoTime() - noOp.startTime());
            noOpResult.freeze();
            Engine.NoOpResult noOpResult2 = noOpResult;
            return noOpResult2;
        }
    }

    protected Optional<Exception> preFlightCheckForNoOp(Engine.NoOp noOp) throws IOException {
        return Optional.empty();
    }

    @Override
    public void refresh(String source) throws EngineException {
        this.refresh(source, Engine.SearcherScope.EXTERNAL, true);
    }

    @Override
    public boolean maybeRefresh(String source) throws EngineException {
        return this.refresh(source, Engine.SearcherScope.EXTERNAL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean refresh(String source, Engine.SearcherScope scope, boolean block) throws EngineException {
        boolean refreshed;
        long localCheckpointBeforeRefresh;
        block14: {
            localCheckpointBeforeRefresh = this.localCheckpointTracker.getProcessedCheckpoint();
            try {
                if (this.store.tryIncRef()) {
                    try {
                        ReferenceManager<OpenSearchDirectoryReader> referenceManager = this.getReferenceManager(scope);
                        if (block) {
                            referenceManager.maybeRefreshBlocking();
                            refreshed = true;
                        } else {
                            refreshed = referenceManager.maybeRefresh();
                        }
                    }
                    finally {
                        this.store.decRef();
                    }
                    if (refreshed) {
                        this.lastRefreshedCheckpointListener.updateRefreshedCheckpoint(localCheckpointBeforeRefresh);
                    }
                    break block14;
                }
                refreshed = false;
            }
            catch (AlreadyClosedException e) {
                this.failOnTragicEvent(e);
                throw e;
            }
            catch (Exception e) {
                try {
                    this.failEngine("refresh failed source[" + source + "]", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
            }
        }
        assert (!refreshed || this.lastRefreshedCheckpoint() >= localCheckpointBeforeRefresh) : "refresh checkpoint was not advanced; local_checkpoint=" + localCheckpointBeforeRefresh + " refresh_checkpoint=" + this.lastRefreshedCheckpoint();
        this.maybePruneDeletes();
        this.mergeScheduler.refreshConfig();
        return refreshed;
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
        this.refresh("write indexing buffer", Engine.SearcherScope.INTERNAL, false);
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        this.ensureOpen();
        if (this.shouldPeriodicallyFlushAfterBigMerge.get()) {
            return true;
        }
        long localCheckpointOfLastCommit = Long.parseLong(this.lastCommittedSegmentInfos.userData.get("local_checkpoint"));
        return this.translogManager.shouldPeriodicallyFlush(localCheckpointOfLastCommit, this.config().getIndexSettings().getFlushThresholdSize().getBytes());
    }

    @Override
    public void flush(boolean force, boolean waitIfOngoing) throws EngineException {
        block22: {
            this.ensureOpen();
            if (force && !waitIfOngoing) {
                assert (false) : "wait_if_ongoing must be true for a force flush: force=" + force + " wait_if_ongoing=" + waitIfOngoing;
                throw new IllegalArgumentException("wait_if_ongoing must be true for a force flush: force=" + force + " wait_if_ongoing=" + waitIfOngoing);
            }
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                if (!this.flushLock.tryLock()) {
                    if (!waitIfOngoing) {
                        return;
                    }
                    this.logger.trace("waiting for in-flight flush to finish");
                    this.flushLock.lock();
                    this.logger.trace("acquired flush lock after blocking");
                } else {
                    this.logger.trace("acquired flush lock immediately");
                }
                try {
                    boolean hasUncommittedChanges = this.indexWriter.hasUncommittedChanges();
                    boolean shouldPeriodicallyFlush = this.shouldPeriodicallyFlush();
                    if (!hasUncommittedChanges && !force && !shouldPeriodicallyFlush && this.getProcessedLocalCheckpoint() <= Long.parseLong(this.lastCommittedSegmentInfos.userData.get("local_checkpoint"))) break block22;
                    this.translogManager.ensureCanFlush();
                    try {
                        this.translogManager.rollTranslogGeneration();
                        this.logger.trace("starting commit for flush; commitTranslog=true");
                        GatedCloseable<IndexCommit> latestCommit = this.engineConfig.getIndexSettings().isSegRepEnabledOrRemoteNode() ? this.acquireLastIndexCommit(false) : null;
                        this.commitIndexWriter(this.indexWriter, this.translogManager.getTranslog());
                        this.logger.trace("finished commit for flush");
                        this.logger.debug("new commit on flush, hasUncommittedChanges:{}, force:{}, shouldPeriodicallyFlush:{}", (Object)hasUncommittedChanges, (Object)force, (Object)shouldPeriodicallyFlush);
                        this.refresh("version_table_flush", Engine.SearcherScope.INTERNAL, true);
                        if (latestCommit != null) {
                            latestCommit.close();
                        }
                        this.translogManager.trimUnreferencedReaders();
                    }
                    catch (AlreadyClosedException e) {
                        this.failOnTragicEvent(e);
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    this.refreshLastCommittedSegmentInfos();
                }
                catch (FlushFailedEngineException ex) {
                    this.maybeFailEngine("flush", ex);
                    throw ex;
                }
                finally {
                    this.flushLock.unlock();
                }
            }
        }
        if (this.engineConfig.isEnableGcDeletes()) {
            this.pruneDeletedTombstones();
        }
    }

    private void refreshLastCommittedSegmentInfos() {
        block8: {
            this.store.incRef();
            try {
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            }
            catch (Exception e) {
                if (this.isClosed.get()) break block8;
                try {
                    this.logger.warn("failed to read latest segment infos on flush", (Throwable)e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                if (Lucene.isCorruptionException(e)) {
                    throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                }
            }
            finally {
                this.store.decRef();
            }
        }
    }

    @Override
    public void rollTranslogGeneration() throws EngineException, IOException {
        this.translogManager().rollTranslogGeneration();
    }

    @Override
    public void trimUnreferencedTranslogFiles() throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.translogManager().getTranslog().trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to trim translog", e, new Object[0]);
        }
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return this.translogManager().getTranslog().shouldRollGeneration();
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.translogManager().getTranslog().trimOperations(belowTerm, aboveSeqNo);
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog operations trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to trim translog operations", e, new Object[0]);
        }
    }

    private void pruneDeletedTombstones() {
        long timeMSec = this.engineConfig.getThreadPool().relativeTimeInMillis();
        long maxTimestampToPrune = timeMSec - this.engineConfig.getIndexSettings().getGcDeletesInMillis();
        this.versionMap.pruneTombstones(maxTimestampToPrune, this.localCheckpointTracker.getProcessedCheckpoint());
        this.lastDeleteVersionPruneTimeMSec = timeMSec;
    }

    void clearDeletedTombstones() {
        this.versionMap.pruneTombstones(Long.MAX_VALUE, this.localCheckpointTracker.getMaxSeqNo());
    }

    final Map<BytesRef, VersionValue> getVersionMap() {
        return Stream.concat(this.versionMap.getAllCurrent().entrySet().stream(), this.versionMap.getAllTombstones().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments, String forceMergeUUID) throws EngineException, IOException {
        assert (this.indexWriter.getConfig().getMergePolicy() instanceof OpenSearchMergePolicy) : "MergePolicy is " + this.indexWriter.getConfig().getMergePolicy().getClass().getName();
        OpenSearchMergePolicy mp = (OpenSearchMergePolicy)this.indexWriter.getConfig().getMergePolicy();
        this.optimizeLock.lock();
        try {
            this.ensureOpen();
            if (upgrade) {
                this.logger.info("starting segment upgrade upgradeOnlyAncientSegments={}", (Object)upgradeOnlyAncientSegments);
                mp.setUpgradeInProgress(true, upgradeOnlyAncientSegments);
            }
            this.store.incRef();
            try {
                if (onlyExpungeDeletes) {
                    assert (!upgrade);
                    this.indexWriter.forceMergeDeletes(true);
                } else if (maxNumSegments <= 0) {
                    assert (!upgrade);
                    this.indexWriter.maybeMerge();
                } else {
                    this.indexWriter.forceMerge(maxNumSegments, true);
                    this.forceMergeUUID = forceMergeUUID;
                }
                if (flush) {
                    this.flush(false, true);
                }
                if (upgrade) {
                    this.logger.info("finished segment upgrade");
                }
            }
            finally {
                this.store.decRef();
            }
        }
        catch (AlreadyClosedException ex) {
            this.ensureOpen(ex);
            this.failOnTragicEvent(ex);
            throw ex;
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("force merge", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            try {
                mp.setUpgradeInProgress(false, false);
            }
            finally {
                this.optimizeLock.unlock();
            }
        }
    }

    @Override
    public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        if (flushFirst) {
            this.logger.trace("start flush for snapshot");
            this.flush(false, true);
            this.logger.trace("finish flush for snapshot");
        }
        IndexCommit lastCommit = this.combinedDeletionPolicy.acquireIndexCommit(false);
        return new GatedCloseable<IndexCommit>(lastCommit, () -> this.releaseIndexCommit(lastCommit));
    }

    @Override
    public GatedCloseable<IndexCommit> acquireSafeIndexCommit() throws EngineException {
        IndexCommit safeCommit = this.combinedDeletionPolicy.acquireIndexCommit(true);
        return new GatedCloseable<IndexCommit>(safeCommit, () -> this.releaseIndexCommit(safeCommit));
    }

    private void releaseIndexCommit(IndexCommit snapshot) throws IOException {
        if (this.combinedDeletionPolicy.releaseCommit(snapshot)) {
            try {
                this.indexWriter.deleteUnusedFiles();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return this.combinedDeletionPolicy.getSafeCommitInfo();
    }

    private boolean failOnTragicEvent(AlreadyClosedException ex) {
        boolean engineFailed;
        if (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() != null) {
            Exception tragicException = this.indexWriter.getTragicException() instanceof Exception ? (Exception)this.indexWriter.getTragicException() : new RuntimeException(this.indexWriter.getTragicException());
            this.failEngine("already closed by tragic event on the index writer", tragicException);
            engineFailed = true;
        } else if (this.translogManager.getTragicExceptionIfClosed() != null) {
            this.failEngine("already closed by tragic event on the translog", this.translogManager.getTragicExceptionIfClosed());
            engineFailed = true;
        } else {
            if (this.failedEngine.get() == null && !this.isClosed.get()) {
                throw new AssertionError("Unexpected AlreadyClosedException", ex);
            }
            engineFailed = false;
        }
        return engineFailed;
    }

    @Override
    protected boolean maybeFailEngine(String source, Exception e) {
        boolean shouldFail = super.maybeFailEngine(source, e);
        if (shouldFail) {
            return true;
        }
        if (e instanceof AlreadyClosedException) {
            return this.failOnTragicEvent((AlreadyClosedException)e);
        }
        if (e != null && (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() == e || this.translogManager.getTragicExceptionIfClosed() == e)) {
            this.failEngine(source, e);
            return true;
        }
        return false;
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected SegmentInfos getLatestSegmentInfos() {
        SegmentInfos segmentInfos;
        block8: {
            GatedCloseable<SegmentInfos> snapshot = this.getSegmentInfosSnapshot();
            try {
                segmentInfos = snapshot.get();
                if (snapshot == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (snapshot != null) {
                        try {
                            snapshot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EngineException(this.shardId, e.getMessage(), e, new Object[0]);
                }
            }
            snapshot.close();
        }
        return segmentInfos;
    }

    @Override
    public GatedCloseable<SegmentInfos> getSegmentInfosSnapshot() {
        try {
            OpenSearchDirectoryReader reader = (OpenSearchDirectoryReader)this.internalReaderManager.acquire();
            return new GatedCloseable<SegmentInfos>(((StandardDirectoryReader)reader.getDelegate()).getSegmentInfos(), () -> {
                try {
                    this.internalReaderManager.release(reader);
                }
                catch (AlreadyClosedException e) {
                    this.logger.warn("Engine is already closed.", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            throw new EngineException(this.shardId, e.getMessage(), e, new Object[0]);
        }
    }

    @Override
    protected final void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(this.versionMap.ramBytesUsed());
        stats.addIndexWriterMemoryInBytes(this.indexWriter.ramBytesUsed());
        stats.updateMaxUnsafeAutoIdTimestamp(this.maxUnsafeAutoIdTimestamp.get());
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return this.indexWriter.ramBytesUsed() + this.versionMap.ramBytesUsedForRefresh();
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        try (ReleasableLock lock = this.readLock.acquire();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose);
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block6: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment : segmentsArr) {
                        if (!segment.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment.mergeId = onGoingMerge.getId();
                        continue block6;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                this.versionMap.clear();
                if (this.internalReaderManager != null) {
                    this.internalReaderManager.removeListener(this.versionMap);
                }
                try {
                    IOUtils.close(this.externalReaderManager, this.internalReaderManager);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close ReaderManager", (Throwable)e);
                }
                try {
                    IOUtils.close((Closeable)this.translogManager);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close translog", (Throwable)e);
                }
                this.logger.trace("rollback indexWriter");
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException ex) {
                    this.failOnTragicEvent(ex);
                    throw ex;
                }
                this.logger.trace("rollback indexWriter done");
            }
            catch (Exception e) {
                this.logger.warn("failed to rollback writer on close", (Throwable)e);
            }
            finally {
                try {
                    this.store.decRef();
                    this.logger.debug("engine closed [{}]", (Object)reason);
                }
                finally {
                    closedLatch.countDown();
                }
            }
        }
    }

    @Override
    protected final ReferenceManager<OpenSearchDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        switch (scope) {
            case INTERNAL: {
                return this.internalReaderManager;
            }
            case EXTERNAL: {
                return this.externalReaderManager;
            }
        }
        throw new IllegalStateException("unknown scope: " + String.valueOf((Object)scope));
    }

    private IndexWriter createWriter() throws IOException {
        try {
            IndexWriterConfig iwc = this.getIndexWriterConfig();
            return this.createWriter(this.store.directory(), iwc);
        }
        catch (LockObtainFailedException ex) {
            this.logger.warn("could not lock IndexWriter", (Throwable)ex);
            throw ex;
        }
    }

    IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
        if (Assertions.ENABLED) {
            return new AssertingIndexWriter(directory, iwc);
        }
        return new IndexWriter(directory, iwc);
    }

    private IndexWriterConfig getIndexWriterConfig() {
        IndexWriterConfig iwc = new IndexWriterConfig(this.engineConfig.getAnalyzer());
        iwc.setCommitOnClose(false);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        iwc.setIndexDeletionPolicy(this.combinedDeletionPolicy);
        boolean verbose = false;
        try {
            verbose = Boolean.parseBoolean(System.getProperty("tests.verbose"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        iwc.setInfoStream(verbose ? InfoStream.getDefault() : new LoggerInfoStream(this.logger));
        iwc.setMergeScheduler(this.mergeScheduler);
        MergePolicy mergePolicy = this.config().getMergePolicy();
        iwc.setSoftDeletesField("__soft_deletes");
        mergePolicy = new RecoverySourcePruneMergePolicy("_recovery_source", this.softDeletesPolicy::getRetentionQuery, new SoftDeletesRetentionMergePolicy("__soft_deletes", this.softDeletesPolicy::getRetentionQuery, new PrunePostingsMergePolicy(mergePolicy, "_id")));
        boolean shuffleForcedMerge = Booleans.parseBoolean(System.getProperty("opensearch.shuffle_forced_merge", Boolean.TRUE.toString()));
        if (shuffleForcedMerge) {
            mergePolicy = new ShuffleForcedMergePolicy(mergePolicy);
        }
        if (this.config().getIndexSettings().isMergeOnFlushEnabled()) {
            long maxFullFlushMergeWaitMillis = this.config().getIndexSettings().getMaxFullFlushMergeWaitTime().millis();
            if (maxFullFlushMergeWaitMillis > 0L) {
                iwc.setMaxFullFlushMergeWaitMillis(maxFullFlushMergeWaitMillis);
                Optional<UnaryOperator<MergePolicy>> mergeOnFlushPolicy = this.config().getIndexSettings().getMergeOnFlushPolicy();
                if (mergeOnFlushPolicy.isPresent()) {
                    mergePolicy = (MergePolicy)mergeOnFlushPolicy.get().apply(mergePolicy);
                }
            }
        } else {
            iwc.setMaxFullFlushMergeWaitMillis(0L);
        }
        iwc.setCheckPendingFlushUpdate(this.config().getIndexSettings().isCheckPendingFlushEnabled());
        iwc.setMergePolicy(new OpenSearchMergePolicy(mergePolicy));
        iwc.setSimilarity(this.engineConfig.getSimilarity());
        iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().getMbFrac());
        iwc.setCodec(this.engineConfig.getCodec());
        iwc.setUseCompoundFile(this.engineConfig.useCompoundFile());
        if (this.config().getIndexSort() != null) {
            iwc.setIndexSort(this.config().getIndexSort());
        }
        if (this.config().getLeafSorter() != null) {
            iwc.setLeafSorter(this.config().getLeafSorter());
        }
        return iwc;
    }

    @Override
    public void activateThrottling() {
        int count = this.throttleRequestCount.incrementAndGet();
        assert (count >= 1) : "invalid post-increment throttleRequestCount=" + count;
        if (count == 1) {
            this.throttle.activate();
        }
    }

    @Override
    public void deactivateThrottling() {
        int count = this.throttleRequestCount.decrementAndGet();
        assert (count >= 0) : "invalid post-decrement throttleRequestCount=" + count;
        if (count == 0) {
            this.throttle.deactivate();
        }
    }

    @Override
    public boolean isThrottled() {
        return this.throttle.isThrottled();
    }

    boolean throttleLockIsHeldByCurrentThread() {
        return this.throttle.throttleLockIsHeldByCurrentThread();
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return this.throttle.getThrottleTimeInMillis();
    }

    long getGcDeletesInMillis() {
        return this.engineConfig.getIndexSettings().getGcDeletesInMillis();
    }

    LiveIndexWriterConfig getCurrentIndexWriterConfig() {
        return this.indexWriter.getConfig();
    }

    protected void commitIndexWriter(IndexWriter writer, Translog translog) throws IOException {
        this.translogManager.ensureCanFlush();
        try {
            long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
            writer.setLiveCommitData(() -> {
                HashMap<String, String> commitData = new HashMap<String, String>(7);
                commitData.put("translog_uuid", translog.getTranslogUUID());
                commitData.put("local_checkpoint", Long.toString(localCheckpoint));
                commitData.put("max_seq_no", Long.toString(this.localCheckpointTracker.getMaxSeqNo()));
                commitData.put("max_unsafe_auto_id_timestamp", Long.toString(this.maxUnsafeAutoIdTimestamp.get()));
                commitData.put("history_uuid", this.historyUUID);
                commitData.put("min_retained_seq_no", Long.toString(this.softDeletesPolicy.getMinRetainedSeqNo()));
                String currentForceMergeUUID = this.forceMergeUUID;
                if (currentForceMergeUUID != null) {
                    commitData.put("force_merge_uuid", currentForceMergeUUID);
                }
                this.logger.trace("committing writer with commit data [{}]", commitData);
                return commitData.entrySet().iterator();
            });
            this.shouldPeriodicallyFlushAfterBigMerge.set(false);
            writer.commit();
        }
        catch (Exception ex) {
            try {
                this.failEngine("lucene commit failed", ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
        catch (AssertionError e) {
            if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriter.filesExist")) {
                EngineException engineException = new EngineException(this.shardId, "failed to commit engine", (Throwable)((Object)e), new Object[0]);
                try {
                    this.failEngine("lucene commit failed", engineException);
                }
                catch (Exception inner) {
                    engineException.addSuppressed(inner);
                }
                throw engineException;
            }
            throw e;
        }
    }

    @Override
    public void onSettingsChanged(TimeValue translogRetentionAge, ByteSizeValue translogRetentionSize, long softDeletesRetentionOps) {
        this.mergeScheduler.refreshConfig();
        this.maybePruneDeletes();
        if (!this.engineConfig.isAutoGeneratedIDsOptimizationEnabled()) {
            this.updateAutoIdTimestamp(Long.MAX_VALUE, true);
        }
        TranslogDeletionPolicy translogDeletionPolicy = this.translogManager.getDeletionPolicy();
        translogDeletionPolicy.setRetentionAgeInMillis(translogRetentionAge.millis());
        translogDeletionPolicy.setRetentionSizeInBytes(translogRetentionSize.getBytes());
        this.softDeletesPolicy.setRetentionOperations(softDeletesRetentionOps);
    }

    @Override
    public MergeStats getMergeStats() {
        return this.mergeScheduler.stats();
    }

    LocalCheckpointTracker getLocalCheckpointTracker() {
        return this.localCheckpointTracker;
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.translogManager.getLastSyncedGlobalCheckpoint();
    }

    public long getProcessedLocalCheckpoint() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.localCheckpointTracker.getPersistedCheckpoint();
    }

    protected final void markSeqNoAsSeen(long seqNo) {
        this.localCheckpointTracker.advanceMaxSeqNo(seqNo);
    }

    protected final boolean hasBeenProcessedBefore(Engine.Operation op) {
        if (Assertions.ENABLED) {
            assert (op.seqNo() != -2L) : "operation is not assigned seq_no";
            if (op.operationType() == Engine.Operation.TYPE.NO_OP ? !$assertionsDisabled && !this.noOpKeyedLock.isHeldByCurrentThread(op.seqNo()) : !$assertionsDisabled && !this.versionMap.assertKeyedLockHeldByCurrentThread(op.uid().bytes())) {
                throw new AssertionError();
            }
        }
        return this.localCheckpointTracker.hasProcessed(op.seqNo());
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return this.localCheckpointTracker.getStats(globalCheckpoint);
    }

    long getNumIndexVersionsLookups() {
        return this.numIndexVersionsLookups.count();
    }

    long getNumVersionLookups() {
        return this.numVersionLookups.count();
    }

    private boolean incrementVersionLookup() {
        this.numVersionLookups.inc();
        return true;
    }

    private boolean incrementIndexVersionLookup() {
        this.numIndexVersionsLookups.inc();
        return true;
    }

    boolean isSafeAccessRequired() {
        return this.versionMap.isSafeAccessRequired();
    }

    long getNumDocDeletes() {
        return this.numDocDeletes.count();
    }

    long getNumDocAppends() {
        return this.numDocAppends.count();
    }

    long getNumDocUpdates() {
        return this.numDocUpdates.count();
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accurateCount) throws IOException {
        this.ensureOpen();
        this.refreshIfNeeded(source, toSeqNo);
        Engine.Searcher searcher = this.acquireSearcher(source, Engine.SearcherScope.INTERNAL);
        try {
            LuceneChangesSnapshot snapshot = new LuceneChangesSnapshot(searcher, 1024, fromSeqNo, toSeqNo, requiredFullRange, accurateCount);
            searcher = null;
            LuceneChangesSnapshot luceneChangesSnapshot = snapshot;
            return luceneChangesSnapshot;
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("acquire changes snapshot", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            IOUtils.close((Closeable)searcher);
        }
    }

    @Override
    @Deprecated
    public Translog.Snapshot newChangesSnapshotFromTranslogFile(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        return this.translogManager().getTranslog().newSnapshot(fromSeqNo, toSeqNo, requiredFullRange);
    }

    @Override
    public int countNumberOfHistoryOperations(String source, long fromSeqNo, long toSeqNo) throws IOException {
        this.ensureOpen();
        this.refreshIfNeeded(source, toSeqNo);
        Engine.Searcher s = this.acquireSearcher(source, Engine.SearcherScope.INTERNAL);
        try {
            int n = LuceneChangesSnapshot.countNumberOfHistoryOperations(s, fromSeqNo, toSeqNo);
            if (s != null) {
                s.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                try {
                    this.maybeFailEngine(source, e);
                }
                catch (Exception innerException) {
                    e.addSuppressed(innerException);
                }
                throw e;
            }
        }
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, long startingSeqNo) {
        return this.getMinRetainedSeqNo() <= startingSeqNo;
    }

    @Override
    public final long getMinRetainedSeqNo() {
        return this.softDeletesPolicy.getMinRetainedSeqNo();
    }

    @Override
    public Closeable acquireHistoryRetentionLock() {
        return this.softDeletesPolicy.acquireRetentionLock();
    }

    private static Map<String, String> commitDataAsMap(IndexWriter indexWriter) {
        HashMap<String, String> commitData = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : indexWriter.getLiveCommitData()) {
            commitData.put(entry.getKey(), entry.getValue());
        }
        return commitData;
    }

    public final long lastRefreshedCheckpoint() {
        return this.lastRefreshedCheckpointListener.refreshedCheckpoint.get();
    }

    public final long currentOngoingRefreshCheckpoint() {
        return this.lastRefreshedCheckpointListener.pendingCheckpoint.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshIfNeeded(String source, long requestingSeqNo) {
        if (this.lastRefreshedCheckpoint() < requestingSeqNo) {
            Object object = this.refreshIfNeededMutex;
            synchronized (object) {
                if (this.lastRefreshedCheckpoint() < requestingSeqNo) {
                    this.refresh(source, Engine.SearcherScope.INTERNAL, true);
                }
            }
        }
    }

    @Override
    public final long getMaxSeenAutoIdTimestamp() {
        return this.maxSeenAutoIdTimestamp.get();
    }

    @Override
    public final void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
        this.updateAutoIdTimestamp(newTimestamp, true);
    }

    private void updateAutoIdTimestamp(long newTimestamp, boolean unsafe) {
        assert (newTimestamp >= -1L) : "invalid timestamp [" + newTimestamp + "]";
        this.maxSeenAutoIdTimestamp.updateAndGet(curr -> Math.max(curr, newTimestamp));
        if (unsafe) {
            this.maxUnsafeAutoIdTimestamp.updateAndGet(curr -> Math.max(curr, newTimestamp));
        }
        assert (this.maxUnsafeAutoIdTimestamp.get() <= this.maxSeenAutoIdTimestamp.get());
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.maxSeqNoOfUpdatesOrDeletes.get();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
        if (maxSeqNoOfUpdatesOnPrimary == -2L) {
            assert (false) : "max_seq_no_of_updates on primary is unassigned";
            throw new IllegalArgumentException("max_seq_no_of_updates on primary is unassigned");
        }
        this.maxSeqNoOfUpdatesOrDeletes.updateAndGet(curr -> Math.max(curr, maxSeqNoOfUpdatesOnPrimary));
    }

    private boolean assertMaxSeqNoOfUpdatesIsAdvanced(Term id, long seqNo, boolean allowDeleted, boolean relaxIfGapInSeqNo) {
        VersionValue versionValue;
        long maxSeqNoOfUpdates = this.getMaxSeqNoOfUpdatesOrDeletes();
        if (allowDeleted && (versionValue = this.versionMap.getVersionForAssert(id.bytes())) != null && versionValue.isDelete()) {
            return true;
        }
        if (relaxIfGapInSeqNo && this.localCheckpointTracker.getProcessedCheckpoint() < maxSeqNoOfUpdates) {
            return true;
        }
        assert (seqNo <= maxSeqNoOfUpdates) : "id=" + String.valueOf(id) + " seq_no=" + seqNo + " msu=" + maxSeqNoOfUpdates;
        return true;
    }

    private void restoreVersionMapAndCheckpointTracker(DirectoryReader directoryReader) throws IOException {
        IndexSearcher searcher = new IndexSearcher(directoryReader);
        searcher.setQueryCache(null);
        BooleanQuery query = new BooleanQuery.Builder().add(LongPoint.newRangeQuery("_seq_no", this.getPersistedLocalCheckpoint() + 1L, Long.MAX_VALUE), BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(), BooleanClause.Occur.MUST).build();
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        for (LeafReaderContext leaf : directoryReader.leaves()) {
            int docId;
            Scorer scorer = weight.scorer(leaf);
            if (scorer == null) continue;
            CombinedDocValues dv = new CombinedDocValues(leaf.reader());
            IdOnlyFieldVisitor idFieldVisitor = new IdOnlyFieldVisitor();
            DocIdSetIterator iterator = scorer.iterator();
            StoredFields storedFields = leaf.reader().storedFields();
            while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
                long primaryTerm = dv.docPrimaryTerm(docId);
                long seqNo = dv.docSeqNo(docId);
                this.localCheckpointTracker.markSeqNoAsProcessed(seqNo);
                this.localCheckpointTracker.markSeqNoAsPersisted(seqNo);
                idFieldVisitor.reset();
                storedFields.document(docId, idFieldVisitor);
                if (idFieldVisitor.getId() == null) {
                    assert (dv.isTombstone(docId));
                    continue;
                }
                BytesRef uid = new Term("_id", Uid.encodeId(idFieldVisitor.getId())).bytes();
                Releasable ignored = this.versionMap.acquireLock(uid);
                try {
                    VersionValue curr = this.versionMap.getUnderLock(uid);
                    if (curr != null && InternalEngine.compareOpToVersionMapOnSeqNo(idFieldVisitor.getId(), seqNo, primaryTerm, curr) != OpVsLuceneDocStatus.OP_NEWER) continue;
                    if (dv.isTombstone(docId)) {
                        long startTime = 0L;
                        this.versionMap.putDeleteUnderLock(uid, new DeleteVersionValue(dv.docVersion(docId), seqNo, primaryTerm, 0L));
                        continue;
                    }
                    this.versionMap.putIndexUnderLock(uid, new IndexVersionValue(null, dv.docVersion(docId), seqNo, primaryTerm));
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
        }
        this.refresh("restore_version_map_and_checkpoint_tracker", Engine.SearcherScope.INTERNAL, true);
    }

    private static /* synthetic */ void lambda$index$2() {
    }

    private final class EngineMergeScheduler
    extends OpenSearchConcurrentMergeScheduler {
        private final AtomicInteger numMergesInFlight;
        private final AtomicBoolean isThrottling;

        EngineMergeScheduler(ShardId shardId, IndexSettings indexSettings) {
            super(shardId, indexSettings);
            this.numMergesInFlight = new AtomicInteger(0);
            this.isThrottling = new AtomicBoolean();
        }

        @Override
        public synchronized void beforeMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.incrementAndGet() > maxNumMerges && !this.isThrottling.getAndSet(true)) {
                this.logger.info("now throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.activateThrottling();
            }
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.decrementAndGet() < maxNumMerges && this.isThrottling.getAndSet(false)) {
                this.logger.info("stop throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.deactivateThrottling();
            }
            if (!InternalEngine.this.indexWriter.hasPendingMerges() && System.nanoTime() - InternalEngine.this.lastWriteNanos >= InternalEngine.this.engineConfig.getFlushMergesAfter().nanos()) {
                InternalEngine.this.engineConfig.getThreadPool().executor("flush").execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (!InternalEngine.this.isClosed.get()) {
                            EngineMergeScheduler.this.logger.warn("failed to flush after merge has finished");
                        }
                    }

                    @Override
                    protected void doRun() {
                        InternalEngine.this.flush();
                    }
                });
            } else if (merge.getTotalBytesSize() >= InternalEngine.this.engineConfig.getIndexSettings().getFlushAfterMergeThresholdSize().getBytes()) {
                InternalEngine.this.shouldPeriodicallyFlushAfterBigMerge.set(true);
            }
        }

        @Override
        protected void handleMergeException(final Throwable exc) {
            InternalEngine.this.engineConfig.getThreadPool().generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    EngineMergeScheduler.this.logger.debug("merge failure action rejected", (Throwable)e);
                }

                @Override
                protected void doRun() throws Exception {
                    InternalEngine.this.failEngine("merge failed", new MergePolicy.MergeException(exc));
                }
            });
        }
    }

    static final class RefreshWarmerListener
    implements BiConsumer<OpenSearchDirectoryReader, OpenSearchDirectoryReader> {
        private final Engine.Warmer warmer;
        private final Logger logger;
        private final AtomicBoolean isEngineClosed;

        RefreshWarmerListener(Logger logger, AtomicBoolean isEngineClosed, EngineConfig engineConfig) {
            this.warmer = engineConfig.getWarmer();
            this.logger = logger;
            this.isEngineClosed = isEngineClosed;
        }

        @Override
        public void accept(OpenSearchDirectoryReader reader, OpenSearchDirectoryReader previousReader) {
            block3: {
                if (this.warmer != null) {
                    try {
                        this.warmer.warm(reader);
                    }
                    catch (Exception e) {
                        if (this.isEngineClosed.get()) break block3;
                        this.logger.warn("failed to prepare/warm", (Throwable)e);
                    }
                }
            }
        }
    }

    @SuppressForbidden(reason="reference counting is required here")
    private static final class ExternalReaderManager
    extends ReferenceManager<OpenSearchDirectoryReader> {
        private final BiConsumer<OpenSearchDirectoryReader, OpenSearchDirectoryReader> refreshListener;
        private final OpenSearchReaderManager internalReaderManager;
        private boolean isWarmedUp;

        ExternalReaderManager(OpenSearchReaderManager internalReaderManager, BiConsumer<OpenSearchDirectoryReader, OpenSearchDirectoryReader> refreshListener) throws IOException {
            this.refreshListener = refreshListener;
            this.internalReaderManager = internalReaderManager;
            this.current = internalReaderManager.acquire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected OpenSearchDirectoryReader refreshIfNeeded(OpenSearchDirectoryReader referenceToRefresh) throws IOException {
            this.internalReaderManager.maybeRefreshBlocking();
            OpenSearchDirectoryReader newReader = (OpenSearchDirectoryReader)this.internalReaderManager.acquire();
            if (!this.isWarmedUp || newReader != referenceToRefresh) {
                boolean success = false;
                try {
                    this.refreshListener.accept(newReader, this.isWarmedUp ? referenceToRefresh : null);
                    this.isWarmedUp = true;
                    success = true;
                }
                finally {
                    if (!success) {
                        this.internalReaderManager.release(newReader);
                    }
                }
            }
            if (referenceToRefresh == newReader) {
                this.internalReaderManager.release(newReader);
                return null;
            }
            return newReader;
        }

        @Override
        protected boolean tryIncRef(OpenSearchDirectoryReader reference) {
            return reference.tryIncRef();
        }

        @Override
        protected int getRefCount(OpenSearchDirectoryReader reference) {
            return reference.getRefCount();
        }

        @Override
        protected void decRef(OpenSearchDirectoryReader reference) throws IOException {
            reference.decRef();
        }
    }

    private final class LastRefreshedCheckpointListener
    implements ReferenceManager.RefreshListener {
        final AtomicLong refreshedCheckpoint;
        volatile AtomicLong pendingCheckpoint;

        LastRefreshedCheckpointListener(long initialLocalCheckpoint) {
            this.refreshedCheckpoint = new AtomicLong(initialLocalCheckpoint);
            this.pendingCheckpoint = new AtomicLong(initialLocalCheckpoint);
        }

        @Override
        public void beforeRefresh() {
            this.pendingCheckpoint.updateAndGet(curr -> Math.max(curr, InternalEngine.this.localCheckpointTracker.getProcessedCheckpoint()));
        }

        @Override
        public void afterRefresh(boolean didRefresh) {
            if (didRefresh) {
                this.updateRefreshedCheckpoint(this.pendingCheckpoint.get());
            }
        }

        void updateRefreshedCheckpoint(long checkpoint) {
            this.refreshedCheckpoint.updateAndGet(curr -> Math.max(curr, checkpoint));
            assert (this.refreshedCheckpoint.get() >= checkpoint) : this.refreshedCheckpoint.get() + " < " + checkpoint;
            this.pendingCheckpoint.updateAndGet(curr -> Math.max(curr, checkpoint));
        }
    }

    static enum OpVsLuceneDocStatus {
        OP_NEWER,
        OP_STALE_OR_EQUAL,
        LUCENE_DOC_NOT_FOUND;

    }

    protected static final class IndexingStrategy {
        final boolean currentNotFoundOrDeleted;
        final boolean useLuceneUpdateDocument;
        final long versionForIndexing;
        final boolean indexIntoLucene;
        final boolean addStaleOpToLucene;
        final int reservedDocs;
        final Optional<Engine.IndexResult> earlyResultOnPreFlightError;

        private IndexingStrategy(boolean currentNotFoundOrDeleted, boolean useLuceneUpdateDocument, boolean indexIntoLucene, boolean addStaleOpToLucene, long versionForIndexing, int reservedDocs, Engine.IndexResult earlyResultOnPreFlightError) {
            assert (!useLuceneUpdateDocument || indexIntoLucene) : "use lucene update is set to true, but we're not indexing into lucene";
            assert (!(indexIntoLucene && earlyResultOnPreFlightError != null)) : "can only index into lucene or have a preflight result but not both.indexIntoLucene: " + indexIntoLucene + "  earlyResultOnPreFlightError:" + String.valueOf(earlyResultOnPreFlightError);
            assert (reservedDocs == 0 || indexIntoLucene || addStaleOpToLucene) : reservedDocs;
            this.currentNotFoundOrDeleted = currentNotFoundOrDeleted;
            this.useLuceneUpdateDocument = useLuceneUpdateDocument;
            this.versionForIndexing = versionForIndexing;
            this.indexIntoLucene = indexIntoLucene;
            this.addStaleOpToLucene = addStaleOpToLucene;
            this.reservedDocs = reservedDocs;
            this.earlyResultOnPreFlightError = earlyResultOnPreFlightError == null ? Optional.empty() : Optional.of(earlyResultOnPreFlightError);
        }

        static IndexingStrategy optimizedAppendOnly(long versionForIndexing, int reservedDocs) {
            return new IndexingStrategy(true, false, true, false, versionForIndexing, reservedDocs, null);
        }

        public static IndexingStrategy skipDueToVersionConflict(VersionConflictEngineException e, boolean currentNotFoundOrDeleted, long currentVersion) {
            Engine.IndexResult result = new Engine.IndexResult(e, currentVersion);
            return new IndexingStrategy(currentNotFoundOrDeleted, false, false, false, -1L, 0, result);
        }

        static IndexingStrategy processNormally(boolean currentNotFoundOrDeleted, long versionForIndexing, int reservedDocs) {
            return new IndexingStrategy(currentNotFoundOrDeleted, !currentNotFoundOrDeleted, true, false, versionForIndexing, reservedDocs, null);
        }

        public static IndexingStrategy processButSkipLucene(boolean currentNotFoundOrDeleted, long versionForIndexing) {
            return new IndexingStrategy(currentNotFoundOrDeleted, false, false, false, versionForIndexing, 0, null);
        }

        static IndexingStrategy processAsStaleOp(long versionForIndexing) {
            return new IndexingStrategy(false, false, false, true, versionForIndexing, 0, null);
        }

        static IndexingStrategy failAsTooManyDocs(Exception e) {
            Engine.IndexResult result = new Engine.IndexResult(e, -1L);
            return new IndexingStrategy(false, false, false, false, -1L, 0, result);
        }
    }

    protected static final class DeletionStrategy {
        final boolean deleteFromLucene;
        final boolean addStaleOpToLucene;
        final boolean currentlyDeleted;
        final long versionOfDeletion;
        final Optional<Engine.DeleteResult> earlyResultOnPreflightError;
        final int reservedDocs;

        private DeletionStrategy(boolean deleteFromLucene, boolean addStaleOpToLucene, boolean currentlyDeleted, long versionOfDeletion, int reservedDocs, Engine.DeleteResult earlyResultOnPreflightError) {
            assert (!(deleteFromLucene && earlyResultOnPreflightError != null)) : "can only delete from lucene or have a preflight result but not both.deleteFromLucene: " + deleteFromLucene + "  earlyResultOnPreFlightError:" + String.valueOf(earlyResultOnPreflightError);
            this.deleteFromLucene = deleteFromLucene;
            this.addStaleOpToLucene = addStaleOpToLucene;
            this.currentlyDeleted = currentlyDeleted;
            this.versionOfDeletion = versionOfDeletion;
            this.reservedDocs = reservedDocs;
            assert (reservedDocs == 0 || deleteFromLucene || addStaleOpToLucene) : reservedDocs;
            this.earlyResultOnPreflightError = earlyResultOnPreflightError == null ? Optional.empty() : Optional.of(earlyResultOnPreflightError);
        }

        public static DeletionStrategy skipDueToVersionConflict(VersionConflictEngineException e, long currentVersion, boolean currentlyDeleted) {
            Engine.DeleteResult deleteResult = new Engine.DeleteResult(e, currentVersion, 0L, -2L, !currentlyDeleted);
            return new DeletionStrategy(false, false, currentlyDeleted, -1L, 0, deleteResult);
        }

        static DeletionStrategy processNormally(boolean currentlyDeleted, long versionOfDeletion, int reservedDocs) {
            return new DeletionStrategy(true, false, currentlyDeleted, versionOfDeletion, reservedDocs, null);
        }

        public static DeletionStrategy processButSkipLucene(boolean currentlyDeleted, long versionOfDeletion) {
            return new DeletionStrategy(false, false, currentlyDeleted, versionOfDeletion, 0, null);
        }

        static DeletionStrategy processAsStaleOp(long versionOfDeletion) {
            return new DeletionStrategy(false, true, false, versionOfDeletion, 0, null);
        }

        static DeletionStrategy failAsTooManyDocs(Exception e) {
            Engine.DeleteResult deleteResult = new Engine.DeleteResult(e, -1L, 0L, -2L, false);
            return new DeletionStrategy(false, false, false, -1L, 0, deleteResult);
        }
    }

    private static class AssertingIndexWriter
    extends IndexWriter {
        AssertingIndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
            super(d, conf);
        }

        @Override
        public long updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) {
            throw new AssertionError((Object)"must not hard update documents");
        }

        @Override
        public long tryDeleteDocument(IndexReader readerIn, int docID) {
            assert (false) : "#tryDeleteDocument is not supported. See Lucene#DirectoryReaderWithAllLiveDocs";
            throw new UnsupportedOperationException();
        }
    }
}

