/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.Field;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.SortedSetDocValuesField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableFieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.PrefixQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TermInSetQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TermRangeQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Iterators;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.AutomatonQueries;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.JsonToStringXContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.NamedAnalyzer;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DynamicKeyFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.KeywordFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.StringFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchService;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public final class FlatObjectFieldMapper
extends DynamicKeyFieldMapper {
    public static final String CONTENT_TYPE = "flat_object";
    private static final String VALUE_AND_PATH_SUFFIX = "._valueAndPath";
    private static final String VALUE_SUFFIX = "._value";
    private static final String DOT_SYMBOL = ".";
    private static final String EQUAL_SYMBOL = "=";
    public static final TypeParser PARSER = new TypeParser((n, c) -> new Builder((String)n));
    private final ValueFieldMapper valueFieldMapper;
    private final ValueAndPathFieldMapper valueAndPathFieldMapper;

    @Override
    public MappedFieldType keyedFieldType(String key) {
        return new FlatObjectFieldType(this.name() + DOT_SYMBOL + key, this.name());
    }

    FlatObjectFieldMapper(String simpleName, FieldType fieldType, FlatObjectFieldType mappedFieldType, ValueFieldMapper valueFieldMapper, ValueAndPathFieldMapper valueAndPathFieldMapper, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, fieldType, mappedFieldType, copyTo);
        assert (fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) <= 0);
        this.fieldType = fieldType;
        this.valueFieldMapper = valueFieldMapper;
        this.valueAndPathFieldMapper = valueAndPathFieldMapper;
        this.mappedFieldType = mappedFieldType;
    }

    @Override
    protected FlatObjectFieldMapper clone() {
        return (FlatObjectFieldMapper)super.clone();
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    @Override
    public FlatObjectFieldType fieldType() {
        return (FlatObjectFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String fieldName = null;
        if (context.externalValueSet()) {
            String value = context.externalValue().toString();
            this.parseValueAddFields(context, value, this.fieldType().name());
        } else {
            XContentParser.Token currentToken;
            JsonToStringXContentParser JsonToStringParser = new JsonToStringXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, context.parser(), this.fieldType().name());
            XContentParser parser = JsonToStringParser.parseObject();
            while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                switch (currentToken) {
                    case FIELD_NAME: {
                        fieldName = parser.currentName();
                        break;
                    }
                    case VALUE_STRING: {
                        String value = parser.textOrNull();
                        this.parseValueAddFields(context, value, fieldName);
                    }
                }
            }
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        if (this.valueFieldMapper != null) {
            subIterators.add(this.valueFieldMapper);
        }
        if (this.valueAndPathFieldMapper != null) {
            subIterators.add(this.valueAndPathFieldMapper);
        }
        if (subIterators.size() == 0) {
            return super.iterator();
        }
        Iterator<Mapper> concat = Iterators.concat(super.iterator(), subIterators.iterator());
        return concat;
    }

    private void parseValueAddFields(ParseContext context, String value, String fieldName) throws IOException {
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            value = FlatObjectFieldMapper.normalizeValue(normalizer, this.name(), value);
        }
        String[] valueTypeList = fieldName.split("\\._");
        String valueType = "._" + valueTypeList[valueTypeList.length - 1];
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            BytesRef binaryValue = new BytesRef(this.fieldType().name() + DOT_SYMBOL + value);
            FlatObjectField field = new FlatObjectField(this.fieldType().name(), binaryValue, this.fieldType);
            if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                this.createFieldNamesField(context);
            }
            if (fieldName.equals(this.fieldType().name())) {
                context.doc().add(field);
            }
            if (valueType.equals(VALUE_SUFFIX) && this.valueFieldMapper != null) {
                this.valueFieldMapper.addField(context, value);
            }
            if (valueType.equals(VALUE_AND_PATH_SUFFIX) && this.valueAndPathFieldMapper != null) {
                this.valueAndPathFieldMapper.addField(context, value);
            }
            if (this.fieldType().hasDocValues()) {
                if (fieldName.equals(this.fieldType().name())) {
                    context.doc().add(new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
                }
                if (valueType.equals(VALUE_SUFFIX) && this.valueFieldMapper != null) {
                    context.doc().add(new SortedSetDocValuesField(this.fieldType().name() + VALUE_SUFFIX, binaryValue));
                }
                if (valueType.equals(VALUE_AND_PATH_SUFFIX) && this.valueAndPathFieldMapper != null) {
                    context.doc().add(new SortedSetDocValuesField(this.fieldType().name() + VALUE_AND_PATH_SUFFIX, binaryValue));
                }
            }
        }
    }

    private static String normalizeValue(NamedAnalyzer normalizer, String field, String value) throws IOException {
        String normalizerErrorMessage = "The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + String.valueOf(normalizer) + " and input \"" + value + "\"";
        try (TokenStream ts = normalizer.tokenStream(field, value);){
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            if (!ts.incrementToken()) {
                throw new IllegalStateException(normalizerErrorMessage);
            }
            String newValue = termAtt.toString();
            if (ts.incrementToken()) {
                throw new IllegalStateException(normalizerErrorMessage);
            }
            ts.end();
            String string = newValue;
            return string;
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class FlatObjectFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;
        private final String mappedFieldTypeName;
        private KeywordFieldMapper.KeywordFieldType valueFieldType;
        private KeywordFieldMapper.KeywordFieldType valueAndPathFieldType;

        public FlatObjectFieldType(String name, boolean isSearchable, boolean hasDocValues, Map<String, String> meta) {
            super(name, isSearchable, false, true, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = null;
        }

        public FlatObjectFieldType(String name, FieldType fieldType) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, false, true, new TextSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = null;
        }

        public FlatObjectFieldType(String name, NamedAnalyzer analyzer) {
            super(name, true, false, true, new TextSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = null;
        }

        public FlatObjectFieldType(String name, String mappedFieldTypeName) {
            super(name, true, false, true, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = mappedFieldTypeName;
        }

        void setValueFieldType(KeywordFieldMapper.KeywordFieldType valueFieldType) {
            this.valueFieldType = valueFieldType;
        }

        void setValueAndPathFieldType(KeywordFieldMapper.KeywordFieldType ValueAndPathFieldType) {
            this.valueAndPathFieldType = ValueAndPathFieldType;
        }

        public KeywordFieldMapper.KeywordFieldType getValueFieldType() {
            return this.valueFieldType;
        }

        public KeywordFieldMapper.KeywordFieldType getValueAndPathFieldType() {
            return this.valueAndPathFieldType;
        }

        @Override
        public String typeName() {
            return FlatObjectFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.indexAnalyzer();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String flatObjectKeywordValue = value.toString();
                    if (flatObjectKeywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    NamedAnalyzer normalizer = this.normalizer();
                    if (normalizer == null) {
                        return flatObjectKeywordValue;
                    }
                    try {
                        return FlatObjectFieldMapper.normalizeValue(normalizer, this.name(), flatObjectKeywordValue);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            value = this.inputToString(value);
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String searchValueString = this.inputToString(value);
            String directSubFieldName = this.directSubfield();
            String rewriteSearchValue = this.rewriteValue(searchValueString);
            this.failIfNotIndexed();
            Query query = new TermQuery(new Term(directSubFieldName, this.indexedValueForSearch(rewriteSearchValue)));
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexed();
            String directedSearchFieldName = this.directSubfield();
            BytesRef[] bytesRefs = new BytesRef[values.size()];
            for (int i = 0; i < bytesRefs.length; ++i) {
                String rewriteValues = this.rewriteValue(this.inputToString(values.get(i)));
                bytesRefs[i] = this.indexedValueForSearch(new BytesRef(rewriteValues));
            }
            return new TermInSetQuery(directedSearchFieldName, bytesRefs);
        }

        public String directSubfield() {
            if (this.mappedFieldTypeName == null) {
                return this.name() + FlatObjectFieldMapper.VALUE_SUFFIX;
            }
            return this.mappedFieldTypeName + FlatObjectFieldMapper.VALUE_AND_PATH_SUFFIX;
        }

        public String rewriteValue(String searchValueString) {
            if (!this.hasMappedFieldTyeNameInQueryFieldName(this.name())) {
                return searchValueString;
            }
            String rewriteSearchValue = this.name() + FlatObjectFieldMapper.EQUAL_SYMBOL + searchValueString;
            return rewriteSearchValue;
        }

        private boolean hasMappedFieldTyeNameInQueryFieldName(String input) {
            String prefix = this.mappedFieldTypeName;
            if (prefix == null) {
                return false;
            }
            if (!input.startsWith(prefix)) {
                return false;
            }
            String rest = input.substring(prefix.length());
            return !rest.isEmpty();
        }

        private String inputToString(Object inputValue) {
            if (inputValue instanceof Integer) {
                String inputToString = Integer.toString((Integer)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Float) {
                String inputToString = Float.toString(((Float)inputValue).floatValue());
                return inputToString;
            }
            if (inputValue instanceof Boolean) {
                String inputToString = Boolean.toString((Boolean)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Short) {
                String inputToString = Short.toString((Short)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Long) {
                String inputToString = Long.toString((Long)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Double) {
                String inputToString = Double.toString((Double)inputValue);
                return inputToString;
            }
            if (inputValue instanceof BytesRef) {
                String inputToString = ((BytesRef)inputValue).utf8ToString();
                return inputToString;
            }
            if (inputValue instanceof String) {
                String inputToString = (String)inputValue;
                return inputToString;
            }
            if (inputValue instanceof Version) {
                String inputToString = inputValue.toString();
                return inputToString;
            }
            return inputValue.toString();
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            String directSubfield = this.directSubfield();
            String rewriteValue = this.rewriteValue(value);
            if (!context.allowExpensiveQueries()) {
                throw new OpenSearchException("[prefix] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false. For optimised prefix queries on text fields please enable [index_prefixes].", new Object[0]);
            }
            this.failIfNotIndexed();
            if (method == null) {
                method = MultiTermQuery.CONSTANT_SCORE_REWRITE;
            }
            if (caseInsensitive) {
                return AutomatonQueries.caseInsensitivePrefixQuery(new Term(directSubfield, this.indexedValueForSearch(rewriteValue)), method);
            }
            return new PrefixQuery(new Term(directSubfield, this.indexedValueForSearch(rewriteValue)), method);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            String directSubfield = this.directSubfield();
            String rewriteUpperTerm = this.rewriteValue(this.inputToString(upperTerm));
            String rewriteLowerTerm = this.rewriteValue(this.inputToString(lowerTerm));
            if (!context.allowExpensiveQueries()) {
                throw new OpenSearchException("[range] queries on [text] or [keyword] fields cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            this.failIfNotIndexed();
            return new TermRangeQuery(directSubfield, lowerTerm == null ? null : this.indexedValueForSearch(rewriteLowerTerm), upperTerm == null ? null : this.indexedValueForSearch(rewriteUpperTerm), includeLower, includeUpper);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            String searchField;
            String searchKey;
            if (this.hasMappedFieldTyeNameInQueryFieldName(this.name())) {
                searchKey = this.mappedFieldTypeName;
                searchField = this.name();
            } else {
                searchKey = "_field_names";
                searchField = this.name();
            }
            return new TermQuery(new Term(searchKey, this.indexedValueForSearch(searchField)));
        }

        @Override
        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, QueryShardContext context) {
            throw new QueryShardException(context, "Can only use wildcard queries on keyword and text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]", new Object[0]);
        }
    }

    private static final class ValueFieldMapper
    extends FieldMapper {
        protected ValueFieldMapper(FieldType fieldType, KeywordFieldMapper.KeywordFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        void addField(ParseContext context, String value) {
            BytesRef binaryValue = new BytesRef(value);
            if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
                KeywordFieldMapper.KeywordField field = new KeywordFieldMapper.KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
                context.doc().add(field);
                if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                    this.createFieldNamesField(context);
                }
            }
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "value";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    private static final class ValueAndPathFieldMapper
    extends FieldMapper {
        protected ValueAndPathFieldMapper(FieldType fieldType, KeywordFieldMapper.KeywordFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        void addField(ParseContext context, String value) {
            BytesRef binaryValue = new BytesRef(value);
            if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
                KeywordFieldMapper.KeywordField field = new KeywordFieldMapper.KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
                context.doc().add(field);
                if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                    this.createFieldNamesField(context);
                }
            }
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "valueAndPath";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    public static class FlatObjectField
    extends Field {
        public FlatObjectField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        private FlatObjectFieldType buildFlatObjectFieldType(Mapper.BuilderContext context, FieldType fieldType) {
            return new FlatObjectFieldType(this.buildFullName(context), fieldType);
        }

        private ValueFieldMapper buildValueFieldMapper(Mapper.BuilderContext context, FieldType fieldType, FlatObjectFieldType fft) {
            String fullName = this.buildFullName(context);
            FieldType vft = new FieldType(fieldType);
            KeywordFieldMapper.KeywordFieldType valueFieldType = new KeywordFieldMapper.KeywordFieldType(fullName + FlatObjectFieldMapper.VALUE_SUFFIX, vft);
            fft.setValueFieldType(valueFieldType);
            return new ValueFieldMapper(vft, valueFieldType);
        }

        private ValueAndPathFieldMapper buildValueAndPathFieldMapper(Mapper.BuilderContext context, FieldType fieldType, FlatObjectFieldType fft) {
            String fullName = this.buildFullName(context);
            FieldType vft = new FieldType(fieldType);
            KeywordFieldMapper.KeywordFieldType ValueAndPathFieldType = new KeywordFieldMapper.KeywordFieldType(fullName + FlatObjectFieldMapper.VALUE_AND_PATH_SUFFIX, vft);
            fft.setValueAndPathFieldType(ValueAndPathFieldType);
            return new ValueAndPathFieldMapper(vft, ValueAndPathFieldType);
        }

        @Override
        public FlatObjectFieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldtype = new FieldType(Defaults.FIELD_TYPE);
            FlatObjectFieldType fft = this.buildFlatObjectFieldType(context, fieldtype);
            return new FlatObjectFieldMapper(this.name, Defaults.FIELD_TYPE, fft, this.buildValueFieldMapper(context, fieldtype, fft), this.buildValueAndPathFieldMapper(context, fieldtype, fft), FieldMapper.CopyTo.empty(), this);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private final BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction;

        public TypeParser(BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction) {
            this.builderFunction = builderFunction;
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(name, parserContext);
            return builder;
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

