/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.Explicit;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.CopyOnWriteHashMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DerivedFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DocumentMapperParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldAliasMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperException;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappingLookup;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.NestedPathFieldMapper;

@PublicApi(since="1.0.0")
public class ObjectMapper
extends Mapper
implements Cloneable {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ObjectMapper.class);
    public static final String CONTENT_TYPE = "object";
    public static final String NESTED_CONTENT_TYPE = "nested";
    private final String fullPath;
    private Explicit<Boolean> enabled;
    private final Nested nested;
    private final String nestedTypePath;
    private final Query nestedTypeFilter;
    private volatile Dynamic dynamic;
    private volatile CopyOnWriteHashMap<String, Mapper> mappers;

    ObjectMapper(String name, String fullPath, Explicit<Boolean> enabled, Nested nested, Dynamic dynamic, Map<String, Mapper> mappers, Settings settings) {
        super(name);
        assert (settings != null);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty string");
        }
        this.fullPath = fullPath;
        this.enabled = enabled;
        this.nested = nested;
        this.dynamic = dynamic;
        this.mappers = mappers == null ? new CopyOnWriteHashMap() : CopyOnWriteHashMap.copyOf(mappers);
        Version version = IndexMetadata.indexCreated(settings);
        this.nestedTypePath = version.before(Version.V_2_0_0) ? "__" + fullPath : fullPath;
        this.nestedTypeFilter = NestedPathFieldMapper.filter(version, this.nestedTypePath);
    }

    protected ObjectMapper clone() {
        ObjectMapper clone;
        try {
            clone = (ObjectMapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public ObjectMapper mappingUpdate(Mapper mapper) {
        ObjectMapper mappingUpdate = this.clone();
        mappingUpdate.mappers = new CopyOnWriteHashMap();
        mappingUpdate.putMapper(mapper);
        return mappingUpdate;
    }

    @Override
    public String name() {
        return this.fullPath;
    }

    @Override
    public String typeName() {
        return CONTENT_TYPE;
    }

    public boolean isEnabled() {
        return this.enabled.value();
    }

    public Mapper getMapper(String field) {
        return this.mappers.get(field);
    }

    public Nested nested() {
        return this.nested;
    }

    public Query nestedTypeFilter() {
        return this.nestedTypeFilter;
    }

    protected void putMapper(Mapper mapper) {
        this.mappers = this.mappers.copyAndPut(mapper.simpleName(), mapper);
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.mappers.values().iterator();
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String nestedTypePath() {
        return this.nestedTypePath;
    }

    public final Dynamic dynamic() {
        return this.dynamic;
    }

    public ObjectMapper getParentObjectMapper(MapperService mapperService) {
        int indexOfLastDot = this.fullPath().lastIndexOf(46);
        if (indexOfLastDot != -1) {
            String parentNestObjectPath = this.fullPath().substring(0, indexOfLastDot);
            return mapperService.getObjectMapper(parentNestObjectPath);
        }
        return null;
    }

    public boolean parentObjectMapperAreNested(MapperService mapperService) {
        for (ObjectMapper parent = this.getParentObjectMapper(mapperService); parent != null; parent = parent.getParentObjectMapper(mapperService)) {
            if (parent.nested().isNested()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith) {
        return this.merge(mergeWith, MapperService.MergeReason.MAPPING_UPDATE);
    }

    @Override
    public void validate(MappingLookup mappers) {
        for (Mapper mapper : this.mappers.values()) {
            mapper.validate(mappers);
        }
    }

    public ObjectMapper merge(Mapper mergeWith, MapperService.MergeReason reason) {
        if (!(mergeWith instanceof ObjectMapper)) {
            throw new IllegalArgumentException("can't merge a non object mapping [" + mergeWith.name() + "] with an object mapping");
        }
        ObjectMapper mergeWithObject = (ObjectMapper)mergeWith;
        ObjectMapper merged = this.clone();
        merged.doMerge(mergeWithObject, reason);
        return merged;
    }

    protected void doMerge(ObjectMapper mergeWith, MapperService.MergeReason reason) {
        this.nested().merge(mergeWith.nested(), reason);
        if (mergeWith.dynamic != null) {
            this.dynamic = mergeWith.dynamic;
        }
        if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
            if (mergeWith.enabled.explicit()) {
                this.enabled = mergeWith.enabled;
            }
        } else if (this.isEnabled() != mergeWith.isEnabled()) {
            throw new MapperException("the [enabled] parameter can't be updated for the object mapping [" + this.name() + "]");
        }
        for (Mapper mergeWithMapper : mergeWith) {
            Mapper merged;
            Mapper mergeIntoMapper = this.mappers.get(mergeWithMapper.simpleName());
            if (mergeIntoMapper == null) {
                merged = mergeWithMapper;
            } else if (mergeIntoMapper instanceof ObjectMapper) {
                ObjectMapper objectMapper = (ObjectMapper)mergeIntoMapper;
                merged = objectMapper.merge(mergeWithMapper, reason);
            } else {
                assert (mergeIntoMapper instanceof FieldMapper || mergeIntoMapper instanceof FieldAliasMapper);
                if (mergeWithMapper instanceof ObjectMapper) {
                    throw new IllegalArgumentException("can't merge a non object mapping [" + mergeWithMapper.name() + "] with an object mapping");
                }
                merged = reason == MapperService.MergeReason.INDEX_TEMPLATE ? mergeWithMapper : mergeIntoMapper.merge(mergeWithMapper);
            }
            this.putMapper(merged);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContent(builder, params, null);
        return builder;
    }

    public void toXContent(XContentBuilder builder, ToXContent.Params params, ToXContent custom) throws IOException {
        builder.startObject(this.simpleName());
        if (this.nested.isNested()) {
            builder.field("type", NESTED_CONTENT_TYPE);
            if (this.nested.isIncludeInParent()) {
                builder.field("include_in_parent", true);
            }
            if (this.nested.isIncludeInRoot()) {
                builder.field("include_in_root", true);
            }
        } else if (this.mappers.isEmpty() && custom == null) {
            builder.field("type", CONTENT_TYPE);
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.isEnabled()) {
            builder.field("enabled", this.enabled.value());
        }
        if (custom != null) {
            custom.toXContent(builder, params);
        }
        this.doXContent(builder, params);
        Mapper[] derivedSortedMappers = (Mapper[])this.mappers.values().stream().filter(m -> m instanceof DerivedFieldMapper).toArray(Mapper[]::new);
        Arrays.sort(derivedSortedMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        Mapper[] sortedMappers = (Mapper[])this.mappers.values().stream().filter(m -> !(m instanceof DerivedFieldMapper)).toArray(Mapper[]::new);
        Arrays.sort(sortedMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        int count = 0;
        for (Mapper mapper : derivedSortedMappers) {
            if (count++ == 0) {
                builder.startObject("derived");
            }
            mapper.toXContent(builder, params);
        }
        if (count > 0) {
            builder.endObject();
        }
        count = 0;
        for (Mapper mapper : sortedMappers) {
            if (mapper instanceof MetadataFieldMapper) continue;
            if (count++ == 0) {
                builder.startObject("properties");
            }
            mapper.toXContent(builder, params);
        }
        if (count > 0) {
            builder.endObject();
        }
        builder.endObject();
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    @PublicApi(since="1.0.0")
    public static class Nested {
        public static final Nested NO = new Nested(false, new Explicit<Boolean>(false, false), new Explicit<Boolean>(false, false));
        private final boolean nested;
        private Explicit<Boolean> includeInParent;
        private Explicit<Boolean> includeInRoot;

        public static Nested newNested() {
            return new Nested(true, new Explicit<Boolean>(false, false), new Explicit<Boolean>(false, false));
        }

        public static Nested newNested(Explicit<Boolean> includeInParent, Explicit<Boolean> includeInRoot) {
            return new Nested(true, includeInParent, includeInRoot);
        }

        private Nested(boolean nested, Explicit<Boolean> includeInParent, Explicit<Boolean> includeInRoot) {
            this.nested = nested;
            this.includeInParent = includeInParent;
            this.includeInRoot = includeInRoot;
        }

        public void merge(Nested mergeWith, MapperService.MergeReason reason) {
            if (this.isNested()) {
                if (!mergeWith.isNested()) {
                    throw new IllegalArgumentException("cannot change object mapping from nested to non-nested");
                }
            } else if (mergeWith.isNested()) {
                throw new IllegalArgumentException("cannot change object mapping from non-nested to nested");
            }
            if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
                if (mergeWith.includeInParent.explicit()) {
                    this.includeInParent = mergeWith.includeInParent;
                }
                if (mergeWith.includeInRoot.explicit()) {
                    this.includeInRoot = mergeWith.includeInRoot;
                }
            } else {
                if (this.includeInParent.value() != mergeWith.includeInParent.value()) {
                    throw new MapperException("the [include_in_parent] parameter can't be updated on a nested object mapping");
                }
                if (this.includeInRoot.value() != mergeWith.includeInRoot.value()) {
                    throw new MapperException("the [include_in_root] parameter can't be updated on a nested object mapping");
                }
            }
        }

        public boolean isNested() {
            return this.nested;
        }

        public boolean isIncludeInParent() {
            return this.includeInParent.value();
        }

        public boolean isIncludeInRoot() {
            return this.includeInRoot.value();
        }

        public void setIncludeInParent(boolean value) {
            this.includeInParent = new Explicit<Boolean>(value, true);
        }

        public void setIncludeInRoot(boolean value) {
            this.includeInRoot = new Explicit<Boolean>(value, true);
        }
    }

    @PublicApi(since="1.0.0")
    public static enum Dynamic {
        TRUE,
        FALSE,
        STRICT;

    }

    public static class Defaults {
        public static final boolean ENABLED = true;
        public static final Nested NESTED = Nested.NO;
        public static final Dynamic DYNAMIC = null;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParser.parseNested(name, node, builder, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder)) continue;
                iterator.remove();
            }
            return builder;
        }

        protected static boolean parseObjectOrDocumentTypeProperties(String fieldName, Object fieldNode, Mapper.TypeParser.ParserContext parserContext, Builder builder) {
            if (fieldName.equals("dynamic")) {
                String value = fieldNode.toString();
                if (value.equalsIgnoreCase("strict")) {
                    builder.dynamic(Dynamic.STRICT);
                } else {
                    boolean dynamic = XContentMapValues.nodeBooleanValue(fieldNode, fieldName + ".dynamic");
                    builder.dynamic(dynamic ? Dynamic.TRUE : Dynamic.FALSE);
                }
                return true;
            }
            if (fieldName.equals("enabled")) {
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode, fieldName + ".enabled"));
                return true;
            }
            if (fieldName.equals("derived")) {
                if (!(fieldNode instanceof Collection) || !((Collection)fieldNode).isEmpty()) {
                    if (fieldNode instanceof Map) {
                        TypeParser.parseDerived(builder, (Map)fieldNode, parserContext);
                    } else {
                        throw new OpenSearchParseException("derived must be a map type", new Object[0]);
                    }
                }
                return true;
            }
            if (fieldName.equals("properties")) {
                if (!(fieldNode instanceof Collection) || !((Collection)fieldNode).isEmpty()) {
                    if (!(fieldNode instanceof Map)) {
                        throw new OpenSearchParseException("properties must be a map type", new Object[0]);
                    }
                    TypeParser.parseProperties(builder, (Map)fieldNode, parserContext);
                }
                return true;
            }
            if (fieldName.equals("include_in_all")) {
                deprecationLogger.deprecate("include_in_all", "[include_in_all] is deprecated, the _all field have been removed in this version", new Object[0]);
                return true;
            }
            return false;
        }

        protected static void parseNested(String name, Map<String, Object> node, Builder builder, Mapper.TypeParser.ParserContext parserContext) {
            boolean nested = false;
            Explicit<Boolean> nestedIncludeInParent = new Explicit<Boolean>(false, false);
            Explicit<Boolean> nestedIncludeInRoot = new Explicit<Boolean>(false, false);
            Object fieldNode = node.get("type");
            if (fieldNode != null) {
                String type = fieldNode.toString();
                if (type.equals(ObjectMapper.CONTENT_TYPE)) {
                    builder.nested = Nested.NO;
                } else if (type.equals(ObjectMapper.NESTED_CONTENT_TYPE)) {
                    nested = true;
                } else {
                    throw new MapperParsingException("Trying to parse an object but has a different type [" + type + "] for [" + name + "]");
                }
            }
            if ((fieldNode = node.get("include_in_parent")) != null) {
                boolean includeInParent = XContentMapValues.nodeBooleanValue(fieldNode, name + ".include_in_parent");
                nestedIncludeInParent = new Explicit<Boolean>(includeInParent, true);
                node.remove("include_in_parent");
            }
            if ((fieldNode = node.get("include_in_root")) != null) {
                boolean includeInRoot = XContentMapValues.nodeBooleanValue(fieldNode, name + ".include_in_root");
                nestedIncludeInRoot = new Explicit<Boolean>(includeInRoot, true);
                node.remove("include_in_root");
            }
            if (nested) {
                builder.nested = Nested.newNested(nestedIncludeInParent, nestedIncludeInRoot);
            }
        }

        protected static void parseDerived(Builder objBuilder, Map<String, Object> derivedNode, Mapper.TypeParser.ParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = derivedNode.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isEmptyList;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                boolean bl = isEmptyList = entry.getValue() instanceof List && ((List)entry.getValue()).isEmpty();
                if (entry.getValue() instanceof Map) {
                    Map node = (Map)entry.getValue();
                    Mapper.TypeParser typeParser = parserContext.typeParser("derived");
                    String[] fieldNameParts = fieldName.split("\\.");
                    if (fieldNameParts.length < 1) {
                        throw new MapperParsingException("Invalid field name " + fieldName);
                    }
                    String realFieldName = fieldNameParts[fieldNameParts.length - 1];
                    Mapper.Builder<?> fieldBuilder = typeParser.parse(realFieldName, node, parserContext);
                    for (int i = fieldNameParts.length - 2; i >= 0; --i) {
                        Builder intermediate = new Builder(fieldNameParts[i]);
                        intermediate.add(fieldBuilder);
                        fieldBuilder = intermediate;
                    }
                    objBuilder.add(fieldBuilder);
                    node.remove("type");
                    DocumentMapperParser.checkNoRemainingFields(fieldName, node, parserContext.indexVersionCreated());
                    iterator.remove();
                    continue;
                }
                if (isEmptyList) {
                    iterator.remove();
                    continue;
                }
                throw new MapperParsingException("Expected map for property [derived_fields] on field [" + fieldName + "] but got a " + String.valueOf(fieldName.getClass()));
            }
            DocumentMapperParser.checkNoRemainingFields(derivedNode, parserContext.indexVersionCreated(), "DocType mapping definition has unsupported parameters: ");
        }

        protected static void parseProperties(Builder objBuilder, Map<String, Object> propsNode, Mapper.TypeParser.ParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = propsNode.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isEmptyList;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                boolean bl = isEmptyList = entry.getValue() instanceof List && ((List)entry.getValue()).isEmpty();
                if (entry.getValue() instanceof Map) {
                    String type;
                    Map propNode = (Map)entry.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode != null) {
                        type = typeNode.toString();
                    } else if (propNode.get("properties") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else if (propNode.size() == 1 && propNode.get("enabled") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else {
                        throw new MapperParsingException("No type specified for field [" + fieldName + "]");
                    }
                    Mapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + fieldName + "]");
                    }
                    String[] fieldNameParts = fieldName.split("\\.");
                    if (fieldNameParts.length < 1) {
                        throw new MapperParsingException("Invalid field name " + fieldName);
                    }
                    String realFieldName = fieldNameParts[fieldNameParts.length - 1];
                    Mapper.Builder<?> fieldBuilder = typeParser.parse(realFieldName, propNode, parserContext);
                    for (int i = fieldNameParts.length - 2; i >= 0; --i) {
                        Builder intermediate = new Builder(fieldNameParts[i]);
                        intermediate.add(fieldBuilder);
                        fieldBuilder = intermediate;
                    }
                    objBuilder.add(fieldBuilder);
                    propNode.remove("type");
                    DocumentMapperParser.checkNoRemainingFields(fieldName, propNode, parserContext.indexVersionCreated());
                    iterator.remove();
                    continue;
                }
                if (isEmptyList) {
                    iterator.remove();
                    continue;
                }
                throw new MapperParsingException("Expected map for property [fields] on field [" + fieldName + "] but got a " + String.valueOf(fieldName.getClass()));
            }
            DocumentMapperParser.checkNoRemainingFields(propsNode, parserContext.indexVersionCreated(), "DocType mapping definition has unsupported parameters: ");
        }
    }

    public static class Builder<T extends Builder>
    extends Mapper.Builder<T> {
        protected Explicit<Boolean> enabled = new Explicit<Boolean>(true, false);
        protected Nested nested = Defaults.NESTED;
        protected Dynamic dynamic = Defaults.DYNAMIC;
        protected final List<Mapper.Builder> mappersBuilders = new ArrayList<Mapper.Builder>();

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public T enabled(boolean enabled) {
            this.enabled = new Explicit<Boolean>(enabled, true);
            return (T)((Builder)this.builder);
        }

        public T dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return (T)((Builder)this.builder);
        }

        public T nested(Nested nested) {
            this.nested = nested;
            return (T)((Builder)this.builder);
        }

        public T add(Mapper.Builder builder) {
            this.mappersBuilders.add(builder);
            return (T)((Builder)this.builder);
        }

        @Override
        public ObjectMapper build(Mapper.BuilderContext context) {
            context.path().add(this.name);
            HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
            for (Mapper.Builder builder : this.mappersBuilders) {
                Mapper mapper = builder.build(context);
                Mapper existing = (Mapper)mappers.get(mapper.simpleName());
                if (existing != null) {
                    mapper = existing.merge(mapper);
                }
                mappers.put(mapper.simpleName(), mapper);
            }
            context.path().remove();
            ObjectMapper objectMapper = this.createMapper(this.name, context.path().pathAsText(this.name), this.enabled, this.nested, this.dynamic, mappers, context.indexSettings());
            return objectMapper;
        }

        protected ObjectMapper createMapper(String name, String fullPath, Explicit<Boolean> enabled, Nested nested, Dynamic dynamic, Map<String, Mapper> mappers, @Nullable Settings settings) {
            return new ObjectMapper(name, fullPath, enabled, nested, dynamic, mappers, settings);
        }
    }
}

