/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesArray;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;

@PublicApi(since="1.0.0")
public class SourceToParse {
    private final BytesReference source;
    private final String index;
    private final String id;
    @Nullable
    private final String routing;
    private final MediaType mediaType;

    public SourceToParse(String index, String id, BytesReference source, MediaType mediaType, @Nullable String routing) {
        this.index = Objects.requireNonNull(index);
        this.id = Objects.requireNonNull(id);
        this.source = new BytesArray(Objects.requireNonNull(source).toBytesRef());
        this.mediaType = Objects.requireNonNull(mediaType);
        this.routing = routing;
    }

    public SourceToParse(String index, String id, BytesReference source, MediaType mediaType) {
        this(index, id, source, mediaType, null);
    }

    public BytesReference source() {
        return this.source;
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public static enum Origin {
        PRIMARY,
        REPLICA;

    }
}

