/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.memory.MemoryIndex;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DerivedFieldValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.LeafSearchLookup;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public final class DerivedFieldQuery
extends Query {
    private final Query query;
    private final DerivedFieldValueFetcher valueFetcher;
    private final SearchLookup searchLookup;
    private final Analyzer indexAnalyzer;
    private final boolean ignoreMalformed;
    private final Function<Object, IndexableField> indexableFieldGenerator;

    public DerivedFieldQuery(Query query, DerivedFieldValueFetcher valueFetcher, SearchLookup searchLookup, Analyzer indexAnalyzer, Function<Object, IndexableField> indexableFieldGenerator, boolean ignoreMalformed) {
        this.query = query;
        this.valueFetcher = valueFetcher;
        this.searchLookup = searchLookup;
        this.indexAnalyzer = indexAnalyzer;
        this.indexableFieldGenerator = indexableFieldGenerator;
        this.ignoreMalformed = ignoreMalformed;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.query.rewrite(indexSearcher);
        if (rewritten == this.query) {
            return this;
        }
        return new DerivedFieldQuery(rewritten, this.valueFetcher, this.searchLookup, this.indexAnalyzer, this.indexableFieldGenerator, this.ignoreMalformed);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(final LeafReaderContext context) {
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                DerivedFieldQuery.this.valueFetcher.setNextReader(context);
                final LeafSearchLookup leafSearchLookup = DerivedFieldQuery.this.searchLookup.getLeafSearchLookup(context);
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() {
                        List<IndexableField> indexableFields;
                        leafSearchLookup.source().setSegmentAndDocument(context, this.approximation.docID());
                        try {
                            indexableFields = DerivedFieldQuery.this.valueFetcher.getIndexableField(leafSearchLookup.source(), DerivedFieldQuery.this.indexableFieldGenerator);
                        }
                        catch (Exception e) {
                            if (DerivedFieldQuery.this.ignoreMalformed) {
                                return false;
                            }
                            throw e;
                        }
                        MemoryIndex memoryIndex = new MemoryIndex();
                        for (IndexableField indexableField : indexableFields) {
                            memoryIndex.addField(indexableField, DerivedFieldQuery.this.indexAnalyzer);
                        }
                        float score = memoryIndex.search(DerivedFieldQuery.this.query);
                        return score > 0.0f;
                    }

                    @Override
                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        DerivedFieldQuery other = (DerivedFieldQuery)o;
        return Objects.equals(this.query, other.query) && Objects.equals(this.indexAnalyzer, other.indexAnalyzer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.query, this.indexAnalyzer);
    }

    @Override
    public String toString(String f) {
        return "DerivedFieldQuery (Query: [ " + this.query.toString(f) + "])";
    }
}

