/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query.support;

import java.util.Deque;
import java.util.LinkedList;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ObjectMapper;

@PublicApi(since="1.0.0")
public final class NestedScope {
    private final Deque<ObjectMapper> levelStack = new LinkedList<ObjectMapper>();
    private final IndexSettings indexSettings;

    public NestedScope(IndexSettings indexSettings) {
        this.indexSettings = indexSettings;
    }

    public ObjectMapper getObjectMapper() {
        return this.levelStack.peek();
    }

    public ObjectMapper nextLevel(ObjectMapper level) {
        ObjectMapper previous = this.levelStack.peek();
        if (this.levelStack.size() >= this.indexSettings.getMaxNestedQueryDepth()) {
            throw new IllegalArgumentException("The depth of Nested Query is [" + (this.levelStack.size() + 1) + "] has exceeded the allowed maximum of [" + this.indexSettings.getMaxNestedQueryDepth() + "]. This maximum can be set by changing the [" + IndexSettings.MAX_NESTED_QUERY_DEPTH_SETTING.getKey() + "] index level setting.");
        }
        this.levelStack.push(level);
        return previous;
    }

    public ObjectMapper previousLevel() {
        return this.levelStack.pop();
    }
}

