/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.action.LatchedActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDs;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobPath;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.Index;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.IndexMetadataUploadListener;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteGlobalMetadataManager;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteStateTransferException;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteIndexPath;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreEnums;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreUtils;
import org.graylog.shaded.opensearch2.org.opensearch.node.Node;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.ConfigBlobStoreFormat;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

@ExperimentalApi
public class RemoteIndexPathUploader
extends IndexMetadataUploadListener {
    public static final String DELIMITER = "#";
    public static final ConfigBlobStoreFormat<RemoteIndexPath> REMOTE_INDEX_PATH_FORMAT = new ConfigBlobStoreFormat("remote_path_%s");
    private static final String TIMEOUT_EXCEPTION_MSG = "Timed out waiting while uploading remote index path file for indexes=%s";
    private static final String UPLOAD_EXCEPTION_MSG = "Exception occurred while uploading remote index paths for indexes=%s";
    static final String TRANSLOG_REPO_NAME_KEY = Node.NODE_ATTRIBUTES.getKey() + "remote_store.translog.repository";
    static final String SEGMENT_REPO_NAME_KEY = Node.NODE_ATTRIBUTES.getKey() + "remote_store.segment.repository";
    private static final Logger logger = LogManager.getLogger(RemoteIndexPathUploader.class);
    private final Settings settings;
    private final boolean isRemoteDataAttributePresent;
    private final boolean isTranslogSegmentRepoSame;
    private final Supplier<RepositoriesService> repositoriesService;
    private volatile TimeValue metadataUploadTimeout;
    private BlobStoreRepository translogRepository;
    private BlobStoreRepository segmentRepository;

    public RemoteIndexPathUploader(ThreadPool threadPool, Settings settings, Supplier<RepositoriesService> repositoriesService, ClusterSettings clusterSettings) {
        super(threadPool, "generic");
        this.settings = Objects.requireNonNull(settings);
        this.repositoriesService = Objects.requireNonNull(repositoriesService);
        this.isRemoteDataAttributePresent = RemoteStoreNodeAttribute.isRemoteDataAttributePresent(settings);
        this.isTranslogSegmentRepoSame = this.isTranslogSegmentRepoSame();
        Objects.requireNonNull(clusterSettings);
        this.metadataUploadTimeout = clusterSettings.get(RemoteGlobalMetadataManager.GLOBAL_METADATA_UPLOAD_TIMEOUT_SETTING);
        clusterSettings.addSettingsUpdateConsumer(RemoteGlobalMetadataManager.GLOBAL_METADATA_UPLOAD_TIMEOUT_SETTING, this::setMetadataUploadTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnUpload(List<IndexMetadata> indexMetadataList, Map<String, IndexMetadata> prevIndexMetadataByName, ActionListener<Void> actionListener) {
        RemoteStateTransferException ex;
        if (!this.isRemoteDataAttributePresent) {
            logger.trace("Skipping beforeNewIndexUpload as there are no remote indexes");
            actionListener.onResponse(null);
            return;
        }
        long startTime = System.nanoTime();
        boolean success = false;
        List eligibleList = indexMetadataList.stream().filter(idxMd -> this.requiresPathUpload((IndexMetadata)idxMd, (IndexMetadata)prevIndexMetadataByName.get(idxMd.getIndex().getName()))).collect(Collectors.toList());
        String indexNames = eligibleList.stream().map(IndexMetadata::getIndex).map(Index::toString).collect(Collectors.joining(","));
        int latchCount = eligibleList.size() * (this.isTranslogSegmentRepoSame ? 1 : 2);
        CountDownLatch latch = new CountDownLatch(latchCount);
        List<Exception> exceptionList = Collections.synchronizedList(new ArrayList(latchCount));
        try {
            RemoteStateTransferException ex2;
            for (IndexMetadata indexMetadata : eligibleList) {
                this.writeIndexPathAsync(indexMetadata, latch, exceptionList);
            }
            logger.trace((Message)new ParameterizedMessage("Remote index path upload started for {}", (Object)indexNames));
            try {
                if (!latch.await(this.metadataUploadTimeout.millis(), TimeUnit.MILLISECONDS)) {
                    ex2 = new RemoteStateTransferException(String.format(Locale.ROOT, TIMEOUT_EXCEPTION_MSG, indexNames));
                    exceptionList.forEach(ex2::addSuppressed);
                    actionListener.onFailure(ex2);
                    return;
                }
            }
            catch (InterruptedException exception) {
                exceptionList.forEach(exception::addSuppressed);
                ex = new RemoteStateTransferException(String.format(Locale.ROOT, TIMEOUT_EXCEPTION_MSG, indexNames), exception);
                actionListener.onFailure(ex);
                return;
            }
            if (exceptionList.size() > 0) {
                ex2 = new RemoteStateTransferException(String.format(Locale.ROOT, UPLOAD_EXCEPTION_MSG, indexNames));
                exceptionList.forEach(ex2::addSuppressed);
                actionListener.onFailure(ex2);
                return;
            }
            success = true;
            actionListener.onResponse(null);
        }
        catch (Exception exception) {
            ex = new RemoteStateTransferException(String.format(Locale.ROOT, UPLOAD_EXCEPTION_MSG, indexNames), exception);
            exceptionList.forEach(ex::addSuppressed);
            actionListener.onFailure(ex);
        }
        finally {
            long tookTimeNs = System.nanoTime() - startTime;
            logger.trace((Message)new ParameterizedMessage("executed beforeNewIndexUpload status={} tookTimeNs={}", (Object)success, (Object)tookTimeNs));
        }
    }

    private void writeIndexPathAsync(IndexMetadata idxMD, CountDownLatch latch, List<Exception> exceptionList) {
        if (this.isTranslogSegmentRepoSame) {
            this.writePathToRemoteStore(idxMD, this.translogRepository, latch, exceptionList, RemoteIndexPath.COMBINED_PATH);
        } else {
            this.writePathToRemoteStore(idxMD, this.translogRepository, latch, exceptionList, RemoteIndexPath.TRANSLOG_PATH);
            this.writePathToRemoteStore(idxMD, this.segmentRepository, latch, exceptionList, RemoteIndexPath.SEGMENT_PATH);
        }
    }

    private void writePathToRemoteStore(IndexMetadata idxMD, BlobStoreRepository repository, CountDownLatch latch, List<Exception> exceptionList, Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> pathCreationMap) {
        Map<String, String> remoteCustomData = idxMD.getCustomData("remote_store");
        RemoteStoreEnums.PathType pathType = RemoteStoreEnums.PathType.valueOf(remoteCustomData.get("path_type"));
        RemoteStoreEnums.PathHashAlgorithm hashAlgorithm = RemoteStoreEnums.PathHashAlgorithm.valueOf(remoteCustomData.get("path_hash_algorithm"));
        String indexUUID = idxMD.getIndexUUID();
        int shardCount = idxMD.getNumberOfShards();
        BlobPath basePath = repository.basePath();
        BlobContainer blobContainer = repository.blobStore().blobContainer(basePath.add("remote-index-path"));
        LatchedActionListener<Void> actionListener = this.getUploadPathLatchedActionListener(idxMD, latch, exceptionList, pathCreationMap);
        try {
            RemoteIndexPath remoteIndexPath = new RemoteIndexPath(indexUUID, shardCount, basePath, pathType, hashAlgorithm, pathCreationMap);
            String fileName = this.generateFileName(indexUUID, idxMD.getVersion(), remoteIndexPath.getVersion());
            REMOTE_INDEX_PATH_FORMAT.writeAsyncWithUrgentPriority(remoteIndexPath, blobContainer, fileName, actionListener);
        }
        catch (IOException ioException) {
            RemoteStateTransferException ex = new RemoteStateTransferException(String.format(Locale.ROOT, UPLOAD_EXCEPTION_MSG, List.of(idxMD.getIndex().getName())), ioException);
            actionListener.onFailure(ex);
        }
    }

    private Repository validateAndGetRepository(String repoSetting) {
        String repo = this.settings.get(repoSetting);
        assert (repo != null) : "Remote " + repoSetting + " repository is not configured";
        Repository repository = this.repositoriesService.get().repository(repo);
        assert (repository instanceof BlobStoreRepository) : "Repository should be instance of BlobStoreRepository";
        return repository;
    }

    public void start() {
        assert (RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled(this.settings)) : "Remote cluster state is not enabled";
        if (!this.isRemoteDataAttributePresent) {
            return;
        }
        this.translogRepository = (BlobStoreRepository)this.validateAndGetRepository(TRANSLOG_REPO_NAME_KEY);
        this.segmentRepository = (BlobStoreRepository)this.validateAndGetRepository(SEGMENT_REPO_NAME_KEY);
    }

    private boolean isTranslogSegmentRepoSame() {
        String translogRepoName = this.settings.get(TRANSLOG_REPO_NAME_KEY);
        String segmentRepoName = this.settings.get(SEGMENT_REPO_NAME_KEY);
        return Objects.equals(translogRepoName, segmentRepoName);
    }

    private LatchedActionListener<Void> getUploadPathLatchedActionListener(IndexMetadata indexMetadata, CountDownLatch latch, List<Exception> exceptionList, Map<RemoteStoreEnums.DataCategory, List<RemoteStoreEnums.DataType>> pathCreationMap) {
        return new LatchedActionListener<Void>(ActionListener.wrap(resp -> logger.trace((Message)new ParameterizedMessage("Index path uploaded for {} indexMetadata={}", (Object)pathCreationMap, (Object)indexMetadata)), ex -> {
            logger.error((Message)new ParameterizedMessage("Exception during Index path upload for {} indexMetadata={}", (Object)pathCreationMap, (Object)indexMetadata), (Throwable)ex);
            exceptionList.add((Exception)ex);
        }), latch);
    }

    private boolean requiresPathUpload(IndexMetadata indexMetadata, IndexMetadata prevIndexMetadata) {
        RemoteStoreEnums.PathType pathType = RemoteStoreUtils.determineRemoteStorePathStrategy(indexMetadata).getType();
        RemoteStoreEnums.PathType prevPathType = Objects.nonNull(prevIndexMetadata) ? RemoteStoreUtils.determineRemoteStorePathStrategy(prevIndexMetadata).getType() : null;
        return pathType == RemoteStoreEnums.PathType.HASHED_PREFIX && (Objects.isNull((Object)prevPathType) || prevPathType != RemoteStoreEnums.PathType.HASHED_PREFIX);
    }

    private void setMetadataUploadTimeout(TimeValue newIndexMetadataUploadTimeout) {
        this.metadataUploadTimeout = newIndexMetadataUploadTimeout;
    }

    private String generateFileName(String indexUUID, long indexMetadataVersion, String fileVersion) {
        return String.join((CharSequence)DELIMITER, indexUUID, Long.toString(indexMetadataVersion), fileVersion, UUIDs.randomBase64UUID());
    }
}

