/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreEnums;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStorePathStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.indices.RemoteStoreSettings;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;

@ExperimentalApi
public class RemoteStoreCustomMetadataResolver {
    private final RemoteStoreSettings remoteStoreSettings;
    private final Supplier<Version> minNodeVersionSupplier;
    private final Supplier<RepositoriesService> repositoriesServiceSupplier;
    private final Settings settings;

    public RemoteStoreCustomMetadataResolver(RemoteStoreSettings remoteStoreSettings, Supplier<Version> minNodeVersionSupplier, Supplier<RepositoriesService> repositoriesServiceSupplier, Settings settings) {
        this.remoteStoreSettings = remoteStoreSettings;
        this.minNodeVersionSupplier = minNodeVersionSupplier;
        this.repositoriesServiceSupplier = repositoriesServiceSupplier;
        this.settings = settings;
    }

    public RemoteStorePathStrategy getPathStrategy() {
        RemoteStoreEnums.PathType pathType = Version.V_2_14_0.compareTo(this.minNodeVersionSupplier.get()) <= 0 ? this.remoteStoreSettings.getPathType() : RemoteStoreEnums.PathType.FIXED;
        RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm = pathType == RemoteStoreEnums.PathType.FIXED ? null : this.remoteStoreSettings.getPathHashAlgorithm();
        return new RemoteStorePathStrategy(pathType, pathHashAlgorithm);
    }

    public boolean isTranslogMetadataEnabled() {
        Repository repository;
        try {
            repository = this.repositoriesServiceSupplier.get().repository(RemoteStoreNodeAttribute.getRemoteStoreTranslogRepo(this.settings));
        }
        catch (RepositoryMissingException ex) {
            throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", ex);
        }
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        return Version.V_2_15_0.compareTo(this.minNodeVersionSupplier.get()) <= 0 && this.remoteStoreSettings.isTranslogMetadataEnabled() && blobStoreRepository.blobStore().isBlobMetadataEnabled();
    }
}

