/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Counter;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.core.Assertions;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogReader;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogWriter;

@PublicApi(since="1.0.0")
public abstract class TranslogDeletionPolicy {
    private final Map<Object, RuntimeException> openTranslogRef;
    private final Map<Long, Counter> translogRefCounts = new HashMap<Long, Counter>();
    private long localCheckpointOfSafeCommit = -1L;

    public void assertNoOpenTranslogRefs() {
        if (this.openTranslogRef != null && !this.openTranslogRef.isEmpty()) {
            AssertionError e = new AssertionError((Object)"not all translog generations have been released");
            this.openTranslogRef.values().forEach(arg_0 -> e.addSuppressed(arg_0));
            throw e;
        }
    }

    public TranslogDeletionPolicy() {
        this.openTranslogRef = Assertions.ENABLED ? new ConcurrentHashMap<Object, RuntimeException>() : null;
    }

    public synchronized void setLocalCheckpointOfSafeCommit(long newCheckpoint) {
        if (newCheckpoint < this.localCheckpointOfSafeCommit) {
            throw new IllegalArgumentException("local checkpoint of the safe commit can't go backwards: current [" + this.localCheckpointOfSafeCommit + "] new [" + newCheckpoint + "]");
        }
        this.localCheckpointOfSafeCommit = newCheckpoint;
    }

    public abstract void setRetentionSizeInBytes(long var1);

    public abstract void setRetentionAgeInMillis(long var1);

    protected abstract void setRetentionTotalFiles(int var1);

    synchronized Releasable acquireTranslogGen(long translogGen) {
        this.translogRefCounts.computeIfAbsent(translogGen, l -> Counter.newCounter(false)).addAndGet(1L);
        AtomicBoolean closed = new AtomicBoolean();
        assert (this.assertAddTranslogRef(closed));
        return () -> {
            if (closed.compareAndSet(false, true)) {
                this.releaseTranslogGen(translogGen);
                assert (this.assertRemoveTranslogRef(closed));
            }
        };
    }

    private boolean assertAddTranslogRef(Object reference) {
        RuntimeException existing = this.openTranslogRef.put(reference, new RuntimeException());
        if (existing != null) {
            throw new AssertionError("double adding of closing reference", existing);
        }
        return true;
    }

    private boolean assertRemoveTranslogRef(Object reference) {
        return this.openTranslogRef.remove(reference) != null;
    }

    synchronized int pendingTranslogRefCount() {
        return this.translogRefCounts.size();
    }

    private synchronized void releaseTranslogGen(long translogGen) {
        Counter current = this.translogRefCounts.get(translogGen);
        if (current == null || current.get() <= 0L) {
            throw new IllegalArgumentException("translog gen [" + translogGen + "] wasn't acquired");
        }
        if (current.addAndGet(-1L) == 0L) {
            this.translogRefCounts.remove(translogGen);
        }
    }

    public abstract long minTranslogGenRequired(List<TranslogReader> var1, TranslogWriter var2) throws IOException;

    public static long getMinTranslogGenBySize(List<TranslogReader> readers, TranslogWriter writer, long retentionSizeInBytes) {
        if (retentionSizeInBytes >= 0L) {
            TranslogReader reader;
            long totalSize = writer.sizeInBytes();
            long minGen = writer.getGeneration();
            for (int i = readers.size() - 1; i >= 0 && totalSize < retentionSizeInBytes; totalSize += reader.sizeInBytes(), --i) {
                reader = readers.get(i);
                minGen = reader.getGeneration();
            }
            return minGen;
        }
        return Long.MIN_VALUE;
    }

    public static long getMinTranslogGenByAge(List<TranslogReader> readers, TranslogWriter writer, long maxRetentionAgeInMillis, long now) throws IOException {
        if (maxRetentionAgeInMillis >= 0L) {
            for (TranslogReader reader : readers) {
                if (now - reader.getLastModifiedTime() > maxRetentionAgeInMillis) continue;
                return reader.getGeneration();
            }
            return writer.getGeneration();
        }
        return Long.MIN_VALUE;
    }

    public static long getMinTranslogGenByTotalFiles(List<TranslogReader> readers, TranslogWriter writer, int maxTotalFiles) {
        long minGen = writer.generation;
        int totalFiles = 1;
        for (int i = readers.size() - 1; i >= 0 && totalFiles < maxTotalFiles; ++totalFiles, --i) {
            minGen = readers.get((int)i).generation;
        }
        return minGen;
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    protected long getMinTranslogGenRequiredByLocks() {
        return this.translogRefCounts.keySet().stream().reduce(Math::min).orElse(Long.MAX_VALUE);
    }

    public synchronized long getLocalCheckpointOfSafeCommit() {
        return this.localCheckpointOfSafeCommit;
    }

    synchronized long getTranslogRefCount(long gen) {
        Counter counter = this.translogRefCounts.get(gen);
        return counter == null ? 0L : counter.get();
    }
}

