/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;

public class FileSnapshot
implements Closeable {
    private final String name;
    @Nullable
    private final FileChannel fileChannel;
    @Nullable
    private Path path;
    @Nullable
    private byte[] content;

    private FileSnapshot(Path path) throws IOException {
        Objects.requireNonNull(path);
        this.name = path.getFileName().toString();
        this.path = path;
        this.fileChannel = FileChannel.open(path, StandardOpenOption.READ);
    }

    private FileSnapshot(String name, byte[] content) {
        Objects.requireNonNull(name);
        this.name = name;
        this.content = content;
        this.fileChannel = null;
    }

    public Path getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public long getContentLength() throws IOException {
        return this.fileChannel == null ? (long)this.content.length : this.fileChannel.size();
    }

    public InputStream inputStream() throws IOException {
        return this.fileChannel != null ? new BufferedInputStream(Channels.newInputStream(this.fileChannel)) : new InputStreamIndexInput(new ByteArrayIndexInput(this.name, this.content), this.content.length);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.content, this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSnapshot other = (FileSnapshot)o;
        return Objects.equals(this.name, other.name) && Arrays.equals(this.content, other.content) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        return "FileInfo [" + " name = " + this.name + ", path = " + this.path.toUri() + "]";
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.fileChannel);
    }

    public static final class CheckpointFileSnapshot
    extends TransferFileSnapshot {
        private final long generation;
        private final long minTranslogGeneration;

        public CheckpointFileSnapshot(long primaryTerm, long generation, long minTranslogGeneration, Path path, Long checksum) throws IOException {
            super(path, primaryTerm, checksum);
            this.minTranslogGeneration = minTranslogGeneration;
            this.generation = generation;
        }

        public long getGeneration() {
            return this.generation;
        }

        public long getMinTranslogGeneration() {
            return this.minTranslogGeneration;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.generation, this.minTranslogGeneration, super.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                if (this == o) {
                    return true;
                }
                if (this.getClass() != o.getClass()) {
                    return false;
                }
                CheckpointFileSnapshot other = (CheckpointFileSnapshot)o;
                return Objects.equals(this.minTranslogGeneration, other.minTranslogGeneration) && Objects.equals(this.generation, other.generation);
            }
            return false;
        }
    }

    public static final class TranslogFileSnapshot
    extends TransferFileSnapshot {
        private final long generation;

        public TranslogFileSnapshot(long primaryTerm, long generation, Path path, Long checksum) throws IOException {
            super(path, primaryTerm, checksum);
            this.generation = generation;
        }

        public long getGeneration() {
            return this.generation;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.generation, super.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                if (this == o) {
                    return true;
                }
                if (this.getClass() != o.getClass()) {
                    return false;
                }
                TranslogFileSnapshot other = (TranslogFileSnapshot)o;
                return Objects.equals(this.generation, other.generation);
            }
            return false;
        }
    }

    public static class TransferFileSnapshot
    extends FileSnapshot {
        private final long primaryTerm;
        private Long checksum;
        @Nullable
        private InputStream metadataFileInputStream;

        public TransferFileSnapshot(Path path, long primaryTerm, Long checksum) throws IOException {
            super(path);
            this.primaryTerm = primaryTerm;
            this.checksum = checksum;
        }

        public TransferFileSnapshot(String name, byte[] content, long primaryTerm) throws IOException {
            super(name, content);
            this.primaryTerm = primaryTerm;
        }

        public Long getChecksum() {
            return this.checksum;
        }

        public long getPrimaryTerm() {
            return this.primaryTerm;
        }

        public void setMetadataFileInputStream(InputStream inputStream) {
            this.metadataFileInputStream = inputStream;
        }

        public InputStream getMetadataFileInputStream() {
            return this.metadataFileInputStream;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.primaryTerm, super.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                if (this == o) {
                    return true;
                }
                if (this.getClass() != o.getClass()) {
                    return false;
                }
                TransferFileSnapshot other = (TransferFileSnapshot)o;
                return Objects.equals(this.primaryTerm, other.primaryTerm);
            }
            return false;
        }
    }
}

