/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreUtils;

public class TranslogTransferMetadata {
    private final long primaryTerm;
    private final long generation;
    private final long minTranslogGeneration;
    private final int count;
    private final SetOnce<Map<String, String>> generationToPrimaryTermMapper = new SetOnce();
    public static final String METADATA_SEPARATOR = "__";
    public static final String METADATA_PREFIX = "metadata";
    static final int BUFFER_SIZE = 4096;
    static final int CURRENT_VERSION = 1;
    static final String METADATA_CODEC = "md";
    private final long createdAt;
    private final String nodeId;

    public TranslogTransferMetadata(long primaryTerm, long generation, long minTranslogGeneration, int count, String nodeId) {
        this.primaryTerm = primaryTerm;
        this.generation = generation;
        this.minTranslogGeneration = minTranslogGeneration;
        this.count = count;
        this.createdAt = System.currentTimeMillis();
        this.nodeId = nodeId;
    }

    public TranslogTransferMetadata(long primaryTerm, long generation, long minTranslogGeneration, int count) {
        this(primaryTerm, generation, minTranslogGeneration, count, "");
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getMinTranslogGeneration() {
        return this.minTranslogGeneration;
    }

    public int getCount() {
        return this.count;
    }

    public void setGenerationToPrimaryTermMapper(Map<String, String> generationToPrimaryTermMap) {
        this.generationToPrimaryTermMapper.set(generationToPrimaryTermMap);
    }

    public Map<String, String> getGenerationToPrimaryTermMapper() {
        return this.generationToPrimaryTermMapper.get();
    }

    public String getFileName() {
        return String.join((CharSequence)METADATA_SEPARATOR, Arrays.asList(METADATA_PREFIX, RemoteStoreUtils.invertLong(this.primaryTerm), RemoteStoreUtils.invertLong(this.generation), RemoteStoreUtils.invertLong(this.createdAt), String.valueOf(Objects.hash(this.nodeId)), String.valueOf(1)));
    }

    public static Tuple<Tuple<Long, Long>, String> getNodeIdByPrimaryTermAndGeneration(String filename) {
        String[] tokens = filename.split(METADATA_SEPARATOR);
        if (tokens.length < 6) {
            return null;
        }
        return new Tuple<Tuple<Long, Long>, String>(new Tuple<Long, Long>(RemoteStoreUtils.invertLong(tokens[1]), RemoteStoreUtils.invertLong(tokens[2])), tokens[4]);
    }

    public static Tuple<String, String> getNodeIdByPrimaryTermAndGen(String filename) {
        String[] tokens = filename.split(METADATA_SEPARATOR);
        if (tokens.length < 6) {
            return null;
        }
        String primaryTermAndGen = String.join((CharSequence)METADATA_SEPARATOR, tokens[1], tokens[2]);
        String nodeId = tokens[4];
        return new Tuple<String, String>(primaryTermAndGen, nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.primaryTerm, this.generation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslogTransferMetadata other = (TranslogTransferMetadata)o;
        return Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.generation, other.generation);
    }
}

