/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover.Condition;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover.MaxAgeCondition;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover.MaxDocsCondition;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover.MaxSizeCondition;
import org.graylog.shaded.opensearch2.org.opensearch.action.resync.TransportResyncReplicationAction;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.AbstractModule;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.index.SegmentReplicationPressureService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.BinaryFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.BooleanFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.CompletionFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ConstantKeywordFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DataStreamFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DateFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DerivedFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DocCountFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldAliasMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldNamesFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FlatObjectFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.GeoPointFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.IdFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.IgnoredFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.IndexFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.IpFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.KeywordFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MatchOnlyTextFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.NestedPathFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.NumberFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ObjectMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.RangeType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.RoutingFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SeqNoFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.VersionFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.WildcardFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStorePressureService;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.GlobalCheckpointSyncAction;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeaseBackgroundSyncAction;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeaseSyncAction;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeaseSyncer;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.PrimaryReplicaSyncer;
import org.graylog.shaded.opensearch2.org.opensearch.indices.cluster.IndicesClusterStateService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.mapper.MapperRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.IndicesStore;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.TransportNodesListShardStoreMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.TransportNodesListShardStoreMetadataBatch;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.MapperPlugin;

public class IndicesModule
extends AbstractModule {
    private final List<NamedWriteableRegistry.Entry> namedWritables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final MapperRegistry mapperRegistry;
    private static final Map<String, MetadataFieldMapper.TypeParser> builtInMetadataMappers = IndicesModule.initBuiltInMetadataMappers();
    private static Set<String> builtInMetadataFields = Collections.unmodifiableSet(builtInMetadataMappers.keySet());

    public IndicesModule(List<MapperPlugin> mapperPlugins) {
        this.mapperRegistry = new MapperRegistry(IndicesModule.getMappers(mapperPlugins), IndicesModule.getMetadataMappers(mapperPlugins), IndicesModule.getFieldFilter(mapperPlugins));
        this.registerBuiltinWritables();
    }

    private void registerBuiltinWritables() {
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_age", MaxAgeCondition::new));
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_docs", MaxDocsCondition::new));
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_size", MaxSizeCondition::new));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWritables;
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContents() {
        return Arrays.asList(new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_age", new String[0]), (p, c) -> MaxAgeCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_docs", new String[0]), (p, c) -> MaxDocsCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_size", new String[0]), (p, c) -> MaxSizeCondition.fromXContent(p)));
    }

    public static Map<String, Mapper.TypeParser> getMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, Mapper.TypeParser> mappers = new LinkedHashMap<String, Mapper.TypeParser>();
        for (NumberFieldMapper.NumberType numberType : NumberFieldMapper.NumberType.values()) {
            mappers.put(numberType.typeName(), numberType.parser());
        }
        for (Enum enum_ : RangeType.values()) {
            mappers.put(((RangeType)enum_).typeName(), ((RangeType)enum_).parser());
        }
        mappers.put("boolean", BooleanFieldMapper.PARSER);
        mappers.put("binary", BinaryFieldMapper.PARSER);
        DateFieldMapper.Resolution milliseconds = DateFieldMapper.Resolution.MILLISECONDS;
        mappers.put(milliseconds.type(), DateFieldMapper.MILLIS_PARSER);
        DateFieldMapper.Resolution nanoseconds = DateFieldMapper.Resolution.NANOSECONDS;
        mappers.put(nanoseconds.type(), DateFieldMapper.NANOS_PARSER);
        mappers.put("ip", IpFieldMapper.PARSER);
        mappers.put("text", TextFieldMapper.PARSER);
        mappers.put("match_only_text", MatchOnlyTextFieldMapper.PARSER);
        mappers.put("keyword", KeywordFieldMapper.PARSER);
        mappers.put("object", new ObjectMapper.TypeParser());
        mappers.put("nested", new ObjectMapper.TypeParser());
        mappers.put("completion", CompletionFieldMapper.PARSER);
        mappers.put("alias", new FieldAliasMapper.TypeParser());
        mappers.put("geo_point", new GeoPointFieldMapper.TypeParser());
        mappers.put("flat_object", FlatObjectFieldMapper.PARSER);
        mappers.put("constant_keyword", new ConstantKeywordFieldMapper.TypeParser());
        mappers.put("derived", DerivedFieldMapper.PARSER);
        mappers.put("wildcard", WildcardFieldMapper.PARSER);
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, Mapper.TypeParser> entry : mapperPlugin.getMappers().entrySet()) {
                if (mappers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Mapper [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(mappers);
    }

    private static Map<String, MetadataFieldMapper.TypeParser> initBuiltInMetadataMappers() {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> builtInMetadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        builtInMetadataMappers.put("_ignored", IgnoredFieldMapper.PARSER);
        builtInMetadataMappers.put("_id", IdFieldMapper.PARSER);
        builtInMetadataMappers.put("_routing", RoutingFieldMapper.PARSER);
        builtInMetadataMappers.put("_index", IndexFieldMapper.PARSER);
        builtInMetadataMappers.put("_data_stream_timestamp", DataStreamFieldMapper.PARSER);
        builtInMetadataMappers.put("_source", SourceFieldMapper.PARSER);
        builtInMetadataMappers.put("_nested_path", NestedPathFieldMapper.PARSER);
        builtInMetadataMappers.put("_version", VersionFieldMapper.PARSER);
        builtInMetadataMappers.put("_seq_no", SeqNoFieldMapper.PARSER);
        builtInMetadataMappers.put("_doc_count", DocCountFieldMapper.PARSER);
        builtInMetadataMappers.put("_field_names", FieldNamesFieldMapper.PARSER);
        return Collections.unmodifiableMap(builtInMetadataMappers);
    }

    public static Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        int i = 0;
        Map.Entry<String, MetadataFieldMapper.TypeParser> fieldNamesEntry = null;
        for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : builtInMetadataMappers.entrySet()) {
            if (i < builtInMetadataMappers.size() - 1) {
                metadataMappers.put(entry.getKey(), entry.getValue());
            } else {
                assert (entry.getKey().equals("_field_names")) : "_field_names must be the last registered mapper, order counts";
                fieldNamesEntry = entry;
            }
            ++i;
        }
        assert (fieldNamesEntry != null);
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : mapperPlugin.getMetadataMappers().entrySet()) {
                if (entry.getKey().equals("_field_names")) {
                    throw new IllegalArgumentException("Plugin cannot contain metadata mapper [_field_names]");
                }
                if (metadataMappers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("MetadataFieldMapper [" + entry.getKey() + "] is already registered");
            }
        }
        metadataMappers.put((String)fieldNamesEntry.getKey(), fieldNamesEntry.getValue());
        return Collections.unmodifiableMap(metadataMappers);
    }

    public static Set<String> getBuiltInMetadataFields() {
        return builtInMetadataFields;
    }

    private static Function<String, Predicate<String>> getFieldFilter(List<MapperPlugin> mapperPlugins) {
        Function<String, Predicate<String>> fieldFilter = MapperPlugin.NOOP_FIELD_FILTER;
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            fieldFilter = IndicesModule.and(fieldFilter, mapperPlugin.getFieldFilter());
        }
        return fieldFilter;
    }

    private static Function<String, Predicate<String>> and(Function<String, Predicate<String>> first, Function<String, Predicate<String>> second) {
        if (first == MapperPlugin.NOOP_FIELD_FILTER) {
            return second;
        }
        if (second == MapperPlugin.NOOP_FIELD_FILTER) {
            return first;
        }
        return index -> {
            Predicate firstPredicate = (Predicate)first.apply((String)index);
            Predicate secondPredicate = (Predicate)second.apply((String)index);
            if (firstPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
                return secondPredicate;
            }
            if (secondPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
                return firstPredicate;
            }
            return firstPredicate.and(secondPredicate);
        };
    }

    @Override
    protected void configure() {
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetadata.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetadataBatch.class).asEagerSingleton();
        this.bind(GlobalCheckpointSyncAction.class).asEagerSingleton();
        this.bind(TransportResyncReplicationAction.class).asEagerSingleton();
        this.bind(PrimaryReplicaSyncer.class).asEagerSingleton();
        this.bind(RetentionLeaseSyncAction.class).asEagerSingleton();
        this.bind(RetentionLeaseBackgroundSyncAction.class).asEagerSingleton();
        this.bind(RetentionLeaseSyncer.class).asEagerSingleton();
        this.bind(SegmentReplicationCheckpointPublisher.class).asEagerSingleton();
        this.bind(SegmentReplicationPressureService.class).asEagerSingleton();
        this.bind(RemoteStorePressureService.class).asEagerSingleton();
    }

    public MapperRegistry getMapperRegistry() {
        return this.mapperRegistry;
    }
}

