/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.recovery;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;

public abstract class RecoveryTransportRequest
extends TransportRequest {
    private final long requestSeqNo;

    RecoveryTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.requestSeqNo = in.getVersion().onOrAfter(LegacyESVersion.V_7_9_0) ? in.readLong() : -2L;
    }

    RecoveryTransportRequest(long requestSeqNo) {
        this.requestSeqNo = requestSeqNo;
    }

    public long requestSeqNo() {
        return this.requestSeqNo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_9_0)) {
            out.writeLong(this.requestSeqNo);
        }
    }
}

