/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.FileChunkWriter;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoverySettings;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.CheckpointInfoRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.GetSegmentFilesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationSourceHandler;

class OngoingSegmentReplications {
    private static final Logger logger = LogManager.getLogger(OngoingSegmentReplications.class);
    private final RecoverySettings recoverySettings;
    private final IndicesService indicesService;
    private final Map<String, SegmentReplicationSourceHandler> allocationIdToHandlers;

    OngoingSegmentReplications(IndicesService indicesService, RecoverySettings recoverySettings) {
        this.indicesService = indicesService;
        this.recoverySettings = recoverySettings;
        this.allocationIdToHandlers = ConcurrentCollections.newConcurrentMap();
    }

    void startSegmentCopy(GetSegmentFilesRequest request, ActionListener<GetSegmentFilesResponse> listener) {
        SegmentReplicationSourceHandler handler = this.allocationIdToHandlers.get(request.getTargetAllocationId());
        if (handler != null) {
            if (handler.isReplicating()) {
                throw new OpenSearchException("Replication to shard {}, on node {} has already started", request.getCheckpoint().getShardId(), request.getTargetNode());
            }
            ActionListener<GetSegmentFilesResponse> wrappedListener = ActionListener.runBefore(listener, () -> this.allocationIdToHandlers.remove(request.getTargetAllocationId()));
            handler.sendFiles(request, wrappedListener);
        } else {
            listener.onResponse(new GetSegmentFilesResponse(Collections.emptyList()));
        }
    }

    SegmentReplicationSourceHandler prepareForReplication(CheckpointInfoRequest request, FileChunkWriter fileChunkWriter) {
        return this.allocationIdToHandlers.computeIfAbsent(request.getTargetAllocationId(), aId -> {
            try {
                ShardId shardId = request.getCheckpoint().getShardId();
                IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
                IndexShard indexShard = indexService.getShard(shardId.id());
                return new SegmentReplicationSourceHandler(request.getTargetNode(), fileChunkWriter, indexShard, request.getTargetAllocationId(), Math.toIntExact(this.recoverySettings.getChunkSize().getBytes()), this.recoverySettings.getMaxConcurrentFileChunks());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error creating replication handler", e);
            }
        });
    }

    void cancel(IndexShard shard, String reason) {
        this.cancelHandlers(handler -> handler.shardId().equals(shard.shardId()), reason);
    }

    void cancel(String allocationId, String reason) {
        SegmentReplicationSourceHandler handler = this.allocationIdToHandlers.remove(allocationId);
        if (handler != null) {
            handler.cancel(reason);
        }
    }

    void cancelReplication(DiscoveryNode node) {
        this.cancelHandlers(handler -> handler.getTargetNode().equals(node), "Node left");
    }

    int size() {
        return this.allocationIdToHandlers.size();
    }

    Map<String, SegmentReplicationSourceHandler> getHandlers() {
        return this.allocationIdToHandlers;
    }

    void clearOutOfSyncIds(ShardId shardId, Set<String> inSyncAllocationIds) {
        this.cancelHandlers(handler -> handler.shardId().equals(shardId) && !inSyncAllocationIds.contains(handler.getAllocationId()), "Shard is no longer in-sync with the primary");
    }

    private void cancelHandlers(Predicate<? super SegmentReplicationSourceHandler> predicate, String reason) {
        List allocationIds = this.allocationIdToHandlers.values().stream().filter(predicate).map(SegmentReplicationSourceHandler::getAllocationId).collect(Collectors.toList());
        if (allocationIds.size() == 0) {
            return;
        }
        logger.warn(() -> new ParameterizedMessage("Cancelling replications for allocationIds {}", (Object)allocationIds));
        for (String allocationId : allocationIds) {
            this.cancel(allocationId, reason);
        }
    }
}

