/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.util.List;
import java.util.function.BiConsumer;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListenerResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoverySettings;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.CheckpointInfoRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.CheckpointInfoResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.GetSegmentFilesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationSource;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class PrimaryShardReplicationSource
implements SegmentReplicationSource {
    private final TransportService transportService;
    private final DiscoveryNode sourceNode;
    private final DiscoveryNode targetNode;
    private final String targetAllocationId;
    private final RecoverySettings recoverySettings;

    public PrimaryShardReplicationSource(DiscoveryNode targetNode, String targetAllocationId, TransportService transportService, RecoverySettings recoverySettings, DiscoveryNode sourceNode) {
        this.targetAllocationId = targetAllocationId;
        this.transportService = transportService;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
    }

    @Override
    public void getCheckpointMetadata(long replicationId, ReplicationCheckpoint checkpoint, ActionListener<CheckpointInfoResponse> listener) {
        CheckpointInfoRequest request = new CheckpointInfoRequest(replicationId, this.targetAllocationId, this.targetNode, checkpoint);
        this.transportService.sendRequest(this.sourceNode, "internal:index/shard/replication/get_checkpoint_info", (TransportRequest)request, TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionRetryTimeout()).build(), new ActionListenerResponseHandler<CheckpointInfoResponse>(listener, CheckpointInfoResponse::new, "generic"));
    }

    @Override
    public void getSegmentFiles(long replicationId, ReplicationCheckpoint checkpoint, List<StoreFileMetadata> filesToFetch, IndexShard indexShard, BiConsumer<String, Long> fileProgressTracker, ActionListener<GetSegmentFilesResponse> listener) {
        GetSegmentFilesRequest request = new GetSegmentFilesRequest(replicationId, this.targetAllocationId, this.targetNode, filesToFetch, checkpoint);
        this.transportService.sendRequest(this.sourceNode, "internal:index/shard/replication/get_segment_files", (TransportRequest)request, TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build(), new ActionListenerResponseHandler<GetSegmentFilesResponse>(listener, GetSegmentFilesResponse::new, "generic"));
    }

    @Override
    public String getDescription() {
        return this.sourceNode.getName();
    }
}

