/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteBuffersDataOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteBuffersIndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.concurrent.GatedCloseable;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

public class CopyState
implements Closeable {
    private final GatedCloseable<SegmentInfos> segmentInfosRef;
    private final ReplicationCheckpoint replicationCheckpoint;
    private final byte[] infosBytes;
    private final IndexShard shard;

    public CopyState(IndexShard shard) throws IOException {
        this.shard = shard;
        Tuple<GatedCloseable<SegmentInfos>, ReplicationCheckpoint> latestSegmentInfosAndCheckpoint = shard.getLatestSegmentInfosAndCheckpoint();
        this.segmentInfosRef = latestSegmentInfosAndCheckpoint.v1();
        this.replicationCheckpoint = latestSegmentInfosAndCheckpoint.v2();
        SegmentInfos segmentInfos = this.segmentInfosRef.get();
        ByteBuffersDataOutput buffer = new ByteBuffersDataOutput();
        try (ByteBuffersIndexOutput indexOutput = new ByteBuffersIndexOutput(buffer, "", null);){
            segmentInfos.write(indexOutput);
        }
        this.infosBytes = buffer.toArrayCopy();
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.replicationCheckpoint;
    }

    public Map<String, StoreFileMetadata> getMetadataMap() {
        return this.replicationCheckpoint.getMetadataMap();
    }

    public byte[] getInfosBytes() {
        return this.infosBytes;
    }

    public IndexShard getShard() {
        return this.shard;
    }

    @Override
    public void close() throws IOException {
        try {
            this.segmentInfosRef.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

