/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.store;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionType;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.env.NodeEnvironment;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.AsyncShardFetch;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.ShardAttributes;
import org.graylog.shaded.opensearch2.org.opensearch.indices.store.TransportNodesListShardStoreMetadataHelper;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportNodesListShardStoreMetadata
extends TransportNodesAction<Request, NodesStoreFilesMetadata, NodeRequest, NodeStoreFilesMetadata>
implements AsyncShardFetch.Lister<NodesStoreFilesMetadata, NodeStoreFilesMetadata> {
    public static final String ACTION_NAME = "internal:cluster/nodes/indices/shard/store";
    public static final ActionType<NodesStoreFilesMetadata> TYPE = new ActionType<NodesStoreFilesMetadata>("internal:cluster/nodes/indices/shard/store", NodesStoreFilesMetadata::new);
    private final Settings settings;
    private final IndicesService indicesService;
    private final NodeEnvironment nodeEnv;

    @Inject
    public TransportNodesListShardStoreMetadata(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, NodeEnvironment nodeEnv, ActionFilters actionFilters) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "fetch_shard_store", NodeStoreFilesMetadata.class);
        this.settings = settings;
        this.indicesService = indicesService;
        this.nodeEnv = nodeEnv;
    }

    @Override
    public void list(Map<ShardId, ShardAttributes> shardAttributes, DiscoveryNode[] nodes, ActionListener<NodesStoreFilesMetadata> listener) {
        assert (shardAttributes.size() == 1) : "only one shard should be specified";
        ShardId shardId = shardAttributes.keySet().iterator().next();
        String customDataPath = shardAttributes.get(shardId).getCustomDataPath();
        this.execute(new Request(shardId, customDataPath, nodes), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeStoreFilesMetadata newNodeResponse(StreamInput in) throws IOException {
        return new NodeStoreFilesMetadata(in);
    }

    @Override
    protected NodesStoreFilesMetadata newResponse(Request request, List<NodeStoreFilesMetadata> responses, List<FailedNodeException> failures) {
        return new NodesStoreFilesMetadata(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeStoreFilesMetadata nodeOperation(NodeRequest request) {
        try {
            return new NodeStoreFilesMetadata(this.clusterService.localNode(), this.listStoreMetadata(request));
        }
        catch (IOException e) {
            throw new OpenSearchException("Failed to list store metadata for shard [" + String.valueOf(request.shardId) + "]", (Throwable)e, new Object[0]);
        }
    }

    private TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata listStoreMetadata(NodeRequest request) throws IOException {
        ShardId shardId = request.getShardId();
        return TransportNodesListShardStoreMetadataHelper.listShardMetadataInternal(this.logger, shardId, this.nodeEnv, this.indicesService, request.getCustomDataPath(), this.settings, this.clusterService);
    }

    public static class NodeStoreFilesMetadata
    extends BaseNodeResponse {
        private TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata;

        public NodeStoreFilesMetadata(StreamInput in) throws IOException {
            super(in);
            this.storeFilesMetadata = new TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata(in);
        }

        public NodeStoreFilesMetadata(DiscoveryNode node, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata) {
            super(node);
            this.storeFilesMetadata = storeFilesMetadata;
        }

        public TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata() {
            return this.storeFilesMetadata;
        }

        public static NodeStoreFilesMetadata readListShardStoreNodeOperationResponse(StreamInput in) throws IOException {
            return new NodeStoreFilesMetadata(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.storeFilesMetadata.writeTo(out);
        }

        public String toString() {
            return "[[" + String.valueOf(this.getNode()) + "][" + String.valueOf(this.storeFilesMetadata) + "]]";
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public Request(ShardId shardId, String customDataPath, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = Objects.requireNonNull(shardId);
            this.customDataPath = Objects.requireNonNull(customDataPath);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.customDataPath);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public NodeRequest(Request request) {
            this.shardId = Objects.requireNonNull(request.shardId());
            this.customDataPath = Objects.requireNonNull(request.getCustomDataPath());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            assert (this.customDataPath != null);
            out.writeString(this.customDataPath);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }
    }

    public static class NodesStoreFilesMetadata
    extends BaseNodesResponse<NodeStoreFilesMetadata> {
        public NodesStoreFilesMetadata(StreamInput in) throws IOException {
            super(in);
        }

        public NodesStoreFilesMetadata(ClusterName clusterName, List<NodeStoreFilesMetadata> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeStoreFilesMetadata> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeStoreFilesMetadata::readListShardStoreNodeOperationResponse);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeStoreFilesMetadata> nodes) throws IOException {
            out.writeList(nodes);
        }
    }
}

