/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node;

import java.io.IOException;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class IoUsageStats
implements Writeable,
ToXContentFragment {
    private double ioUtilisationPercent;

    public IoUsageStats(double ioUtilisationPercent) {
        this.ioUtilisationPercent = ioUtilisationPercent;
    }

    public IoUsageStats(StreamInput in) throws IOException {
        this.ioUtilisationPercent = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.ioUtilisationPercent);
    }

    public double getIoUtilisationPercent() {
        return this.ioUtilisationPercent;
    }

    public void setIoUtilisationPercent(double ioUtilisationPercent) {
        this.ioUtilisationPercent = ioUtilisationPercent;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("max_io_utilization_percent", String.format(Locale.ROOT, "%.1f", this.ioUtilisationPercent));
        return builder.endObject();
    }

    public String toString() {
        return "IO utilization percent: " + String.format(Locale.ROOT, "%.1f", this.ioUtilisationPercent);
    }
}

