/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeResourceUsageStats;

public class NodesResourceUsageStats
implements Writeable,
ToXContentFragment {
    private final Map<String, NodeResourceUsageStats> nodeIdToResourceUsageStatsMap;

    public NodesResourceUsageStats(Map<String, NodeResourceUsageStats> nodeIdToResourceUsageStatsMap) {
        this.nodeIdToResourceUsageStatsMap = nodeIdToResourceUsageStatsMap;
    }

    public NodesResourceUsageStats(StreamInput in) throws IOException {
        this.nodeIdToResourceUsageStatsMap = in.readMap(StreamInput::readString, NodeResourceUsageStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.nodeIdToResourceUsageStatsMap, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
    }

    public Map<String, NodeResourceUsageStats> getNodeIdToResourceUsageStatsMap() {
        return this.nodeIdToResourceUsageStatsMap;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("resource_usage_stats");
        for (String nodeId : this.nodeIdToResourceUsageStatsMap.keySet()) {
            builder.startObject(nodeId);
            NodeResourceUsageStats resourceUsageStats = this.nodeIdToResourceUsageStatsMap.get(nodeId);
            if (resourceUsageStats != null) {
                builder.field("timestamp", resourceUsageStats.timestamp);
                builder.field("cpu_utilization_percent", String.format(Locale.ROOT, "%.1f", resourceUsageStats.cpuUtilizationPercent));
                builder.field("memory_utilization_percent", String.format(Locale.ROOT, "%.1f", resourceUsageStats.memoryUtilizationPercent));
                if (resourceUsageStats.getIoUsageStats() != null) {
                    builder.field("io_usage_stats", resourceUsageStats.getIoUsageStats());
                }
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

