/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonFactory;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.json.JsonReadFeature;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.JarHell;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.json.JsonXContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.semver.SemverRange;

@PublicApi(since="1.0.0")
public class PluginInfo
implements Writeable,
ToXContentObject {
    public static final String OPENSEARCH_PLUGIN_PROPERTIES = "plugin-descriptor.properties";
    public static final String OPENSEARCH_PLUGIN_POLICY = "plugin-security.policy";
    private static final JsonFactory jsonFactory = new JsonFactory().configure(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES.mappedFeature(), true);
    private final String name;
    private final String description;
    private final String version;
    private final List<SemverRange> opensearchVersionRanges;
    private final String javaVersion;
    private final String classname;
    private final String customFolderName;
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;

    public PluginInfo(String name, String description, String version, Version opensearchVersion, String javaVersion, String classname, String customFolderName, List<String> extendedPlugins, boolean hasNativeController) {
        this(name, description, version, List.of(SemverRange.fromString(opensearchVersion.toString())), javaVersion, classname, customFolderName, extendedPlugins, hasNativeController);
    }

    public PluginInfo(String name, String description, String version, List<SemverRange> opensearchVersionRanges, String javaVersion, String classname, String customFolderName, List<String> extendedPlugins, boolean hasNativeController) {
        this.name = name;
        this.description = description;
        this.version = version;
        if (opensearchVersionRanges.size() != 1) {
            throw new IllegalArgumentException("Exactly one range is allowed to be specified in dependencies for the plugin [" + name + "]");
        }
        this.opensearchVersionRanges = opensearchVersionRanges;
        this.javaVersion = javaVersion;
        this.classname = classname;
        this.customFolderName = customFolderName;
        this.extendedPlugins = Collections.unmodifiableList(extendedPlugins);
        this.hasNativeController = hasNativeController;
    }

    public PluginInfo(String name, String description, String version, Version opensearchVersion, String javaVersion, String classname, List<String> extendedPlugins, boolean hasNativeController) {
        this(name, description, version, opensearchVersion, javaVersion, classname, null, extendedPlugins, hasNativeController);
    }

    public PluginInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readString();
        this.version = in.readString();
        this.opensearchVersionRanges = in.getVersion().onOrAfter(Version.V_2_13_0) ? (List<Object>)in.readGenericValue() : List.of(new SemverRange(in.readVersion(), SemverRange.RangeOperator.DEFAULT));
        this.javaVersion = in.readString();
        this.classname = in.readString();
        this.customFolderName = in.getVersion().onOrAfter(Version.V_1_1_0) ? in.readString() : this.name;
        this.extendedPlugins = in.readStringList();
        this.hasNativeController = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.version);
        if (out.getVersion().onOrAfter(Version.V_2_13_0)) {
            out.writeGenericValue(this.opensearchVersionRanges);
        } else {
            out.writeVersion(this.opensearchVersionRanges.get(0).getRangeVersion());
        }
        out.writeString(this.javaVersion);
        out.writeString(this.classname);
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            if (this.customFolderName != null) {
                out.writeString(this.customFolderName);
            } else {
                out.writeString(this.name);
            }
        }
        out.writeStringCollection(this.extendedPlugins);
        out.writeBoolean(this.hasNativeController);
    }

    public static PluginInfo readFromProperties(Path path) throws IOException {
        boolean hasNativeController;
        String customFolderNameValue;
        Path descriptor = path.resolve(OPENSEARCH_PLUGIN_PROPERTIES);
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        Map propsMap = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        String name = propsMap.remove("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("property [name] is missing in [" + String.valueOf(descriptor) + "]");
        }
        String description = propsMap.remove("description");
        if (description == null) {
            throw new IllegalArgumentException("property [description] is missing for plugin [" + name + "]");
        }
        String version = propsMap.remove("version");
        if (version == null) {
            throw new IllegalArgumentException("property [version] is missing for plugin [" + name + "]");
        }
        String opensearchVersionString = propsMap.remove("opensearch.version");
        String dependenciesValue = propsMap.remove("dependencies");
        if (opensearchVersionString == null && dependenciesValue == null) {
            throw new IllegalArgumentException("Either [opensearch.version] or [dependencies] property must be specified for the plugin [" + name + "]");
        }
        if (opensearchVersionString != null && dependenciesValue != null) {
            throw new IllegalArgumentException("Only one of [opensearch.version] or [dependencies] property can be specified for the plugin [" + name + "]");
        }
        ArrayList<SemverRange> opensearchVersionRanges = new ArrayList<SemverRange>();
        if (opensearchVersionString != null) {
            opensearchVersionRanges.add(SemverRange.fromString(opensearchVersionString));
        } else {
            Map<String, String> dependenciesMap;
            try (JsonXContentParser parser = new JsonXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, jsonFactory.createParser(dependenciesValue));){
                dependenciesMap = parser.mapStrings();
            }
            if (dependenciesMap.size() != 1) {
                throw new IllegalArgumentException("Exactly one dependency is allowed to be specified in plugin descriptor properties: " + String.valueOf(dependenciesMap));
            }
            if (dependenciesMap.keySet().stream().noneMatch(s -> s.equals("opensearch"))) {
                throw new IllegalArgumentException("Only opensearch is allowed to be specified as a plugin dependency: " + String.valueOf(dependenciesMap));
            }
            String[] ranges = dependenciesMap.get("opensearch").split(",");
            if (ranges.length != 1) {
                throw new IllegalArgumentException("Exactly one range is allowed to be specified in dependencies for the plugin [\" + name + \"]");
            }
            opensearchVersionRanges.add(SemverRange.fromString(ranges[0].trim()));
        }
        String javaVersionString = propsMap.remove("java.version");
        if (javaVersionString == null) {
            throw new IllegalArgumentException("property [java.version] is missing for plugin [" + name + "]");
        }
        JarHell.checkVersionFormat(javaVersionString);
        String classname = propsMap.remove("classname");
        if (classname == null) {
            throw new IllegalArgumentException("property [classname] is missing for plugin [" + name + "]");
        }
        String customFolderName = customFolderNameValue = propsMap.remove("custom.foldername");
        String extendedString = propsMap.remove("extended.plugins");
        List<Object> extendedPlugins = extendedString == null ? Collections.emptyList() : Arrays.asList(Strings.delimitedListToStringArray(extendedString, ","));
        String hasNativeControllerValue = propsMap.remove("has.native.controller");
        if (hasNativeControllerValue == null) {
            hasNativeController = false;
        } else {
            switch (hasNativeControllerValue) {
                case "true": {
                    hasNativeController = true;
                    break;
                }
                case "false": {
                    hasNativeController = false;
                    break;
                }
                default: {
                    String message = String.format(Locale.ROOT, "property [%s] must be [%s], [%s], or unspecified but was [%s]", "has_native_controller", "true", "false", hasNativeControllerValue);
                    throw new IllegalArgumentException(message);
                }
            }
        }
        if (!propsMap.isEmpty()) {
            throw new IllegalArgumentException("Unknown properties in plugin descriptor: " + String.valueOf(propsMap.keySet()));
        }
        return new PluginInfo(name, description, version, opensearchVersionRanges, javaVersionString, classname, customFolderName, extendedPlugins, hasNativeController);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getFolderName() {
        return this.customFolderName;
    }

    public List<String> getExtendedPlugins() {
        return this.extendedPlugins;
    }

    public String getVersion() {
        return this.version;
    }

    public List<SemverRange> getOpenSearchVersionRanges() {
        return this.opensearchVersionRanges;
    }

    public String getOpenSearchVersionRangesString() {
        if (this.opensearchVersionRanges == null || this.opensearchVersionRanges.isEmpty()) {
            throw new IllegalStateException("Opensearch version ranges list cannot be empty");
        }
        if (this.opensearchVersionRanges.size() == 1) {
            return this.opensearchVersionRanges.get(0).toString();
        }
        return this.opensearchVersionRanges.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public boolean hasNativeController() {
        return this.hasNativeController;
    }

    public String getTargetFolderName() {
        return this.customFolderName == null || this.customFolderName.isEmpty() ? this.name : this.customFolderName;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("version", this.version);
        builder.field("opensearch_version", this.getOpenSearchVersionRangesString());
        builder.field("java_version", this.javaVersion);
        builder.field("description", this.description);
        builder.field("classname", this.classname);
        builder.field("custom_foldername", this.customFolderName);
        builder.field("extended_plugins", this.extendedPlugins);
        builder.field("has_native_controller", this.hasNativeController);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder information = new StringBuilder().append(prefix).append("- Plugin information:\n").append(prefix).append("Name: ").append(this.name).append("\n").append(prefix).append("Description: ").append(this.description).append("\n").append(prefix).append("Version: ").append(this.version).append("\n").append(prefix).append("OpenSearch Version: ").append(this.getOpenSearchVersionRangesString()).append("\n").append(prefix).append("Java Version: ").append(this.javaVersion).append("\n").append(prefix).append("Native Controller: ").append(this.hasNativeController).append("\n").append(prefix).append("Extended Plugins: ").append(this.extendedPlugins).append("\n").append(prefix).append(" * Classname: ").append(this.classname).append("\n").append(prefix).append("Folder name: ").append(this.customFolderName);
        return information.toString();
    }
}

