/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.settings;

import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.AdmissionControlSettings;
import org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlMode;

public class IoBasedAdmissionControllerSettings {
    private AdmissionControlMode transportLayerMode;
    private Long searchIOUsageLimit;
    private Long indexingIOUsageLimit;
    private Long clusterAdminIOUsageLimit;
    public static final Setting<AdmissionControlMode> IO_BASED_ADMISSION_CONTROLLER_TRANSPORT_LAYER_MODE = new Setting<AdmissionControlMode>("admission_control.transport.io_usage.mode_override", AdmissionControlSettings.ADMISSION_CONTROL_TRANSPORT_LAYER_MODE, AdmissionControlMode::fromName, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Long> SEARCH_IO_USAGE_LIMIT = Setting.longSetting("admission_control.search.io_usage.limit", 95L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Long> INDEXING_IO_USAGE_LIMIT = Setting.longSetting("admission_control.indexing.io_usage.limit", 95L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Long> CLUSTER_ADMIN_IO_USAGE_LIMIT = Setting.longSetting("admission_control.cluster_admin.io_usage.limit", 100L, Setting.Property.Final, Setting.Property.NodeScope);

    public IoBasedAdmissionControllerSettings(ClusterSettings clusterSettings, Settings settings) {
        this.transportLayerMode = IO_BASED_ADMISSION_CONTROLLER_TRANSPORT_LAYER_MODE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(IO_BASED_ADMISSION_CONTROLLER_TRANSPORT_LAYER_MODE, this::setTransportLayerMode);
        this.searchIOUsageLimit = SEARCH_IO_USAGE_LIMIT.get(settings);
        this.indexingIOUsageLimit = INDEXING_IO_USAGE_LIMIT.get(settings);
        this.clusterAdminIOUsageLimit = CLUSTER_ADMIN_IO_USAGE_LIMIT.get(settings);
        clusterSettings.addSettingsUpdateConsumer(INDEXING_IO_USAGE_LIMIT, this::setIndexingIOUsageLimit);
        clusterSettings.addSettingsUpdateConsumer(SEARCH_IO_USAGE_LIMIT, this::setSearchIOUsageLimit);
    }

    public void setIndexingIOUsageLimit(Long indexingIOUsageLimit) {
        this.indexingIOUsageLimit = indexingIOUsageLimit;
    }

    public void setSearchIOUsageLimit(Long searchIOUsageLimit) {
        this.searchIOUsageLimit = searchIOUsageLimit;
    }

    public AdmissionControlMode getTransportLayerAdmissionControllerMode() {
        return this.transportLayerMode;
    }

    public void setTransportLayerMode(AdmissionControlMode transportLayerMode) {
        this.transportLayerMode = transportLayerMode;
    }

    public Long getIndexingIOUsageLimit() {
        return this.indexingIOUsageLimit;
    }

    public Long getSearchIOUsageLimit() {
        return this.searchIOUsageLimit;
    }

    public Long getClusterAdminIOUsageLimit() {
        return this.clusterAdminIOUsageLimit;
    }

    public static class Defaults {
        public static final long IO_USAGE_LIMIT = 95L;
        public static final long CLUSTER_ADMIN_IO_USAGE_LIMIT = 100L;
    }
}

