/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.stream.write.WritePriority;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.transfer.RemoteTransferContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.transfer.stream.OffsetRangeIndexInputStream;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.compress.NoneCompressor;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BaseBlobStoreFormat;

public class ConfigBlobStoreFormat<T extends ToXContent>
extends BaseBlobStoreFormat<T> {
    public ConfigBlobStoreFormat(String blobNameFormat) {
        super(blobNameFormat, true);
    }

    public void writeAsyncWithUrgentPriority(T obj, BlobContainer blobContainer, String name, ActionListener<Void> listener) throws IOException {
        if (!(blobContainer instanceof AsyncMultiStreamBlobContainer)) {
            this.write(obj, blobContainer, name, new NoneCompressor(), ToXContent.EMPTY_PARAMS, XContentType.JSON, null, null);
            listener.onResponse(null);
            return;
        }
        String blobName = this.blobName(name);
        BytesReference bytes = this.serialize(obj, blobName, new NoneCompressor(), ToXContent.EMPTY_PARAMS, XContentType.JSON, null, null);
        String resourceDescription = "BlobStoreFormat.writeAsyncWithPriority(blob=\"" + blobName + "\")";
        try (ByteArrayIndexInput input = new ByteArrayIndexInput(resourceDescription, BytesReference.toBytes(bytes));
             RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(blobName, blobName, bytes.length(), true, WritePriority.URGENT, (size, position) -> new OffsetRangeIndexInputStream(input, size, position), null, false);){
            ((AsyncMultiStreamBlobContainer)blobContainer).asyncBlobUpload(remoteTransferContainer.createWriteContext(), listener);
        }
    }
}

