/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.document;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BulkItemResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BulkRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BulkResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BulkShardRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActiveShardCount;
import org.graylog.shaded.opensearch2.org.opensearch.client.Requests;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.support.XContentHttpChunk;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BytesRestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.StreamingRestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Flux;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Mono;

public class RestBulkStreamingAction
extends BaseRestHandler {
    private static final BulkResponse EMPTY = new BulkResponse(new BulkItemResponse[0], 0L);
    private final boolean allowExplicitIndex;

    public RestBulkStreamingAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_bulk/stream"), new RestHandler.Route(RestRequest.Method.PUT, "/_bulk/stream"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_bulk/stream"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_bulk/stream")));
    }

    @Override
    public String getName() {
        return "streaming_bulk_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String defaultIndex = request.param("index");
        String defaultRouting = request.param("routing");
        String defaultPipeline = request.param("pipeline");
        String waitForActiveShards = request.param("wait_for_active_shards");
        Boolean defaultRequireAlias = request.paramAsBoolean("require_alias", null);
        TimeValue timeout = request.paramAsTime("timeout", BulkShardRequest.DEFAULT_TIMEOUT);
        String refresh = request.param("refresh");
        BaseRestHandler.StreamingRestChannelConsumer consumer = channel -> {
            MediaType mediaType = request.getMediaType();
            channel.prepareResponse(RestStatus.OK, Map.of("Content-Type", List.of(mediaType.mediaTypeWithoutParameters())));
            Flux.from(channel).map(chunk -> {
                FetchSourceContext defaultFetchSourceContext = FetchSourceContext.parseFromRestRequest(request);
                BulkRequest bulkRequest = Requests.bulkRequest();
                if (waitForActiveShards != null) {
                    bulkRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
                }
                bulkRequest.timeout(timeout);
                bulkRequest.setRefreshPolicy(refresh);
                try {
                    bulkRequest.add(chunk.content(), defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias, this.allowExplicitIndex, request.getMediaType());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                return Tuple.tuple(chunk.isLast(), bulkRequest);
            }).flatMap(tuple -> {
                final CompletableFuture<BulkResponse> f = new CompletableFuture<BulkResponse>();
                if (((BulkRequest)tuple.v2()).requests().isEmpty()) {
                    f.complete(EMPTY);
                } else {
                    client.bulk((BulkRequest)tuple.v2(), new ActionListener<BulkResponse>(){

                        @Override
                        public void onResponse(BulkResponse response) {
                            f.complete(response);
                        }

                        @Override
                        public void onFailure(Exception ex) {
                            f.completeExceptionally(ex);
                        }
                    });
                    if (((Boolean)tuple.v1()).booleanValue()) {
                        return Flux.just(new CompletableFuture[]{f, CompletableFuture.completedFuture(EMPTY)});
                    }
                }
                return Mono.just(f);
            }).concatMap(f -> Mono.fromFuture(f).doOnNext(r -> {
                block9: {
                    try {
                        if (r == EMPTY) {
                            channel.sendChunk(XContentHttpChunk.last());
                            break block9;
                        }
                        try (XContentBuilder builder = channel.newBuilder(mediaType, true);){
                            channel.sendChunk(XContentHttpChunk.from(r.toXContent(builder, ToXContent.EMPTY_PARAMS)));
                        }
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            })).subscribe();
        };
        return channel -> {
            if (channel instanceof StreamingRestChannel) {
                consumer.accept((StreamingRestChannel)channel);
            } else {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("Unable to initiate request / response streaming over non-streaming channel");
                channel.sendResponse(new BytesRestResponse((RestChannel)channel, validationError));
            }
        };
    }

    @Override
    public boolean supportsContentStream() {
        return true;
    }

    @Override
    public boolean supportsStreaming() {
        return true;
    }

    @Override
    public boolean allowsUnsafeBuffers() {
        return true;
    }
}

