/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.action.OriginalIndices;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.DeletePitInfo;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.DeletePitResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.ListPitInfo;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.PitSearchContextIdForNode;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchShardTask;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchType;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.UpdatePitContextRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.UpdatePitContextResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.TransportActions;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedSupplier;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDs;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentMapLong;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.util.CollectionUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.Index;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Engine;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DerivedFieldResolver;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DerivedFieldResolverFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.InnerHitContextBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchNoneQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryRewriteContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.Rewriteable;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexEventListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.SearchOperationListener;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.cluster.IndicesClusterStateService;
import org.graylog.shaded.opensearch2.org.opensearch.node.ResponseCollectorService;
import org.graylog.shaded.opensearch2.org.opensearch.script.FieldScript;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptService;
import org.graylog.shaded.opensearch2.org.opensearch.search.DefaultSearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.Scroll;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchContextMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchException;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchExtBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchPhaseResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchShardTarget;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationInitializationException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.SearchContextAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.collapse.CollapseContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.dfs.DfsPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.dfs.DfsSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.QueryFetchSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.ScrollQueryFetchSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.ShardFetchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchDocValuesContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchFieldsContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.ScriptFieldsContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.AliasFilter;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.InternalScrollSearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.LegacyReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.PitReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ShardSearchContextId;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ShardSearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.Profilers;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QuerySearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QuerySearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.ScrollQuerySearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.rescore.RescorerBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.searchafter.SearchAfterBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.FieldSortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.MinAndMax;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortAndFormats;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.Suggest;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.completion.CompletionSuggestion;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskResourceTrackingService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.Scheduler;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;

public class SearchService
extends AbstractLifecycleComponent
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SearchService.class);
    public static final Setting<TimeValue> DEFAULT_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.default_keep_alive", TimeValue.timeValueMinutes(5L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> MAX_PIT_KEEPALIVE_SETTING = Setting.positiveTimeSetting("point_in_time.max_keep_alive", TimeValue.timeValueHours(24L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> MAX_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.max_keep_alive", TimeValue.timeValueHours(24L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> KEEPALIVE_INTERVAL_SETTING = Setting.positiveTimeSetting("search.keep_alive_interval", TimeValue.timeValueMinutes(1L), Setting.Property.NodeScope);
    public static final Setting<Boolean> ALLOW_EXPENSIVE_QUERIES = Setting.boolSetting("search.allow_expensive_queries", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> LOW_LEVEL_CANCELLATION_SETTING = Setting.boolSetting("search.low_level_cancellation", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final TimeValue NO_TIMEOUT = TimeValue.timeValueMillis(-1L);
    public static final Setting<TimeValue> DEFAULT_SEARCH_TIMEOUT_SETTING = Setting.timeSetting("search.default_search_timeout", NO_TIMEOUT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS = Setting.boolSetting("search.default_allow_partial_results", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_OPEN_SCROLL_CONTEXT = Setting.intSetting("search.max_open_scroll_context", 500, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_OPEN_PIT_CONTEXT = Setting.intSetting("search.max_open_pit_context", 300, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_CONCURRENT_SEGMENT_SEARCH_SETTING = Setting.boolSetting("search.concurrent_segment_search.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String CONCURRENT_SEGMENT_SEARCH_TARGET_MAX_SLICE_COUNT_KEY = "search.concurrent.max_slice_count";
    public static final int CONCURRENT_SEGMENT_SEARCH_TARGET_MAX_SLICE_COUNT_DEFAULT_VALUE = 0;
    public static final Setting<Integer> CONCURRENT_SEGMENT_SEARCH_TARGET_MAX_SLICE_COUNT_SETTING = Setting.intSetting("search.concurrent.max_slice_count", 0, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_AGGREGATION_REWRITE_FILTERS = Setting.intSetting("search.max_aggregation_rewrite_filters", 3000, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_ALLOW_DERIVED_FIELD_SETTING = Setting.boolSetting("search.derived_field.enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CARDINALITY_AGGREGATION_PRUNING_THRESHOLD = Setting.intSetting("search.dynamic_pruning.cardinality_aggregation.max_allowed_cardinality", 100, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final int DEFAULT_SIZE = 10;
    public static final int DEFAULT_FROM = 0;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final ResponseCollectorService responseCollectorService;
    private final BigArrays bigArrays;
    private final DfsPhase dfsPhase = new DfsPhase();
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private volatile long defaultKeepAlive;
    private volatile long maxKeepAlive;
    private volatile long maxPitKeepAlive;
    private volatile TimeValue defaultSearchTimeout;
    private volatile boolean defaultAllowPartialSearchResults;
    private volatile boolean lowLevelCancellation;
    private volatile int maxOpenScrollContext;
    private volatile int maxOpenPitContext;
    private volatile boolean allowDerivedField;
    private final Scheduler.Cancellable keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentMapLong<ReaderContext> activeReaders = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final MultiBucketConsumerService multiBucketConsumerService;
    private final AtomicInteger openScrollContexts = new AtomicInteger();
    private final AtomicInteger openPitContexts = new AtomicInteger();
    private final String sessionId = UUIDs.randomBase64UUID();
    private final Executor indexSearcherExecutor;
    private final TaskResourceTrackingService taskResourceTrackingService;

    public SearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, QueryPhase queryPhase, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, Executor indexSearcherExecutor, TaskResourceTrackingService taskResourceTrackingService) {
        Settings settings = clusterService.getSettings();
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.responseCollectorService = responseCollectorService;
        this.bigArrays = bigArrays;
        this.queryPhase = queryPhase;
        this.fetchPhase = fetchPhase;
        this.multiBucketConsumerService = new MultiBucketConsumerService(clusterService, settings, circuitBreakerService.getBreaker("request"));
        this.indexSearcherExecutor = indexSearcherExecutor;
        this.taskResourceTrackingService = taskResourceTrackingService;
        TimeValue keepAliveInterval = KEEPALIVE_INTERVAL_SETTING.get(settings);
        this.setKeepAlives(DEFAULT_KEEPALIVE_SETTING.get(settings), MAX_KEEPALIVE_SETTING.get(settings));
        this.setPitKeepAlives(DEFAULT_KEEPALIVE_SETTING.get(settings), MAX_PIT_KEEPALIVE_SETTING.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_KEEPALIVE_SETTING, MAX_PIT_KEEPALIVE_SETTING, this::setPitKeepAlives, this::validatePitKeepAlives);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_KEEPALIVE_SETTING, MAX_KEEPALIVE_SETTING, this::setKeepAlives, this::validateKeepAlives);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval, "same");
        this.defaultSearchTimeout = DEFAULT_SEARCH_TIMEOUT_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_SEARCH_TIMEOUT_SETTING, this::setDefaultSearchTimeout);
        this.defaultAllowPartialSearchResults = DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS, this::setDefaultAllowPartialSearchResults);
        this.maxOpenScrollContext = MAX_OPEN_SCROLL_CONTEXT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_OPEN_SCROLL_CONTEXT, this::setMaxOpenScrollContext);
        this.maxOpenPitContext = MAX_OPEN_PIT_CONTEXT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_OPEN_PIT_CONTEXT, this::setMaxOpenPitContext);
        this.lowLevelCancellation = LOW_LEVEL_CANCELLATION_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LOW_LEVEL_CANCELLATION_SETTING, this::setLowLevelCancellation);
        this.allowDerivedField = CLUSTER_ALLOW_DERIVED_FIELD_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_ALLOW_DERIVED_FIELD_SETTING, this::setAllowDerivedField);
    }

    private void validateKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        if (defaultKeepAlive.millis() > maxKeepAlive.millis()) {
            throw new IllegalArgumentException("Default keep alive setting for request [" + DEFAULT_KEEPALIVE_SETTING.getKey() + "] should be smaller than max keep alive [" + MAX_KEEPALIVE_SETTING.getKey() + "], was (" + String.valueOf(defaultKeepAlive) + " > " + String.valueOf(maxKeepAlive) + ")");
        }
    }

    private void validatePitKeepAlives(TimeValue defaultKeepAlive, TimeValue maxPitKeepAlive) {
        if (defaultKeepAlive.millis() > maxPitKeepAlive.millis()) {
            throw new IllegalArgumentException("Default keep alive setting for request [" + DEFAULT_KEEPALIVE_SETTING.getKey() + "] should be smaller than max keep alive for PIT [" + MAX_PIT_KEEPALIVE_SETTING.getKey() + "], was (" + String.valueOf(defaultKeepAlive) + " > " + String.valueOf(maxPitKeepAlive) + ")");
        }
    }

    private void setKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        this.validateKeepAlives(defaultKeepAlive, maxKeepAlive);
        this.defaultKeepAlive = defaultKeepAlive.millis();
        this.maxKeepAlive = maxKeepAlive.millis();
    }

    private void setPitKeepAlives(TimeValue defaultKeepAlive, TimeValue maxPitKeepAlive) {
        this.validatePitKeepAlives(defaultKeepAlive, maxPitKeepAlive);
        this.maxPitKeepAlive = maxPitKeepAlive.millis();
    }

    private void setDefaultSearchTimeout(TimeValue defaultSearchTimeout) {
        this.defaultSearchTimeout = defaultSearchTimeout;
    }

    private void setDefaultAllowPartialSearchResults(boolean defaultAllowPartialSearchResults) {
        this.defaultAllowPartialSearchResults = defaultAllowPartialSearchResults;
    }

    public boolean defaultAllowPartialSearchResults() {
        return this.defaultAllowPartialSearchResults;
    }

    private void setMaxOpenScrollContext(int maxOpenScrollContext) {
        this.maxOpenScrollContext = maxOpenScrollContext;
    }

    private void setAllowDerivedField(boolean allowDerivedField) {
        this.allowDerivedField = allowDerivedField;
    }

    private void setMaxOpenPitContext(int maxOpenPitContext) {
        this.maxOpenPitContext = maxOpenPitContext;
    }

    private void setLowLevelCancellation(Boolean lowLevelCancellation) {
        this.lowLevelCancellation = lowLevelCancellation;
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        if (reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.CLOSED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.REOPENED) {
            this.freeAllContextForIndex(index);
        }
    }

    protected void putReaderContext(ReaderContext context) {
        ReaderContext previous = this.activeReaders.put(context.id().getId(), context);
        assert (previous == null);
        Index index = context.indexShard().shardId().getIndex();
        if (!this.indicesService.hasIndex(index)) {
            this.removeReaderContext(context.id().getId());
            throw new IndexNotFoundException(index);
        }
    }

    protected ReaderContext removeReaderContext(long id) {
        return this.activeReaders.remove(id);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        for (ReaderContext context : this.activeReaders.values()) {
            this.freeReaderContext(context.id());
        }
    }

    @Override
    protected void doClose() {
        this.doStop();
        this.keepAliveReaper.cancel();
    }

    public void executeDfsPhase(final ShardSearchRequest request, final boolean keepStatesInContext, final SearchShardTask task, final ActionListener<SearchPhaseResult> listener) {
        final IndexShard shard = this.getShard(request);
        this.rewriteAndFetchShardRequest(shard, request, new ActionListener<ShardSearchRequest>(){

            @Override
            public void onResponse(ShardSearchRequest rewritten) {
                SearchService.this.runAsync(SearchService.this.getExecutor(shard), () -> SearchService.this.executeDfsPhase(request, task, keepStatesInContext), listener);
            }

            @Override
            public void onFailure(Exception exc) {
                listener.onFailure(exc);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private DfsSearchResult executeDfsPhase(ShardSearchRequest request, SearchShardTask task, boolean keepStatesInContext) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadOrExecuteQueryPhase(ShardSearchRequest request, SearchContext context) throws Exception {
        boolean canCache = this.indicesService.canCache(request, context);
        context.getQueryShardContext().freezeContext();
        if (canCache) {
            this.indicesService.loadIntoContext(request, context, this.queryPhase);
        } else {
            this.queryPhase.execute(context);
        }
    }

    public void executeQueryPhase(ShardSearchRequest request, final boolean keepStatesInContext, final SearchShardTask task, final ActionListener<SearchPhaseResult> listener) {
        assert (!request.canReturnNullResponseIfMatchNoDocs() || request.numberOfShards() > 1) : "empty responses require more than one shard";
        final IndexShard shard = this.getShard(request);
        this.rewriteAndFetchShardRequest(shard, request, new ActionListener<ShardSearchRequest>(){

            @Override
            public void onResponse(ShardSearchRequest orig) {
                if (orig.canReturnNullResponseIfMatchNoDocs()) {
                    CanMatchResponse canMatchResp;
                    assert (orig.scroll() == null);
                    try {
                        ShardSearchRequest clone = new ShardSearchRequest(orig);
                        canMatchResp = SearchService.this.canMatch(clone, false);
                    }
                    catch (Exception exc) {
                        listener.onFailure(exc);
                        return;
                    }
                    if (!canMatchResp.canMatch) {
                        listener.onResponse(QuerySearchResult.nullInstance());
                        return;
                    }
                }
                SearchService.this.runAsync(SearchService.this.getExecutor(shard), () -> SearchService.this.executeQueryPhase(orig, task, keepStatesInContext), listener);
            }

            @Override
            public void onFailure(Exception exc) {
                listener.onFailure(exc);
            }
        });
    }

    private IndexShard getShard(ShardSearchRequest request) {
        if (request.readerId() != null) {
            return this.findReaderContext(request.readerId(), request).indexShard();
        }
        return this.indicesService.indexServiceSafe(request.shardId().getIndex()).getShard(request.shardId().id());
    }

    private <T> void runAsync(Executor executor, CheckedSupplier<T, Exception> executable, ActionListener<T> listener) {
        executor.execute(ActionRunnable.supply(listener, executable::get));
    }

    /*
     * Exception decompiling
     */
    private SearchPhaseResult executeQueryPhase(ShardSearchRequest request, SearchShardTask task, boolean keepStatesInContext) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private QueryFetchSearchResult executeFetchPhase(ReaderContext reader, SearchContext context, long afterQueryTime) {
        try (SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(context, true, afterQueryTime);){
            this.shortcutDocIdsToLoad(context);
            this.fetchPhase.execute(context);
            if (reader.singleSession()) {
                this.freeReaderContext(reader.id());
            }
            executor.success();
        }
        return new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
    }

    public void executeQueryPhase(InternalScrollSearchRequest request, SearchShardTask task, ActionListener<ScrollQuerySearchResult> listener) {
        Releasable markAsUsed;
        LegacyReaderContext readerContext = (LegacyReaderContext)this.findReaderContext(request.contextId(), request);
        try {
            markAsUsed = readerContext.markAsUsed(this.getScrollKeepAlive(request.scroll()));
        }
        catch (Exception e) {
            this.freeReaderContext(readerContext.id());
            throw e;
        }
        this.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    public void executeQueryPhase(QuerySearchRequest request, SearchShardTask task, ActionListener<QuerySearchResult> listener) {
        ReaderContext readerContext = this.findReaderContext(request.contextId(), request.shardSearchRequest());
        ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(request.shardSearchRequest());
        Releasable markAsUsed = readerContext.markAsUsed(this.getKeepAlive(shardSearchRequest));
        this.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    private Executor getExecutor(IndexShard indexShard) {
        assert (indexShard != null);
        String executorName = indexShard.isSystem() ? "system_read" : (indexShard.indexSettings().isSearchThrottled() ? "search_throttled" : "search");
        return this.threadPool.executor(executorName);
    }

    public void executeFetchPhase(InternalScrollSearchRequest request, SearchShardTask task, ActionListener<ScrollQueryFetchSearchResult> listener) {
        Releasable markAsUsed;
        LegacyReaderContext readerContext = (LegacyReaderContext)this.findReaderContext(request.contextId(), request);
        try {
            markAsUsed = readerContext.markAsUsed(this.getScrollKeepAlive(request.scroll()));
        }
        catch (Exception e) {
            this.freeReaderContext(readerContext.id());
            throw e;
        }
        this.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    public void executeFetchPhase(ShardFetchRequest request, SearchShardTask task, ActionListener<FetchSearchResult> listener) {
        ReaderContext readerContext = this.findReaderContext(request.contextId(), request);
        ShardSearchRequest shardSearchRequest = readerContext.getShardSearchRequest(request.getShardSearchRequest());
        Releasable markAsUsed = readerContext.markAsUsed(this.getKeepAlive(shardSearchRequest));
        this.runAsync(this.getExecutor(readerContext.indexShard()), () -> {
            try {
                SearchContext searchContext = this.createContext(readerContext, shardSearchRequest, task, false);
                try {
                    if (request.lastEmittedDoc() != null) {
                        searchContext.scrollContext().lastEmittedDoc = request.lastEmittedDoc();
                    }
                    searchContext.assignRescoreDocIds(readerContext.getRescoreDocIds(request.getRescoreDocIds()));
                    searchContext.searcher().setAggregatedDfs(readerContext.getAggregatedDfs(request.getAggregatedDfs()));
                    searchContext.docIdsToLoad(request.docIds(), 0, request.docIdsSize());
                    try (SearchOperationListenerExecutor executor = new SearchOperationListenerExecutor(searchContext, true, System.nanoTime());){
                        this.fetchPhase.execute(searchContext);
                        if (readerContext.singleSession()) {
                            this.freeReaderContext(request.contextId());
                        }
                        executor.success();
                    }
                    FetchSearchResult fetchSearchResult = searchContext.fetchResult();
                    if (searchContext != null) {
                        searchContext.close();
                    }
                    return fetchSearchResult;
                }
                catch (Throwable throwable) {
                    try {
                        if (searchContext != null) {
                            try {
                                searchContext.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        assert (!TransportActions.isShardNotAvailableException(e)) : new AssertionError((Object)e);
                        throw e;
                    }
                }
            }
            finally {
                this.taskResourceTrackingService.writeTaskResourceUsage(task, this.clusterService.localNode().getId());
            }
        }, this.wrapFailureListener(listener, readerContext, markAsUsed));
    }

    private ReaderContext getReaderContext(ShardSearchContextId id) {
        if (!this.sessionId.equals(id.getSessionId()) && !id.getSessionId().isEmpty()) {
            throw new SearchContextMissingException(id);
        }
        return this.activeReaders.get(id.getId());
    }

    private ReaderContext findReaderContext(ShardSearchContextId id, TransportRequest request) throws SearchContextMissingException {
        ReaderContext reader = this.getReaderContext(id);
        if (reader == null) {
            throw new SearchContextMissingException(id);
        }
        try {
            reader.validate(request);
        }
        catch (Exception exc) {
            this.processFailure(reader, exc);
            throw exc;
        }
        return reader;
    }

    final ReaderContext createOrGetReaderContext(ShardSearchRequest request, boolean keepStatesInContext) {
        if (request.readerId() != null) {
            assert (!keepStatesInContext);
            return this.findReaderContext(request.readerId(), request);
        }
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        Engine.SearcherSupplier reader = shard.acquireSearcherSupplier();
        return this.createAndPutReaderContext(request, indexService, shard, reader, keepStatesInContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ReaderContext createAndPutReaderContext(ShardSearchRequest request, IndexService indexService, IndexShard shard, Engine.SearcherSupplier reader, boolean keepStatesInContext) {
        ReaderContext readerContext;
        assert (request.readerId() == null);
        assert (request.keepAlive() == null);
        ReaderContext readerContext2 = null;
        Releasable decreaseScrollContexts = null;
        try {
            if (request.scroll() != null) {
                decreaseScrollContexts = this.openScrollContexts::decrementAndGet;
                if (this.openScrollContexts.incrementAndGet() > this.maxOpenScrollContext) {
                    throw new OpenSearchRejectedExecutionException("Trying to create too many scroll contexts. Must be less than or equal to: [" + this.maxOpenScrollContext + "]. This limit can be set by changing the [" + MAX_OPEN_SCROLL_CONTEXT.getKey() + "] setting.");
                }
            }
            long keepAlive = this.getKeepAlive(request);
            ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet());
            if (keepStatesInContext || request.scroll() != null) {
                readerContext2 = new LegacyReaderContext(id, indexService, shard, reader, request, keepAlive);
                if (request.scroll() != null) {
                    readerContext2.addOnClose(decreaseScrollContexts);
                    decreaseScrollContexts = null;
                }
            } else {
                readerContext2 = new ReaderContext(id, indexService, shard, reader, keepAlive, request.keepAlive() == null);
            }
            reader = null;
            ReaderContext finalReaderContext = readerContext2;
            SearchOperationListener searchOperationListener = shard.getSearchOperationListener();
            searchOperationListener.onNewReaderContext(finalReaderContext);
            if (finalReaderContext.scrollContext() != null) {
                searchOperationListener.onNewScrollContext(finalReaderContext);
            }
            readerContext2.addOnClose(() -> {
                try {
                    if (finalReaderContext.scrollContext() != null) {
                        searchOperationListener.onFreeScrollContext(finalReaderContext);
                    }
                }
                finally {
                    searchOperationListener.onFreeReaderContext(finalReaderContext);
                }
            });
            this.putReaderContext(finalReaderContext);
            readerContext2 = null;
            readerContext = finalReaderContext;
        }
        catch (Throwable throwable) {
            Releasables.close(reader, readerContext2, decreaseScrollContexts);
            throw throwable;
        }
        Releasables.close(reader, readerContext2, decreaseScrollContexts);
        return readerContext;
    }

    public void createPitReaderContext(ShardId shardId, TimeValue keepAlive, ActionListener<ShardSearchContextId> listener) {
        this.checkPitKeepAliveLimit(keepAlive.millis());
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard shard = indexService.getShard(shardId.id());
        SearchOperationListener searchOperationListener = shard.getSearchOperationListener();
        shard.awaitShardSearchActive(ignored -> {
            Engine.SearcherSupplier searcherSupplier = null;
            PitReaderContext readerContext = null;
            Releasable decreasePitContexts = this.openPitContexts::decrementAndGet;
            try {
                if (this.openPitContexts.incrementAndGet() > this.maxOpenPitContext) {
                    throw new OpenSearchRejectedExecutionException("Trying to create too many Point In Time contexts. Must be less than or equal to: [" + this.maxOpenPitContext + "]. This limit can be set by changing the [" + MAX_OPEN_PIT_CONTEXT.getKey() + "] setting.");
                }
                searcherSupplier = shard.acquireSearcherSupplier();
                ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet());
                PitReaderContext finalReaderContext = readerContext = new PitReaderContext(id, indexService, shard, searcherSupplier, keepAlive.millis(), false);
                searcherSupplier = null;
                searchOperationListener.onNewReaderContext(readerContext);
                searchOperationListener.onNewPitContext(finalReaderContext);
                readerContext.addOnClose(() -> {
                    searchOperationListener.onFreeReaderContext(finalReaderContext);
                    searchOperationListener.onFreePitContext(finalReaderContext);
                });
                readerContext.addOnClose(decreasePitContexts);
                this.putReaderContext(readerContext);
                readerContext = null;
                listener.onResponse(finalReaderContext.id());
            }
            catch (Exception exc) {
                Releasables.closeWhileHandlingException(decreasePitContexts);
                Releasables.closeWhileHandlingException(searcherSupplier, readerContext);
                listener.onFailure(exc);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePitIdAndKeepAlive(UpdatePitContextRequest request, ActionListener<UpdatePitContextResponse> listener) {
        this.checkPitKeepAliveLimit(request.getKeepAlive());
        PitReaderContext readerContext = this.getPitReaderContext(request.getSearchContextId());
        if (readerContext == null) {
            throw new SearchContextMissingException(request.getSearchContextId());
        }
        try (Releasable updatePit = null;){
            updatePit = readerContext.updatePitIdAndKeepAlive(request.getKeepAlive(), request.getPitId(), request.getCreationTime());
            listener.onResponse(new UpdatePitContextResponse(request.getPitId(), request.getCreationTime(), request.getKeepAlive()));
        }
    }

    public PitReaderContext getPitReaderContext(ShardSearchContextId id) {
        ReaderContext context = this.activeReaders.get(id.getId());
        if (context instanceof PitReaderContext) {
            return (PitReaderContext)context;
        }
        return null;
    }

    public List<ListPitInfo> getAllPITReaderContexts() {
        ArrayList<ListPitInfo> pitContextsInfo = new ArrayList<ListPitInfo>();
        for (ReaderContext ctx : this.activeReaders.values()) {
            if (!(ctx instanceof PitReaderContext)) continue;
            PitReaderContext context = (PitReaderContext)ctx;
            ListPitInfo pitInfo = new ListPitInfo(context.getPitId(), context.getCreationTime(), context.getKeepAlive());
            pitContextsInfo.add(pitInfo);
        }
        return pitContextsInfo;
    }

    final SearchContext createContext(ReaderContext readerContext, ShardSearchRequest request, SearchShardTask task, boolean includeAggregations) throws IOException {
        DefaultSearchContext context = this.createSearchContext(readerContext, request, this.defaultSearchTimeout, false);
        try {
            if (request.scroll() != null) {
                context.scrollContext().scroll = request.scroll();
            }
            this.parseSource(context, request.source(), includeAggregations);
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.size() == -1) {
                context.size(10);
            }
            context.setTask(task);
            this.queryPhase.preProcess(context);
        }
        catch (Exception e) {
            context.close();
            throw e;
        }
        return context;
    }

    public DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout, boolean validate) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().getId());
        Engine.SearcherSupplier reader = indexShard.acquireSearcherSupplier();
        ShardSearchContextId id = new ShardSearchContextId(this.sessionId, this.idGenerator.incrementAndGet());
        try (ReaderContext readerContext = new ReaderContext(id, indexService, indexShard, reader, -1L, true);){
            DefaultSearchContext searchContext = this.createSearchContext(readerContext, request, timeout, validate);
            searchContext.addReleasable(readerContext.markAsUsed(0L));
            DefaultSearchContext defaultSearchContext = searchContext;
            return defaultSearchContext;
        }
    }

    public DefaultSearchContext createValidationContext(ShardSearchRequest request, TimeValue timeout) throws IOException {
        return this.createSearchContext(request, timeout, true);
    }

    public DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout) throws IOException {
        return this.createSearchContext(request, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DefaultSearchContext createSearchContext(ReaderContext reader, ShardSearchRequest request, TimeValue timeout, boolean validate) throws IOException {
        boolean success = false;
        DefaultSearchContext searchContext = null;
        try {
            SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().getId(), reader.indexShard().shardId(), request.getClusterAlias(), OriginalIndices.NONE);
            searchContext = new DefaultSearchContext(reader, request, shardTarget, this.clusterService, this.bigArrays, this.threadPool::relativeTimeInMillis, timeout, this.fetchPhase, this.lowLevelCancellation, this.clusterService.state().nodes().getMinNodeVersion(), validate, this.indexSearcherExecutor, this::aggReduceContextBuilder);
            QueryShardContext context = new QueryShardContext(searchContext.getQueryShardContext());
            DerivedFieldResolver derivedFieldResolver = DerivedFieldResolverFactory.createResolver(searchContext.getQueryShardContext(), Optional.ofNullable(request.source()).map(SearchSourceBuilder::getDerivedFieldsObject).orElse(Collections.emptyMap()), Optional.ofNullable(request.source()).map(SearchSourceBuilder::getDerivedFields).orElse(Collections.emptyList()), context.getIndexSettings().isDerivedFieldAllowed() && this.allowDerivedField);
            context.setDerivedFieldResolver(derivedFieldResolver);
            searchContext.getQueryShardContext().setDerivedFieldResolver(derivedFieldResolver);
            Rewriteable.rewrite(request.getRewriteable(), context, true);
            assert (searchContext.getQueryShardContext().isCacheable());
            success = true;
            if (success) return searchContext;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(searchContext);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable)searchContext);
        return searchContext;
    }

    private void freeAllContextForIndex(Index index) {
        assert (index != null);
        for (ReaderContext ctx : this.activeReaders.values()) {
            if (!index.equals(ctx.indexShard().shardId().getIndex())) continue;
            this.freeReaderContext(ctx.id());
        }
    }

    public boolean freeReaderContext(ShardSearchContextId contextId) {
        if (this.getReaderContext(contextId) != null) {
            try (ReaderContext context = this.removeReaderContext(contextId.getId());){
                boolean bl = context != null;
                return bl;
            }
        }
        return false;
    }

    public void freeAllScrollContexts() {
        for (ReaderContext readerContext : this.activeReaders.values()) {
            if (readerContext.scrollContext() == null) continue;
            this.freeReaderContext(readerContext.id());
        }
    }

    public DeletePitResponse freeReaderContextsIfFound(List<PitSearchContextIdForNode> contextIds) {
        ArrayList<DeletePitInfo> deleteResults = new ArrayList<DeletePitInfo>();
        for (PitSearchContextIdForNode contextId : contextIds) {
            try {
                if (this.getReaderContext(contextId.getSearchContextIdForNode().getSearchContextId()) != null) {
                    ReaderContext context = this.removeReaderContext(contextId.getSearchContextIdForNode().getSearchContextId().getId());
                    try {
                        PitReaderContext pitReaderContext = (PitReaderContext)context;
                        if (context == null) {
                            DeletePitInfo deletePitInfo = new DeletePitInfo(true, contextId.getPitId());
                            deleteResults.add(deletePitInfo);
                            continue;
                        }
                        String pitId = pitReaderContext.getPitId();
                        boolean success = context != null;
                        DeletePitInfo deletePitInfo = new DeletePitInfo(success, pitId);
                        deleteResults.add(deletePitInfo);
                        continue;
                    }
                    finally {
                        if (context != null) {
                            context.close();
                        }
                        continue;
                    }
                }
                DeletePitInfo deletePitInfo = new DeletePitInfo(true, contextId.getPitId());
                deleteResults.add(deletePitInfo);
            }
            catch (SearchContextMissingException e) {
                DeletePitInfo deletePitInfo = new DeletePitInfo(true, contextId.getPitId());
                deleteResults.add(deletePitInfo);
            }
        }
        return new DeletePitResponse(deleteResults);
    }

    private long getKeepAlive(ShardSearchRequest request) {
        if (request.scroll() != null) {
            return this.getScrollKeepAlive(request.scroll());
        }
        if (request.keepAlive() != null) {
            if (this.getReaderContext(request.readerId()) instanceof PitReaderContext) {
                this.checkPitKeepAliveLimit(request.keepAlive().millis());
            } else {
                this.checkKeepAliveLimit(request.keepAlive().millis());
            }
            return request.keepAlive().getMillis();
        }
        return request.readerId() == null ? this.defaultKeepAlive : -1L;
    }

    private long getScrollKeepAlive(Scroll scroll) {
        if (scroll != null && scroll.keepAlive() != null) {
            this.checkKeepAliveLimit(scroll.keepAlive().millis());
            return scroll.keepAlive().getMillis();
        }
        return this.defaultKeepAlive;
    }

    private void checkKeepAliveLimit(long keepAlive) {
        if (keepAlive > this.maxKeepAlive) {
            throw new IllegalArgumentException("Keep alive for request (" + String.valueOf(TimeValue.timeValueMillis(keepAlive)) + ") is too large. It must be less than (" + String.valueOf(TimeValue.timeValueMillis(this.maxKeepAlive)) + "). This limit can be set by changing the [" + MAX_KEEPALIVE_SETTING.getKey() + "] cluster level setting.");
        }
    }

    private void checkPitKeepAliveLimit(long keepAlive) {
        if (keepAlive > this.maxPitKeepAlive) {
            throw new IllegalArgumentException("Keep alive for request (" + String.valueOf(TimeValue.timeValueMillis(keepAlive)) + ") is too large. It must be less than (" + String.valueOf(TimeValue.timeValueMillis(this.maxPitKeepAlive)) + "). This limit can be set by changing the [" + MAX_PIT_KEEPALIVE_SETTING.getKey() + "] cluster level setting.");
        }
    }

    private <T> ActionListener<T> wrapFailureListener(final ActionListener<T> listener, final ReaderContext context, final Releasable releasable) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T resp) {
                Releasables.close(releasable);
                listener.onResponse(resp);
            }

            @Override
            public void onFailure(Exception exc) {
                SearchService.this.processFailure(context, exc);
                Releasables.close(releasable);
                listener.onFailure(exc);
            }
        };
    }

    private boolean isScrollContext(ReaderContext context) {
        return context instanceof LegacyReaderContext && !context.singleSession();
    }

    private void processFailure(ReaderContext context, Exception exc) {
        if (context.singleSession() || this.isScrollContext(context)) {
            this.freeReaderContext(context.id());
        }
        try {
            if (Lucene.isCorruptionException(exc)) {
                context.indexShard().failShard("search execution corruption failure", exc);
            }
        }
        catch (Exception inner) {
            inner.addSuppressed(exc);
            logger.warn("failed to process shard failure to (potentially) send back shard failure on corruption", (Throwable)inner);
        }
    }

    private void parseSource(DefaultSearchContext context, SearchSourceBuilder source, boolean includeAggregations) {
        if (source == null) {
            context.evaluateRequestShouldUseConcurrentSearch();
            return;
        }
        SearchShardTarget shardTarget = context.shardTarget();
        QueryShardContext queryShardContext = context.getQueryShardContext();
        context.from(source.from());
        context.size(source.size());
        HashMap<String, InnerHitContextBuilder> innerHitBuilders = new HashMap<String, InnerHitContextBuilder>();
        if (source.query() != null) {
            InnerHitContextBuilder.extractInnerHits(source.query(), innerHitBuilders);
            context.parsedQuery(queryShardContext.toQuery(source.query()));
        }
        if (source.postFilter() != null) {
            InnerHitContextBuilder.extractInnerHits(source.postFilter(), innerHitBuilders);
            context.parsedPostFilter(queryShardContext.toQuery(source.postFilter()));
        }
        if (innerHitBuilders.size() > 0) {
            for (Map.Entry entry : innerHitBuilders.entrySet()) {
                try {
                    ((InnerHitContextBuilder)entry.getValue()).build(context, context.innerHits());
                }
                catch (IOException e) {
                    throw new SearchException(shardTarget, "failed to build inner_hits", e);
                }
            }
        }
        if (source.sorts() != null) {
            try {
                Optional<SortAndFormats> optionalSort = SortBuilder.buildSort(source.sorts(), context.getQueryShardContext());
                if (optionalSort.isPresent()) {
                    context.sort(optionalSort.get());
                }
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create sort elements", e);
            }
        }
        context.trackScores(source.trackScores());
        context.includeNamedQueriesScore(source.includeNamedQueriesScore());
        if (source.trackTotalHitsUpTo() != null && source.trackTotalHitsUpTo() != Integer.MAX_VALUE && context.scrollContext() != null) {
            throw new SearchException(shardTarget, "disabling [track_total_hits] is not allowed in a scroll context");
        }
        if (source.trackTotalHitsUpTo() != null) {
            context.trackTotalHitsUpTo(source.trackTotalHitsUpTo());
        }
        if (source.minScore() != null) {
            context.minimumScore(source.minScore().floatValue());
        }
        if (source.timeout() != null) {
            context.timeout(source.timeout());
        }
        context.terminateAfter(source.terminateAfter());
        if (source.aggregations() != null && includeAggregations) {
            try {
                AggregatorFactories factories = source.aggregations().build(queryShardContext, null);
                context.aggregations(new SearchContextAggregations(factories, this.multiBucketConsumerService.create()));
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to create aggregators", e);
            }
        }
        if (source.suggest() != null) {
            try {
                context.suggest(source.suggest().build(queryShardContext));
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create SuggestionSearchContext", e);
            }
        }
        if (source.rescores() != null) {
            try {
                for (RescorerBuilder rescore : source.rescores()) {
                    context.addRescore(rescore.buildContext(queryShardContext));
                }
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create RescoreSearchContext", e);
            }
        }
        if (source.explain() != null) {
            context.explain(source.explain());
        }
        if (source.fetchSource() != null) {
            context.fetchSourceContext(source.fetchSource());
        }
        if (source.docValueFields() != null) {
            FetchDocValuesContext docValuesContext = FetchDocValuesContext.create(context.mapperService()::simpleMatchToFullName, context.mapperService().getIndexSettings().getMaxDocvalueFields(), source.docValueFields());
            context.docValuesContext(docValuesContext);
        }
        if (source.fetchFields() != null) {
            FetchFieldsContext fetchFieldsContext = new FetchFieldsContext(source.fetchFields());
            context.fetchFieldsContext(fetchFieldsContext);
        }
        if (source.highlighter() != null) {
            HighlightBuilder highlightBuilder = source.highlighter();
            try {
                context.highlight(highlightBuilder.build(queryShardContext));
            }
            catch (IOException e) {
                throw new SearchException(shardTarget, "failed to create SearchContextHighlighter", e);
            }
        }
        if (source.scriptFields() != null && source.size() != 0) {
            int maxAllowedScriptFields = context.mapperService().getIndexSettings().getMaxScriptFields();
            if (source.scriptFields().size() > maxAllowedScriptFields) {
                throw new IllegalArgumentException("Trying to retrieve too many script_fields. Must be less than or equal to: [" + maxAllowedScriptFields + "] but was [" + source.scriptFields().size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_SCRIPT_FIELDS_SETTING.getKey() + "] index level setting.");
            }
            for (SearchSourceBuilder.ScriptField field : source.scriptFields()) {
                FieldScript.Factory factory = this.scriptService.compile(field.script(), FieldScript.CONTEXT);
                SearchLookup lookup = context.getQueryShardContext().lookup();
                FieldScript.LeafFactory searchScript = factory.newFactory(field.script().getParams(), lookup);
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        if (source.ext() != null) {
            for (SearchExtBuilder searchExtBuilder : source.ext()) {
                context.addSearchExt(searchExtBuilder);
            }
        }
        if (source.version() != null) {
            context.version(source.version());
        }
        if (source.seqNoAndPrimaryTerm() != null) {
            context.seqNoAndPrimaryTerm(source.seqNoAndPrimaryTerm());
        }
        if (source.stats() != null) {
            context.groupStats(source.stats());
        }
        if (!CollectionUtils.isEmpty(source.searchAfter())) {
            if (context.scrollContext() != null) {
                throw new SearchException(shardTarget, "`search_after` cannot be used in a scroll context.");
            }
            if (context.from() > 0) {
                throw new SearchException(shardTarget, "`from` parameter must be set to 0 when `search_after` is used.");
            }
            FieldDoc fieldDoc = SearchAfterBuilder.buildFieldDoc(context.sort(), source.searchAfter());
            context.searchAfter(fieldDoc);
        }
        if (source.slice() != null) {
            if (context.scrollContext() == null && !(context.readerContext() instanceof PitReaderContext)) {
                throw new SearchException(shardTarget, "`slice` cannot be used outside of a scroll context or PIT context");
            }
            context.sliceBuilder(source.slice());
        }
        if (source.storedFields() != null) {
            if (!source.storedFields().fetchFields()) {
                if (context.sourceRequested()) {
                    throw new SearchException(shardTarget, "[stored_fields] cannot be disabled if [_source] is requested");
                }
                if (context.fetchFieldsContext() != null) {
                    throw new SearchException(shardTarget, "[stored_fields] cannot be disabled when using the [fields] option");
                }
            }
            context.storedFieldsContext(source.storedFields());
        }
        if (source.collapse() != null) {
            if (context.scrollContext() != null) {
                throw new SearchException(shardTarget, "cannot use `collapse` in a scroll context");
            }
            if (context.searchAfter() != null) {
                throw new SearchException(shardTarget, "cannot use `collapse` in conjunction with `search_after`");
            }
            if (context.rescore() != null && !context.rescore().isEmpty()) {
                throw new SearchException(shardTarget, "cannot use `collapse` in conjunction with `rescore`");
            }
            CollapseContext collapseContext = source.collapse().build(queryShardContext);
            context.collapse(collapseContext);
        }
        context.evaluateRequestShouldUseConcurrentSearch();
        if (source.profile()) {
            context.setProfilers(new Profilers(context.searcher(), context.shouldUseConcurrentSearch()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void shortcutDocIdsToLoad(SearchContext context) {
        int[] docIdsToLoad;
        TopDocs topDocs;
        List<Object> completionSuggestions;
        int docsOffset = 0;
        Suggest suggest = context.queryResult().suggest();
        int numSuggestDocs = 0;
        if (suggest != null && suggest.hasScoreDocs()) {
            completionSuggestions = suggest.filter(CompletionSuggestion.class);
            for (CompletionSuggestion completionSuggestion : completionSuggestions) {
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
        } else {
            completionSuggestions = Collections.emptyList();
        }
        if (context.request().scroll() != null) {
            void var8_9;
            topDocs = context.queryResult().topDocs().topDocs;
            docIdsToLoad = new int[topDocs.scoreDocs.length + numSuggestDocs];
            boolean bl = false;
            while (var8_9 < topDocs.scoreDocs.length) {
                docIdsToLoad[docsOffset++] = topDocs.scoreDocs[var8_9].doc;
                ++var8_9;
            }
        } else {
            topDocs = context.queryResult().topDocs().topDocs;
            if (topDocs.scoreDocs.length < context.from()) {
                docIdsToLoad = new int[numSuggestDocs];
            } else {
                int n = context.from() + context.size();
                docIdsToLoad = new int[Math.min(topDocs.scoreDocs.length - context.from(), context.size()) + numSuggestDocs];
                for (int i = context.from(); i < Math.min(n, topDocs.scoreDocs.length); ++i) {
                    docIdsToLoad[docsOffset++] = topDocs.scoreDocs[i].doc;
                }
            }
        }
        for (CompletionSuggestion completionSuggestion : completionSuggestions) {
            for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                docIdsToLoad[docsOffset++] = option.getDoc().doc;
            }
        }
        context.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
    }

    private void processScroll(InternalScrollSearchRequest request, ReaderContext reader, SearchContext context) {
        context.from(context.from() + context.size());
        context.scrollContext().scroll = request.scroll();
    }

    public int getActiveContexts() {
        return this.activeReaders.size();
    }

    public ResponseCollectorService getResponseCollectorService() {
        return this.responseCollectorService;
    }

    public AliasFilter buildAliasFilter(ClusterState state, String index, Set<String> resolvedExpressions) {
        return this.indicesService.buildAliasFilter(state, index, resolvedExpressions);
    }

    public void canMatch(ShardSearchRequest request, ActionListener<CanMatchResponse> listener) {
        try {
            listener.onResponse(this.canMatch(request));
        }
        catch (IOException e) {
            listener.onFailure(e);
        }
    }

    public CanMatchResponse canMatch(ShardSearchRequest request) throws IOException {
        return this.canMatch(request, true);
    }

    private CanMatchResponse canMatch(ShardSearchRequest request, boolean checkRefreshPending) throws IOException {
        Releasable markAsUsed;
        assert (request.searchType() == SearchType.QUERY_THEN_FETCH) : "unexpected search type: " + String.valueOf((Object)request.searchType());
        ReaderContext readerContext = request.readerId() != null ? this.findReaderContext(request.readerId(), request) : null;
        try (Releasable ignored = markAsUsed = readerContext != null ? readerContext.markAsUsed(this.getKeepAlive(request)) : () -> {};){
            boolean hasRefreshPending;
            Engine.Searcher canMatchSearcher;
            IndexService indexService;
            if (readerContext != null) {
                indexService = readerContext.indexService();
                canMatchSearcher = readerContext.acquireSearcher("can_match");
                hasRefreshPending = false;
            } else {
                indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
                IndexShard indexShard = indexService.getShard(request.shardId().getId());
                hasRefreshPending = indexShard.hasRefreshPending() && checkRefreshPending;
                canMatchSearcher = indexShard.acquireSearcher("can_match");
            }
            Engine.Searcher ignored2 = canMatchSearcher;
            try {
                boolean canMatch;
                MinAndMax<?> minMax;
                QueryShardContext context = indexService.newQueryShardContext(request.shardId().id(), canMatchSearcher, request::nowInMillis, request.getClusterAlias());
                Rewriteable.rewrite(request.getRewriteable(), context, false);
                boolean aliasFilterCanMatch = !(request.getAliasFilter().getQueryBuilder() instanceof MatchNoneQueryBuilder);
                FieldSortBuilder sortBuilder = FieldSortBuilder.getPrimaryFieldSortOrNull(request.source());
                MinAndMax<?> minAndMax = minMax = sortBuilder != null ? FieldSortBuilder.getMinMaxOrNull(context, sortBuilder) : null;
                if (SearchService.canRewriteToMatchNone(request.source())) {
                    QueryBuilder queryBuilder = request.source().query();
                    canMatch = aliasFilterCanMatch && !(queryBuilder instanceof MatchNoneQueryBuilder);
                } else {
                    canMatch = aliasFilterCanMatch;
                }
                FieldDoc searchAfterFieldDoc = SearchService.getSearchAfterFieldDoc(request, context);
                Integer trackTotalHitsUpto = request.source() == null ? null : request.source().trackTotalHitsUpTo();
                canMatch = canMatch && SearchService.canMatchSearchAfter(searchAfterFieldDoc, minMax, sortBuilder, trackTotalHitsUpto);
                CanMatchResponse canMatchResponse = new CanMatchResponse(canMatch || hasRefreshPending, minMax);
                if (ignored2 != null) {
                    ignored2.close();
                }
                return canMatchResponse;
            }
            catch (Throwable throwable) {
                if (ignored2 != null) {
                    try {
                        ignored2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static boolean canMatchSearchAfter(FieldDoc searchAfter, MinAndMax<?> minMax, FieldSortBuilder primarySortField, Integer trackTotalHitsUpto) {
        if (searchAfter != null && minMax != null && primarySortField != null && primarySortField.missing() == null && Objects.equals(trackTotalHitsUpto, -1)) {
            Object searchAfterPrimary = searchAfter.fields[0];
            if (primarySortField.order() == SortOrder.DESC ? minMax.compareMin(searchAfterPrimary) > 0 : minMax.compareMax(searchAfterPrimary) < 0) {
                return false;
            }
        }
        return true;
    }

    private static FieldDoc getSearchAfterFieldDoc(ShardSearchRequest request, QueryShardContext context) throws IOException {
        if (context != null && request != null && request.source() != null && request.source().sorts() != null) {
            List<SortBuilder<?>> sorts = request.source().sorts();
            Object[] searchAfter = request.source().searchAfter();
            Optional<SortAndFormats> sortOpt = SortBuilder.buildSort(sorts, context);
            if (sortOpt.isPresent() && !CollectionUtils.isEmpty(searchAfter)) {
                return SearchAfterBuilder.buildFieldDoc(sortOpt.get(), searchAfter);
            }
        }
        return null;
    }

    public static boolean canRewriteToMatchNone(SearchSourceBuilder source) {
        if (source == null || source.query() == null || source.query() instanceof MatchAllQueryBuilder || source.suggest() != null) {
            return false;
        }
        AggregatorFactories.Builder aggregations = source.aggregations();
        return aggregations == null || !aggregations.mustVisitAllDocs();
    }

    private void rewriteAndFetchShardRequest(IndexShard shard, ShardSearchRequest request, ActionListener<ShardSearchRequest> listener) {
        ActionListener<Rewriteable> actionListener = ActionListener.wrap(r -> {
            if (request.readerId() != null) {
                listener.onResponse(request);
            } else {
                shard.awaitShardSearchActive(b -> listener.onResponse(request));
            }
        }, listener::onFailure);
        Rewriteable.rewriteAndFetch(request.getRewriteable(), this.indicesService.getRewriteContext(request::nowInMillis), actionListener);
    }

    public QueryRewriteContext getRewriteContext(LongSupplier nowInMillis) {
        return this.indicesService.getRewriteContext(nowInMillis);
    }

    public QueryRewriteContext getValidationRewriteContext(LongSupplier nowInMillis) {
        return this.indicesService.getValidationRewriteContext(nowInMillis);
    }

    public IndicesService getIndicesService() {
        return this.indicesService;
    }

    public InternalAggregation.ReduceContextBuilder aggReduceContextBuilder(final SearchSourceBuilder searchSourceBuilder) {
        return new InternalAggregation.ReduceContextBuilder(){

            @Override
            public InternalAggregation.ReduceContext forPartialReduction() {
                return InternalAggregation.ReduceContext.forPartialReduction(SearchService.this.bigArrays, SearchService.this.scriptService, () -> SearchService.requestToPipelineTree(searchSourceBuilder));
            }

            @Override
            public InternalAggregation.ReduceContext forFinalReduction() {
                PipelineAggregator.PipelineTree pipelineTree = SearchService.requestToPipelineTree(searchSourceBuilder);
                return InternalAggregation.ReduceContext.forFinalReduction(SearchService.this.bigArrays, SearchService.this.scriptService, SearchService.this.multiBucketConsumerService.create(), pipelineTree);
            }
        };
    }

    private static PipelineAggregator.PipelineTree requestToPipelineTree(SearchSourceBuilder searchSourceBuilder) {
        if (searchSourceBuilder == null || searchSourceBuilder.aggregations() == null) {
            return PipelineAggregator.PipelineTree.EMPTY;
        }
        return searchSourceBuilder.aggregations().buildPipelineTree();
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            for (ReaderContext context : SearchService.this.activeReaders.values()) {
                if (!context.isExpired()) continue;
                logger.debug("freeing search context [{}]", (Object)context.id());
                SearchService.this.freeReaderContext(context.id());
            }
        }
    }

    private static final class SearchOperationListenerExecutor
    implements AutoCloseable {
        private final SearchOperationListener listener;
        private final SearchContext context;
        private final long time;
        private final boolean fetch;
        private long afterQueryTime = -1L;
        private boolean closed = false;

        SearchOperationListenerExecutor(SearchContext context) {
            this(context, false, System.nanoTime());
        }

        SearchOperationListenerExecutor(SearchContext context, boolean fetch, long startTime) {
            this.listener = context.indexShard().getSearchOperationListener();
            this.context = context;
            this.time = startTime;
            this.fetch = fetch;
            if (fetch) {
                this.listener.onPreFetchPhase(context);
            } else {
                this.listener.onPreQueryPhase(context);
            }
        }

        long success() {
            this.afterQueryTime = System.nanoTime();
            return this.afterQueryTime;
        }

        @Override
        public void close() {
            assert (!this.closed) : "already closed - while technically ok double closing is a likely a bug in this case";
            if (!this.closed) {
                this.closed = true;
                if (this.afterQueryTime != -1L) {
                    if (this.fetch) {
                        this.listener.onFetchPhase(this.context, this.afterQueryTime - this.time);
                    } else {
                        this.listener.onQueryPhase(this.context, this.afterQueryTime - this.time);
                    }
                } else if (this.fetch) {
                    this.listener.onFailedFetchPhase(this.context);
                } else {
                    this.listener.onFailedQueryPhase(this.context);
                }
            }
        }
    }

    public static final class CanMatchResponse
    extends SearchPhaseResult {
        private final boolean canMatch;
        private final MinAndMax<?> estimatedMinAndMax;

        public CanMatchResponse(StreamInput in) throws IOException {
            super(in);
            this.canMatch = in.readBoolean();
            this.estimatedMinAndMax = in.getVersion().onOrAfter(LegacyESVersion.V_7_6_0) ? in.readOptionalWriteable(MinAndMax::new) : null;
        }

        public CanMatchResponse(boolean canMatch, MinAndMax<?> estimatedMinAndMax) {
            this.canMatch = canMatch;
            this.estimatedMinAndMax = estimatedMinAndMax;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.canMatch);
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
                out.writeOptionalWriteable(this.estimatedMinAndMax);
            }
        }

        public boolean canMatch() {
            return this.canMatch;
        }

        public MinAndMax<?> estimatedMinAndMax() {
            return this.estimatedMinAndMax;
        }
    }
}

