/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Collector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationCollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationReduceableSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.ReduceableSearchResult;

public class GlobalAggCollectorManager
extends AggregationCollectorManager {
    private Collector collector = Objects.requireNonNull(super.newCollector(), "collector instance is null");
    private final String collectorName = this.collector.toString();

    public GlobalAggCollectorManager(SearchContext context) throws IOException {
        super(context, context.aggregations().factories()::createTopLevelGlobalAggregators, "aggregation_global");
    }

    @Override
    public Collector newCollector() throws IOException {
        if (this.collector != null) {
            Collector toReturn = this.collector;
            this.collector = null;
            return toReturn;
        }
        return super.newCollector();
    }

    @Override
    public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
        if (this.context.searcher().getLeafContexts().isEmpty()) {
            for (Collector c : collectors) {
                this.context.bucketCollectorProcessor().processPostCollection(c);
            }
        }
        return super.reduce((Collection)collectors);
    }

    @Override
    protected AggregationReduceableSearchResult buildAggregationResult(InternalAggregations internalAggregations) {
        return new AggregationReduceableSearchResult(InternalAggregations.topLevelReduce(Collections.singletonList(internalAggregations), this.context.partialOnShard()));
    }

    @Override
    public String getCollectorName() {
        return this.collectorName;
    }
}

