/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationInitializationException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.SignificantTextAggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;

public class SignificantTextAggregationBuilder
extends AbstractAggregationBuilder<SignificantTextAggregationBuilder> {
    public static final String NAME = "significant_text";
    static final ParseField FIELD_NAME = new ParseField("field", new String[0]);
    static final ParseField SOURCE_FIELDS_NAME = new ParseField("source_fields", new String[0]);
    static final ParseField FILTER_DUPLICATE_TEXT_FIELD_NAME = new ParseField("filter_duplicate_text", new String[0]);
    static final TermsAggregator.BucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS;
    static final SignificanceHeuristic DEFAULT_SIGNIFICANCE_HEURISTIC = SignificantTermsAggregationBuilder.DEFAULT_SIGNIFICANCE_HEURISTIC;
    private String fieldName = null;
    private String[] sourceFieldNames = null;
    private boolean filterDuplicateText = false;
    private IncludeExclude includeExclude = null;
    private QueryBuilder filterBuilder = null;
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);
    private SignificanceHeuristic significanceHeuristic = DEFAULT_SIGNIFICANCE_HEURISTIC;
    private static final ObjectParser<SignificantTextAggregationBuilder, Void> PARSER = new ObjectParser("significant_text", SignificanceHeuristic.class, SignificantTextAggregationBuilder::significanceHeuristic, null);

    public static SignificantTextAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new SignificantTextAggregationBuilder(aggregationName, null), null);
    }

    protected SignificantTextAggregationBuilder(SignificantTextAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(clone.bucketCountThresholds);
        this.fieldName = clone.fieldName;
        this.filterBuilder = clone.filterBuilder;
        this.filterDuplicateText = clone.filterDuplicateText;
        this.includeExclude = clone.includeExclude;
        this.significanceHeuristic = clone.significanceHeuristic;
        this.sourceFieldNames = clone.sourceFieldNames;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new SignificantTextAggregationBuilder(this, factoriesBuilder, metadata);
    }

    protected TermsAggregator.BucketCountThresholds getBucketCountThresholds() {
        return new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
    }

    public TermsAggregator.BucketCountThresholds bucketCountThresholds() {
        return this.bucketCountThresholds;
    }

    @Override
    public SignificantTextAggregationBuilder subAggregations(AggregatorFactories.Builder subFactories) {
        throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
    }

    @Override
    public SignificantTextAggregationBuilder subAggregation(AggregationBuilder aggregation) {
        throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
    }

    public SignificantTextAggregationBuilder bucketCountThresholds(TermsAggregator.BucketCountThresholds bucketCountThresholds) {
        if (bucketCountThresholds == null) {
            throw new IllegalArgumentException("[bucketCountThresholds] must not be null: [" + this.name + "]");
        }
        this.bucketCountThresholds = bucketCountThresholds;
        return this;
    }

    public SignificantTextAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public SignificantTextAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than  0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public SignificantTextAggregationBuilder fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public SignificantTextAggregationBuilder sourceFieldNames(List<String> names) {
        this.sourceFieldNames = names.toArray(new String[names.size()]);
        return this;
    }

    public SignificantTextAggregationBuilder filterDuplicateText(boolean filterDuplicateText) {
        this.filterDuplicateText = filterDuplicateText;
        return this;
    }

    public SignificantTextAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public SignificantTextAggregationBuilder shardMinDocCount(long shardMinDocCount) {
        if (shardMinDocCount < 0L) {
            throw new IllegalArgumentException("[shardMinDocCount] must be greater than or equal to 0. Found [" + shardMinDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    public SignificantTextAggregationBuilder backgroundFilter(QueryBuilder backgroundFilter) {
        if (backgroundFilter == null) {
            throw new IllegalArgumentException("[backgroundFilter] must not be null: [" + this.name + "]");
        }
        this.filterBuilder = backgroundFilter;
        return this;
    }

    public QueryBuilder backgroundFilter() {
        return this.filterBuilder;
    }

    public SignificantTextAggregationBuilder includeExclude(IncludeExclude includeExclude) {
        this.includeExclude = includeExclude;
        return this;
    }

    public IncludeExclude includeExclude() {
        return this.includeExclude;
    }

    public SignificantTextAggregationBuilder significanceHeuristic(SignificanceHeuristic significanceHeuristic) {
        if (significanceHeuristic == null) {
            throw new IllegalArgumentException("[significanceHeuristic] must not be null: [" + this.name + "]");
        }
        this.significanceHeuristic = significanceHeuristic;
        return this;
    }

    public SignificanceHeuristic significanceHeuristic() {
        return this.significanceHeuristic;
    }

    public SignificantTextAggregationBuilder(String name, String fieldName) {
        super(name);
        this.fieldName = fieldName;
    }

    public SignificantTextAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.filterDuplicateText = in.readBoolean();
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(in);
        this.filterBuilder = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.includeExclude = in.readOptionalWriteable(IncludeExclude::new);
        this.significanceHeuristic = in.readNamedWriteable(SignificanceHeuristic.class);
        this.sourceFieldNames = in.readOptionalStringArray();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeBoolean(this.filterDuplicateText);
        this.bucketCountThresholds.writeTo(out);
        out.writeOptionalNamedWriteable(this.filterBuilder);
        out.writeOptionalWriteable(this.includeExclude);
        out.writeNamedWriteable(this.significanceHeuristic);
        out.writeOptionalStringArray(this.sourceFieldNames);
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        SignificanceHeuristic executionHeuristic = this.significanceHeuristic.rewrite(queryShardContext);
        return new SignificantTextAggregatorFactory(this.name, this.includeExclude, this.filterBuilder, this.bucketCountThresholds, executionHeuristic, queryShardContext, parent, subFactoriesBuilder, this.fieldName, this.sourceFieldNames, this.filterDuplicateText, this.metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.bucketCountThresholds.toXContent(builder, params);
        if (this.fieldName != null) {
            builder.field(FIELD_NAME.getPreferredName(), this.fieldName);
        }
        if (this.sourceFieldNames != null) {
            builder.array(SOURCE_FIELDS_NAME.getPreferredName(), this.sourceFieldNames);
        }
        if (this.filterDuplicateText) {
            builder.field(FILTER_DUPLICATE_TEXT_FIELD_NAME.getPreferredName(), this.filterDuplicateText);
        }
        if (this.filterBuilder != null) {
            builder.field(SignificantTermsAggregationBuilder.BACKGROUND_FILTER.getPreferredName(), this.filterBuilder);
        }
        if (this.includeExclude != null) {
            this.includeExclude.toXContent(builder, params);
        }
        this.significanceHeuristic.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketCountThresholds, this.fieldName, this.filterDuplicateText, this.filterBuilder, this.includeExclude, this.significanceHeuristic, Arrays.hashCode(this.sourceFieldNames));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SignificantTextAggregationBuilder other = (SignificantTextAggregationBuilder)obj;
        return Objects.equals(this.bucketCountThresholds, other.bucketCountThresholds) && Objects.equals(this.fieldName, other.fieldName) && Arrays.equals(this.sourceFieldNames, other.sourceFieldNames) && this.filterDuplicateText == other.filterDuplicateText && Objects.equals(this.filterBuilder, other.filterBuilder) && Objects.equals(this.includeExclude, other.includeExclude) && Objects.equals(this.significanceHeuristic, other.significanceHeuristic);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        PARSER.declareInt(SignificantTextAggregationBuilder::shardSize, TermsAggregationBuilder.SHARD_SIZE_FIELD_NAME);
        PARSER.declareLong(SignificantTextAggregationBuilder::minDocCount, TermsAggregationBuilder.MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareLong(SignificantTextAggregationBuilder::shardMinDocCount, TermsAggregationBuilder.SHARD_MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareInt(SignificantTextAggregationBuilder::size, TermsAggregationBuilder.REQUIRED_SIZE_FIELD_NAME);
        PARSER.declareString(SignificantTextAggregationBuilder::fieldName, FIELD_NAME);
        PARSER.declareStringArray(SignificantTextAggregationBuilder::sourceFieldNames, SOURCE_FIELDS_NAME);
        PARSER.declareBoolean(SignificantTextAggregationBuilder::filterDuplicateText, FILTER_DUPLICATE_TEXT_FIELD_NAME);
        PARSER.declareObject(SignificantTextAggregationBuilder::backgroundFilter, (p, context) -> AbstractQueryBuilder.parseInnerQueryBuilder(p), SignificantTermsAggregationBuilder.BACKGROUND_FILTER);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge(v, b.includeExclude())), IncludeExclude::parseInclude, IncludeExclude.INCLUDE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge(b.includeExclude(), v)), IncludeExclude::parseExclude, IncludeExclude.EXCLUDE_FIELD, ObjectParser.ValueType.STRING_ARRAY);
    }
}

