/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Collector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectorManager;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.ConcurrentAggregationProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ContextIndexSearcher;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.query.ProfileCollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryCollectorContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryCollectorManagerContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryPhaseExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QuerySearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.ReduceableSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.RescoringQueryCollectorContext;

public class ConcurrentQueryPhaseSearcher
extends QueryPhase.DefaultQueryPhaseSearcher {
    private static final Logger LOGGER = LogManager.getLogger(ConcurrentQueryPhaseSearcher.class);
    private final AggregationProcessor aggregationProcessor = new ConcurrentAggregationProcessor();

    @Override
    protected boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, QueryCollectorContext queryCollectorContext, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
        return ConcurrentQueryPhaseSearcher.searchWithCollectorManager(searchContext, searcher, query, collectors, queryCollectorContext, hasFilterCollector, hasTimeout);
    }

    private static boolean searchWithCollectorManager(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectorContexts, QueryCollectorContext queryCollectorContext, boolean hasFilterCollector, boolean timeoutSet) throws IOException {
        CollectorManager<? extends Collector, ReduceableSearchResult> collectorManager;
        collectorContexts.addFirst(Objects.requireNonNull(queryCollectorContext));
        QuerySearchResult queryResult = searchContext.queryResult();
        if (searchContext.getProfilers() != null) {
            ProfileCollectorManager<? extends Collector, ReduceableSearchResult> profileCollectorManager = QueryCollectorManagerContext.createQueryCollectorManagerWithProfiler(collectorContexts);
            searchContext.getProfilers().getCurrentQueryProfiler().setCollector(profileCollectorManager);
            collectorManager = profileCollectorManager;
        } else {
            collectorManager = QueryCollectorManagerContext.createQueryCollectorManager(collectorContexts);
        }
        try {
            ReduceableSearchResult result = searcher.search(query, collectorManager);
            result.reduce(queryResult);
        }
        catch (RuntimeException re) {
            ConcurrentQueryPhaseSearcher.rethrowCauseIfPossible(re, searchContext);
        }
        if (searchContext.isSearchTimedOut()) {
            assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
            if (!searchContext.request().allowPartialSearchResults()) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Time exceeded");
            }
            queryResult.searchTimedOut(true);
        }
        if (searchContext.terminateAfter() != 0 && queryResult.terminatedEarly() == null) {
            queryResult.terminatedEarly(false);
        }
        if (queryCollectorContext instanceof RescoringQueryCollectorContext) {
            return ((RescoringQueryCollectorContext)((Object)queryCollectorContext)).shouldRescore();
        }
        return false;
    }

    @Override
    public AggregationProcessor aggregationProcessor(SearchContext searchContext) {
        return this.aggregationProcessor;
    }

    private static <T extends Exception> void rethrowCauseIfPossible(RuntimeException re, SearchContext searchContext) throws T {
        Throwable t;
        if (re.getCause() == null || re instanceof OpenSearchException) {
            throw re;
        }
        if ((re.getCause() instanceof ExecutionException || re.getCause() instanceof InterruptedException) && (t = re.getCause()).getCause() != null) {
            throw (Exception)t.getCause();
        }
        throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Failed to execute concurrent segment search thread", re.getCause());
    }
}

