/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.suggest.completion;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.FieldMemoryStats;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class CompletionStats
implements Writeable,
ToXContentFragment {
    private static final String COMPLETION = "completion";
    private static final String SIZE_IN_BYTES = "size_in_bytes";
    private static final String SIZE = "size";
    private static final String FIELDS = "fields";
    private long sizeInBytes;
    @Nullable
    private FieldMemoryStats fields;

    public CompletionStats() {
    }

    public CompletionStats(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        this.fields = in.readOptionalWriteable(FieldMemoryStats::new);
    }

    public CompletionStats(long size, @Nullable FieldMemoryStats fields) {
        this.sizeInBytes = size;
        this.fields = fields;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue getSize() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public FieldMemoryStats getFields() {
        return this.fields;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        out.writeOptionalWriteable(this.fields);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(COMPLETION);
        builder.humanReadableField(SIZE_IN_BYTES, SIZE, this.getSize());
        if (this.fields != null) {
            this.fields.toXContent(builder, FIELDS, SIZE_IN_BYTES, SIZE);
        }
        builder.endObject();
        return builder;
    }

    public void add(CompletionStats completion) {
        if (completion == null) {
            return;
        }
        this.sizeInBytes += completion.getSizeInBytes();
        if (completion.fields != null) {
            if (this.fields == null) {
                this.fields = completion.fields.copy();
            } else {
                this.fields.add(completion.fields);
            }
        }
    }
}

