/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.semver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.semver.expr.Caret;
import org.graylog.shaded.opensearch2.org.opensearch.semver.expr.Equal;
import org.graylog.shaded.opensearch2.org.opensearch.semver.expr.Expression;
import org.graylog.shaded.opensearch2.org.opensearch.semver.expr.Tilde;

@PublicApi(since="2.13.0")
public class SemverRange
implements ToXContentFragment {
    private final Version rangeVersion;
    private final RangeOperator rangeOperator;

    public SemverRange(Version rangeVersion, RangeOperator rangeOperator) {
        this.rangeVersion = rangeVersion;
        this.rangeOperator = rangeOperator;
    }

    public static SemverRange fromString(String range) {
        RangeOperator rangeOperator = RangeOperator.fromRange(range);
        String version = range.replaceFirst(rangeOperator.asEscapedString(), "");
        if (!Version.stringHasLength(version)) {
            throw new IllegalArgumentException("Version cannot be empty");
        }
        return new SemverRange(Version.fromString(version), rangeOperator);
    }

    public RangeOperator getRangeOperator() {
        return this.rangeOperator;
    }

    public Version getRangeVersion() {
        return this.rangeVersion;
    }

    public boolean isSatisfiedBy(String versionToEvaluate) {
        return this.isSatisfiedBy(Version.fromString(versionToEvaluate));
    }

    public boolean isSatisfiedBy(Version versionToEvaluate) {
        return this.rangeOperator.expression.evaluate(this.rangeVersion, versionToEvaluate);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemverRange range = (SemverRange)o;
        return Objects.equals(this.rangeVersion, range.rangeVersion) && this.rangeOperator == range.rangeOperator;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rangeVersion, this.rangeOperator});
    }

    public String toString() {
        return this.rangeOperator.asString() + String.valueOf(this.rangeVersion);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public static enum RangeOperator {
        EQ("=", new Equal()),
        TILDE("~", new Tilde()),
        CARET("^", new Caret()),
        DEFAULT("", new Equal());

        private final String operator;
        private final Expression expression;

        private RangeOperator(String operator, Expression expression) {
            this.operator = operator;
            this.expression = expression;
        }

        public String asString() {
            return this.operator;
        }

        public String asEscapedString() {
            if (Objects.equals(this.operator, "^")) {
                return "\\^";
            }
            return this.operator;
        }

        public static RangeOperator fromRange(String range) {
            Optional<RangeOperator> rangeOperator = Arrays.stream(RangeOperator.values()).filter(operator -> operator != DEFAULT && range.startsWith(operator.asString())).findFirst();
            return rangeOperator.orElse(DEFAULT);
        }
    }
}

