/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.channels;

import java.io.IOException;
import java.util.Optional;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Span;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanScope;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Tracer;
import org.graylog.shaded.opensearch2.org.opensearch.transport.BaseTcpTransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TcpTransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportChannel;

public class TraceableTcpTransportChannel
extends BaseTcpTransportChannel {
    private final TransportChannel delegate;
    private final Span span;
    private final Tracer tracer;

    public TraceableTcpTransportChannel(TcpTransportChannel delegate, Span span, Tracer tracer) {
        super(delegate.getChannel());
        this.delegate = delegate;
        this.span = span;
        this.tracer = tracer;
    }

    public static TransportChannel create(TcpTransportChannel delegate, final Span span, Tracer tracer) {
        if (tracer.isRecording()) {
            delegate.getChannel().addCloseListener(new ActionListener<Void>(){

                @Override
                public void onResponse(Void unused) {
                    this.onFailure(null);
                }

                @Override
                public void onFailure(Exception e) {
                    span.addEvent("The TransportChannel was closed without sending the response");
                    span.setError(e);
                    span.endSpan();
                }
            });
            return new TraceableTcpTransportChannel(delegate, span, tracer);
        }
        return delegate;
    }

    @Override
    public String getProfileName() {
        return this.delegate.getProfileName();
    }

    @Override
    public String getChannelType() {
        return this.delegate.getChannelType();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.sendResponse(response);
        }
        catch (IOException ex) {
            this.span.setError(ex);
            throw ex;
        }
        finally {
            this.span.endSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(Exception exception) throws IOException {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.sendResponse(exception);
        }
        finally {
            this.span.setError(exception);
            this.span.endSpan();
        }
    }

    @Override
    public Version getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public <T> Optional<T> get(String name, Class<T> clazz) {
        return this.delegate.get(name, clazz);
    }
}

