/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.listener;

import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestOperationsListener;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Span;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanContext;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Tracer;

public final class TraceableSearchRequestOperationsListener
extends SearchRequestOperationsListener {
    private final Tracer tracer;
    private final Span requestSpan;
    private SpanContext phaseSpanContext;

    public TraceableSearchRequestOperationsListener(Tracer tracer, Span requestSpan) {
        this.tracer = tracer;
        this.requestSpan = requestSpan;
        this.phaseSpanContext = null;
    }

    public static SearchRequestOperationsListener create(Tracer tracer, Span requestSpan) {
        if (tracer.isRecording()) {
            return new TraceableSearchRequestOperationsListener(tracer, requestSpan);
        }
        return SearchRequestOperationsListener.NOOP;
    }

    @Override
    protected void onPhaseStart(SearchPhaseContext context) {
        assert (this.phaseSpanContext == null) : "There should be only one search phase active at a time";
        this.phaseSpanContext = this.tracer.getCurrentSpan();
    }

    @Override
    protected void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        assert (this.phaseSpanContext != null) : "There should be a search phase active at that time";
        this.phaseSpanContext.endSpan();
        this.phaseSpanContext = null;
    }

    @Override
    protected void onPhaseFailure(SearchPhaseContext context, Throwable cause) {
        assert (this.phaseSpanContext != null) : "There should be a search phase active at that time";
        this.phaseSpanContext.setError((Exception)cause);
        this.phaseSpanContext.endSpan();
        this.phaseSpanContext = null;
    }

    @Override
    public void onRequestStart(SearchRequestContext searchRequestContext) {
    }

    @Override
    public void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        this.requestSpan.addAttribute("total_hits", searchRequestContext.totalHits() == null ? 0L : searchRequestContext.totalHits().value);
    }
}

