/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.transport;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.ReleasableBytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.PageCacheRecycler;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.breaker.CircuitBreaker;
import org.graylog.shaded.opensearch2.org.opensearch.transport.InboundAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.transport.InboundBytesHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.InboundDecoder;
import org.graylog.shaded.opensearch2.org.opensearch.transport.ProtocolInboundMessage;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RequestHandlerRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.transport.StatsTracker;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TcpChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.nativeprotocol.NativeInboundBytesHandler;

public class InboundPipeline
implements Releasable {
    private final LongSupplier relativeTimeInMillis;
    private final StatsTracker statsTracker;
    private final InboundDecoder decoder;
    private final InboundAggregator aggregator;
    private Exception uncaughtException;
    private final ArrayDeque<ReleasableBytesReference> pending = new ArrayDeque(2);
    private boolean isClosed = false;
    private final BiConsumer<TcpChannel, ProtocolInboundMessage> messageHandler;
    private final List<InboundBytesHandler> protocolBytesHandlers;
    private InboundBytesHandler currentHandler;

    public InboundPipeline(Version version, StatsTracker statsTracker, PageCacheRecycler recycler, LongSupplier relativeTimeInMillis, Supplier<CircuitBreaker> circuitBreaker, Function<String, RequestHandlerRegistry<TransportRequest>> registryFunction, BiConsumer<TcpChannel, ProtocolInboundMessage> messageHandler) {
        this(statsTracker, relativeTimeInMillis, new InboundDecoder(version, recycler), new InboundAggregator(circuitBreaker, registryFunction), messageHandler);
    }

    public InboundPipeline(StatsTracker statsTracker, LongSupplier relativeTimeInMillis, InboundDecoder decoder, InboundAggregator aggregator, BiConsumer<TcpChannel, ProtocolInboundMessage> messageHandler) {
        this.relativeTimeInMillis = relativeTimeInMillis;
        this.statsTracker = statsTracker;
        this.decoder = decoder;
        this.aggregator = aggregator;
        this.protocolBytesHandlers = List.of(new NativeInboundBytesHandler(this.pending, decoder, aggregator, statsTracker));
        this.messageHandler = messageHandler;
    }

    @Override
    public void close() {
        this.isClosed = true;
        if (this.currentHandler != null) {
            this.currentHandler.close();
            this.currentHandler = null;
        }
        Releasables.closeWhileHandlingException(this.decoder, this.aggregator);
        Releasables.closeWhileHandlingException(this.pending);
        this.pending.clear();
    }

    public void handleBytes(TcpChannel channel, ReleasableBytesReference reference) throws IOException {
        if (this.uncaughtException != null) {
            throw new IllegalStateException("Pipeline state corrupted by uncaught exception", this.uncaughtException);
        }
        try {
            this.doHandleBytes(channel, reference);
        }
        catch (Exception e) {
            this.uncaughtException = e;
            throw e;
        }
    }

    public void doHandleBytes(TcpChannel channel, ReleasableBytesReference reference) throws IOException {
        channel.getChannelStats().markAccessed(this.relativeTimeInMillis.getAsLong());
        this.statsTracker.markBytesRead(reference.length());
        this.pending.add(reference.retain());
        if (this.currentHandler == null) {
            for (InboundBytesHandler handler : this.protocolBytesHandlers) {
                if (!handler.canHandleBytes(reference)) continue;
                this.currentHandler = handler;
                break;
            }
        }
        if (this.currentHandler == null) {
            throw new IllegalStateException("No bytes handler found for the incoming transport protocol");
        }
        this.currentHandler.doHandleBytes(channel, reference, this.messageHandler);
    }
}

