/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.reactor.core.CoreSubscriber;
import org.graylog.shaded.opensearch2.reactor.core.Scannable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Mono;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Operators;
import org.graylog.shaded.opensearch2.reactor.core.publisher.SourceProducer;
import org.graylog.shaded.opensearch2.reactor.util.context.Context;
import org.graylog.shaded.opensearch2.reactor.util.context.ContextView;

final class MonoDeferContextual<T>
extends Mono<T>
implements SourceProducer<T> {
    final Function<ContextView, ? extends Mono<? extends T>> contextualMonoFactory;

    MonoDeferContextual(Function<ContextView, ? extends Mono<? extends T>> contextualMonoFactory) {
        this.contextualMonoFactory = Objects.requireNonNull(contextualMonoFactory, "contextualMonoFactory");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Mono<T> p;
        Context ctx = actual.currentContext();
        try {
            p = Objects.requireNonNull(this.contextualMonoFactory.apply(ctx), "The Mono returned by the contextualMonoFactory is null");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, ctx));
            return;
        }
        p.subscribe(actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

