/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.publisher;

import java.util.Objects;
import org.graylog.shaded.opensearch2.org.reactivestreams.Publisher;
import org.graylog.shaded.opensearch2.reactor.core.CorePublisher;
import org.graylog.shaded.opensearch2.reactor.core.CoreSubscriber;
import org.graylog.shaded.opensearch2.reactor.core.Scannable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Mono;
import org.graylog.shaded.opensearch2.reactor.core.publisher.MonoIgnoreElements;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Operators;
import org.graylog.shaded.opensearch2.reactor.core.publisher.OptimizableOperator;
import org.graylog.shaded.opensearch2.reactor.util.annotation.Nullable;

final class MonoIgnorePublisher<T>
extends Mono<T>
implements Scannable,
OptimizableOperator<T, T> {
    final Publisher<? extends T> source;
    @Nullable
    final OptimizableOperator<?, T> optimizableOperator;

    MonoIgnorePublisher(Publisher<? extends T> source) {
        OptimizableOperator optimSource;
        this.source = Objects.requireNonNull(source, "publisher");
        this.optimizableOperator = source instanceof OptimizableOperator ? (optimSource = (OptimizableOperator)source) : null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        try {
            this.source.subscribe(this.subscribeOrReturn((CoreSubscriber<? super T>)actual));
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
    }

    @Override
    public final CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) throws Throwable {
        return new MonoIgnoreElements.IgnoreElementsSubscriber<T>(actual);
    }

    @Override
    public final CorePublisher<? extends T> source() {
        return this;
    }

    @Override
    public final OptimizableOperator<?, ? extends T> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

