/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.carrotsearch.hppc;

import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.HashOrderMixing;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.LongDoubleHashMap;

public class LongDoubleScatterMap
extends LongDoubleHashMap {
    public LongDoubleScatterMap() {
        this(4);
    }

    public LongDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(long key) {
        return BitMixer.mixPhi(key);
    }

    public static LongDoubleScatterMap from(long[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongDoubleScatterMap map = new LongDoubleScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

