/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.carrotsearch.hppc;

import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.HashOrderMixing;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.HashOrderMixingStrategy;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.ObjectFloatAssociativeContainer;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.ObjectFloatHashMap;

public class ObjectFloatIdentityHashMap<KType>
extends ObjectFloatHashMap<KType> {
    public ObjectFloatIdentityHashMap() {
        this(4);
    }

    public ObjectFloatIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectFloatIdentityHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.randomized());
    }

    public ObjectFloatIdentityHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectFloatIdentityHashMap(ObjectFloatAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(System.identityHashCode(key), this.keyMixer);
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectFloatIdentityHashMap<KType> from(KType[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectFloatIdentityHashMap<KType> map = new ObjectFloatIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

