/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.el;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.el.GreekStemmer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class GreekStemFilter
extends TokenFilter {
    private final GreekStemmer stemmer = new GreekStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public GreekStemFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

