/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.hunspell.FlagEnumerator;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.hunspell.GeneratingSuggester;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteArrayDataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteArrayDataOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.CharsRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IntsRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IntsRefBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.fst.IntSequenceOutputs;

class WordStorage {
    private static final int OFFSET_BITS = 25;
    private static final int OFFSET_MASK = 0x1FFFFFF;
    private static final int COLLISION_MASK = 64;
    private static final int SUGGESTIBLE_MASK = 32;
    private static final int MAX_STORED_LENGTH = 31;
    private final int maxEntryLength;
    private final boolean hasCustomMorphData;
    private final int[] hashTable;
    private final byte[] wordData;

    private WordStorage(int maxEntryLength, boolean hasCustomMorphData, int[] hashTable, byte[] wordData) {
        this.maxEntryLength = maxEntryLength;
        this.hasCustomMorphData = hasCustomMorphData;
        this.hashTable = hashTable;
        this.wordData = wordData;
    }

    IntsRef lookupWord(char[] word, int offset, int length) {
        boolean last;
        assert (length > 0);
        int hash = Math.abs(CharsRef.stringHashCode(word, offset, length) % this.hashTable.length);
        int entryCode = this.hashTable[hash];
        if (entryCode == 0) {
            return null;
        }
        int pos = entryCode & 0x1FFFFFF;
        int mask = entryCode >>> 25;
        char lastChar = word[offset + length - 1];
        ByteArrayDataInput in = new ByteArrayDataInput(this.wordData);
        do {
            boolean mightMatch;
            in.setPosition(pos);
            char c = (char)in.readVInt();
            int prevPos = pos - in.readVInt();
            last = !WordStorage.hasCollision(mask);
            boolean bl = mightMatch = c == lastChar && this.hasLength(mask, length);
            if (!last) {
                mask = in.readByte();
                pos -= in.readVInt();
            }
            if (!mightMatch) continue;
            int beforeForms = in.getPosition();
            if (!this.isSameString(word, offset, length - 1, prevPos, in)) continue;
            in.setPosition(beforeForms);
            int formLength = in.readVInt();
            IntsRef forms = new IntsRef(formLength);
            this.readForms(forms, in, formLength);
            return forms;
        } while (!last);
        return null;
    }

    private static boolean hasCollision(int mask) {
        return (mask & 0x40) != 0;
    }

    private static boolean hasSuggestibleEntries(int mask) {
        return (mask & 0x20) != 0;
    }

    void processSuggestibleWords(int minLength, int maxLength, BiConsumer<CharsRef, Supplier<IntsRef>> processor) {
        this.processAllWords(minLength, maxLength, true, processor);
    }

    void processAllWords(int minLength, int maxLength, boolean suggestibleOnly, BiConsumer<CharsRef, Supplier<IntsRef>> processor) {
        assert (minLength <= maxLength);
        maxLength = Math.min(this.maxEntryLength, maxLength);
        CharsRef chars = new CharsRef(maxLength);
        ByteArrayDataInput in = new ByteArrayDataInput(this.wordData);
        LazyFormReader formSupplier = new LazyFormReader(in);
        block0: for (int entryCode : this.hashTable) {
            int pos = entryCode & 0x1FFFFFF;
            int mask = entryCode >>> 25;
            while (pos != 0) {
                boolean mightMatch;
                int wordStart = maxLength - 1;
                in.setPosition(pos);
                chars.chars[wordStart] = (char)in.readVInt();
                int prevPos = pos - in.readVInt();
                boolean last = !WordStorage.hasCollision(mask);
                boolean bl = mightMatch = (!suggestibleOnly || WordStorage.hasSuggestibleEntries(mask)) && WordStorage.hasLengthInRange(mask, minLength, maxLength);
                if (!last) {
                    mask = in.readByte();
                    pos -= in.readVInt();
                }
                if (mightMatch) {
                    formSupplier.dataPos = in.getPosition();
                    while (prevPos != 0 && wordStart > 0) {
                        in.setPosition(prevPos);
                        chars.chars[--wordStart] = (char)in.readVInt();
                        prevPos -= in.readVInt();
                    }
                    if (prevPos == 0) {
                        chars.offset = wordStart;
                        chars.length = maxLength - wordStart;
                        processor.accept(chars, formSupplier);
                    }
                }
                if (!last) continue;
                continue block0;
            }
        }
    }

    private boolean hasLength(int mask, int length) {
        int lenCode = mask & 0x1F;
        return lenCode == 31 ? length >= 31 : lenCode == length;
    }

    private static boolean hasLengthInRange(int mask, int minLength, int maxLength) {
        int lenCode = mask & 0x1F;
        if (lenCode == 31) {
            return maxLength >= 31;
        }
        return lenCode >= minLength && lenCode <= maxLength;
    }

    private boolean isSameString(char[] word, int offset, int length, int dataPos, ByteArrayDataInput in) {
        for (int i = length - 1; i >= 0; --i) {
            in.setPosition(dataPos);
            char c = (char)in.readVInt();
            if (c != word[i + offset]) {
                return false;
            }
            if ((dataPos -= in.readVInt()) != 0) continue;
            return i == 0;
        }
        return length == 0 && dataPos == 0;
    }

    private void readForms(IntsRef forms, ByteArrayDataInput in, int length) {
        for (int i = 0; i < length; ++i) {
            forms.ints[i] = in.readVInt();
        }
        forms.length = length;
    }

    private class LazyFormReader
    implements Supplier<IntsRef> {
        int dataPos;
        private final ByteArrayDataInput in;
        private final IntsRef forms;

        LazyFormReader(ByteArrayDataInput in) {
            this.in = in;
            this.forms = new IntsRef();
        }

        @Override
        public IntsRef get() {
            this.in.setPosition(this.dataPos);
            int entryCount = this.in.readVInt() / (WordStorage.this.hasCustomMorphData ? 2 : 1);
            if (this.forms.ints.length < entryCount) {
                this.forms.ints = new int[entryCount];
            }
            for (int i = 0; i < entryCount; ++i) {
                this.forms.ints[i] = this.in.readVInt();
                if (!WordStorage.this.hasCustomMorphData) continue;
                this.in.readVInt();
            }
            this.forms.length = entryCount;
            return this.forms;
        }
    }

    static class Builder {
        private final boolean hasCustomMorphData;
        private final int[] hashTable;
        private byte[] wordData;
        private final char[] noSuggestFlags;
        private final int[] chainLengths;
        private final IntsRefBuilder currentOrds = new IntsRefBuilder();
        private final List<char[]> group = new ArrayList<char[]>();
        private final List<Integer> morphDataIDs = new ArrayList<Integer>();
        private String currentEntry = null;
        private final int wordCount;
        private final FlagEnumerator flagEnumerator;
        private final ByteArrayDataOutput dataWriter;
        private int commonPrefixLength;
        private int commonPrefixPos;
        private int actualWords;
        private int maxEntryLength;

        Builder(int wordCount, boolean hasCustomMorphData, FlagEnumerator flagEnumerator, char[] noSuggestFlags) {
            this.wordCount = wordCount;
            this.flagEnumerator = flagEnumerator;
            this.hasCustomMorphData = hasCustomMorphData;
            this.noSuggestFlags = noSuggestFlags;
            this.hashTable = new int[wordCount];
            this.wordData = new byte[wordCount * 6];
            this.dataWriter = new ByteArrayDataOutput(this.wordData){

                @Override
                public void writeByte(byte b) {
                    int pos = this.getPosition();
                    if (pos == wordData.length) {
                        wordData = ArrayUtil.grow(wordData);
                        this.reset(wordData, pos, wordData.length - pos);
                    }
                    super.writeByte(b);
                }
            };
            this.dataWriter.writeByte((byte)0);
            this.chainLengths = new int[this.hashTable.length];
        }

        void add(String entry, char[] flags, int morphDataID) throws IOException {
            this.maxEntryLength = Math.max(this.maxEntryLength, entry.length());
            if (!entry.equals(this.currentEntry)) {
                if (this.currentEntry != null) {
                    if (entry.compareTo(this.currentEntry) < 0) {
                        throw new IllegalArgumentException("out of order: " + entry + " < " + this.currentEntry);
                    }
                    int pos = this.flushGroup();
                    this.commonPrefixLength = GeneratingSuggester.commonPrefix(this.currentEntry, entry);
                    ByteArrayDataInput in = new ByteArrayDataInput(this.wordData);
                    in.setPosition(pos);
                    for (int i = this.currentEntry.length() - 1; i >= this.commonPrefixLength; --i) {
                        char c = (char)in.readVInt();
                        assert (c == this.currentEntry.charAt(i));
                        in.setPosition(pos -= in.readVInt());
                    }
                    this.commonPrefixPos = pos;
                }
                this.currentEntry = entry;
            }
            this.group.add(flags);
            if (this.hasCustomMorphData) {
                this.morphDataIDs.add(morphDataID);
            }
        }

        private int flushGroup() throws IOException {
            if (++this.actualWords > this.wordCount) {
                throw new RuntimeException("Don't add more words than wordCount!");
            }
            this.currentOrds.clear();
            boolean hasNonHidden = false;
            for (char[] flags2 : this.group) {
                if (Builder.hasFlag(flags2, '\uffe7')) continue;
                hasNonHidden = true;
                break;
            }
            for (int i = 0; i < this.group.size(); ++i) {
                char[] flags2;
                flags2 = this.group.get(i);
                if (hasNonHidden && Builder.hasFlag(flags2, '\uffe7')) continue;
                this.currentOrds.append(this.flagEnumerator.add(flags2));
                if (!this.hasCustomMorphData) continue;
                this.currentOrds.append(this.morphDataIDs.get(i));
            }
            int lastPos = this.commonPrefixPos;
            for (int i = this.commonPrefixLength; i < this.currentEntry.length() - 1; ++i) {
                int pos = this.dataWriter.getPosition();
                this.dataWriter.writeVInt(this.currentEntry.charAt(i));
                this.dataWriter.writeVInt(pos - lastPos);
                lastPos = pos;
            }
            int pos = this.dataWriter.getPosition();
            if (pos >= 0x2000000) {
                throw new RuntimeException("Too much word data, please report this to dev@lucene.apache.org");
            }
            int hash = Math.abs(this.currentEntry.hashCode() % this.hashTable.length);
            int prevCode = this.hashTable[hash];
            int mask = (prevCode == 0 ? 0 : 64) | (this.group.stream().anyMatch(flags -> !this.hasNoSuggestFlag((char[])flags)) ? 32 : 0) | Math.min(this.currentEntry.length(), 31);
            this.hashTable[hash] = mask << 25 | pos;
            int n = hash;
            this.chainLengths[n] = this.chainLengths[n] + 1;
            if (this.chainLengths[n] > 20) {
                throw new RuntimeException("Too many collisions, please report this to dev@lucene.apache.org");
            }
            this.dataWriter.writeVInt(this.currentEntry.charAt(this.currentEntry.length() - 1));
            this.dataWriter.writeVInt(pos - lastPos);
            if (prevCode != 0) {
                this.dataWriter.writeByte((byte)(prevCode >>> 25));
                this.dataWriter.writeVInt(pos - (prevCode & 0x1FFFFFF));
            }
            IntSequenceOutputs.getSingleton().write(this.currentOrds.get(), (DataOutput)this.dataWriter);
            this.group.clear();
            this.morphDataIDs.clear();
            return pos;
        }

        private boolean hasNoSuggestFlag(char[] flags) {
            for (char flag : flags) {
                if (!Builder.hasFlag(this.noSuggestFlags, flag)) continue;
                return true;
            }
            return false;
        }

        private static boolean hasFlag(char[] flags, char flag) {
            for (char f : flags) {
                if (f != flag) continue;
                return true;
            }
            return false;
        }

        WordStorage build() throws IOException {
            if (this.hashTable.length > 0) {
                assert (!this.group.isEmpty()) : "build() should be only called once";
                this.flushGroup();
            }
            byte[] trimmedData = ArrayUtil.copyOfSubArray(this.wordData, 0, this.dataWriter.getPosition());
            int[] table = this.hashTable.length == 0 ? new int[1] : this.hashTable;
            return new WordStorage(this.maxEntryLength, this.hasCustomMorphData, table, trimmedData);
        }
    }
}

