/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.synonym.word2vec;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.synonym.word2vec.TermAndBoost;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.synonym.word2vec.Word2VecModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorEncoding;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.NeighborQueue;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.RandomAccessVectorValues;

public class Word2VecSynonymProvider {
    private static final VectorSimilarityFunction SIMILARITY_FUNCTION = VectorSimilarityFunction.DOT_PRODUCT;
    private static final VectorEncoding VECTOR_ENCODING = VectorEncoding.FLOAT32;
    private final Word2VecModel word2VecModel;
    private final OnHeapHnswGraph hnswGraph;

    public Word2VecSynonymProvider(Word2VecModel model) throws IOException {
        this.word2VecModel = model;
        HnswGraphBuilder<float[]> builder = HnswGraphBuilder.create(this.word2VecModel, VECTOR_ENCODING, SIMILARITY_FUNCTION, 16, 100, HnswGraphBuilder.randSeed);
        this.hnswGraph = builder.build(this.word2VecModel.copy());
    }

    public List<TermAndBoost> getSynonyms(BytesRef term, int maxSynonymsPerTerm, float minAcceptedSimilarity) throws IOException {
        if (term == null) {
            throw new IllegalArgumentException("Term must not be null");
        }
        LinkedList<TermAndBoost> result = new LinkedList<TermAndBoost>();
        float[] query = this.word2VecModel.vectorValue(term);
        if (query != null) {
            NeighborQueue synonyms = HnswGraphSearcher.search(query, maxSynonymsPerTerm + 1, (RandomAccessVectorValues<float[]>)this.word2VecModel, VECTOR_ENCODING, SIMILARITY_FUNCTION, this.hnswGraph, null, Integer.MAX_VALUE);
            int size = synonyms.size();
            for (int i = 0; i < size; ++i) {
                float similarity = synonyms.topScore();
                int id = synonyms.pop();
                BytesRef synonym = this.word2VecModel.termValue(id);
                if (synonym.equals(term) || !(similarity >= minAcceptedSimilarity)) continue;
                result.addFirst(new TermAndBoost(synonym, similarity));
            }
        }
        return result;
    }
}

